/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.data.codegen.BaseQueryMethodsGenerator;
import io.helidon.data.codegen.DataCodegenTypes;
import io.helidon.data.codegen.common.MethodParams;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.parser.QueryParametersParser;
import java.util.ArrayList;
import java.util.List;

class QueryByJpqlMethodsGenerator
extends BaseQueryMethodsGenerator {
    private final QueryParametersParser parser = QueryParametersParser.create();
    private final List<TypedElementInfo> methods;

    private QueryByJpqlMethodsGenerator(RepositoryInfo repositoryInfo, List<TypedElementInfo> methods, ClassModel.Builder classModel, CodegenContext codegenContext, PersistenceGenerator persistenceGenerator) {
        super(repositoryInfo, classModel, codegenContext, persistenceGenerator);
        this.methods = methods;
    }

    static void generate(RepositoryInfo repositoryInfo, List<TypedElementInfo> methods, ClassModel.Builder classModel, CodegenContext codegenContext, PersistenceGenerator persistenceGenerator) {
        QueryByJpqlMethodsGenerator generator = new QueryByJpqlMethodsGenerator(repositoryInfo, methods, classModel, codegenContext, persistenceGenerator);
        generator.generate();
    }

    public void generate() {
        this.methods.forEach(this::addGeneratedMethod);
    }

    private static void generateQueryList(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByJpqlMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByJpqlMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteQueryList(b2, query, QueryByJpqlMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo)), (String)"executor"));
    }

    private static void generateQueryStream(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query) {
        QueryByJpqlMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByJpqlMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addExecuteQueryStream(b2, query, QueryByJpqlMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo)), (String)"executor"));
    }

    private static void generateQuerySlice(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query, MethodParams methodParams) {
        if (methodParams.pageRequest().isEmpty()) {
            throw new IllegalArgumentException("Method " + methodInfo.elementName() + " returns " + String.valueOf(query.returnType()) + ", but PageRequest parameter is missing");
        }
        TypedElementInfo pageRequest = (TypedElementInfo)methodParams.pageRequest().get();
        QueryByJpqlMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByJpqlMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addSessionLambda(b2, b3 -> {
            ((Method.Builder)b3.addContent(DataCodegenTypes.SLICE)).addContentLine(".create(");
            QueryByJpqlMethodsGenerator.increasePadding((Method.Builder)b3, (int)2);
            ((Method.Builder)b3.addContent(pageRequest.elementName())).addContentLine(",");
            statementGenerator.addQueryPage(b3, query, QueryByJpqlMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo), pageRequest.elementName() + ".offset()", pageRequest.elementName() + ".size()");
            b3.addContent(")");
            QueryByJpqlMethodsGenerator.decreasePadding((Method.Builder)b3, (int)2);
        }), (String)"executor"));
    }

    private static void generateQueryPage(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.StatementGenerator statementGenerator, PersistenceGenerator.Query query, MethodParams methodParams) {
        if (methodParams.pageRequest().isEmpty()) {
            throw new IllegalArgumentException("Method " + methodInfo.elementName() + " returns " + String.valueOf(query.returnType()) + ", but PageRequest parameter is missing");
        }
        TypedElementInfo pageRequest = (TypedElementInfo)methodParams.pageRequest().get();
        QueryByJpqlMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByJpqlMethodsGenerator.call((Method.Builder)b1, b2 -> statementGenerator.addSessionLambda(b2, b3 -> {
            ((Method.Builder)b3.addContent(DataCodegenTypes.PAGE)).addContentLine(".create(");
            QueryByJpqlMethodsGenerator.increasePadding((Method.Builder)b3, (int)2);
            ((Method.Builder)b3.addContent(pageRequest.elementName())).addContentLine(",");
            statementGenerator.addQueryPage(b3, query, QueryByJpqlMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo), pageRequest.elementName() + ".offset()", pageRequest.elementName() + ".size()");
            b3.addContentLine(",");
            statementGenerator.addQueryCount(b3, query);
            b3.addContent(")");
            QueryByJpqlMethodsGenerator.decreasePadding((Method.Builder)b3, (int)2);
        }), (String)"executor"));
    }

    private void addGeneratedMethod(TypedElementInfo methodInfo) {
        try {
            this.classModel().addMethod(builder -> this.generateMethod((Method.Builder)builder, methodInfo));
        }
        catch (CodegenException e) {
            throw e;
        }
        catch (Exception e) {
            String message = e.getMessage() != null && !e.getMessage().isEmpty() ? e.getMessage() : "Code generation of @Data.Query annotated method failed";
            throw new CodegenException(message, (Throwable)e, (Object)methodInfo.originatingElement());
        }
    }

    private void generateMethod(Method.Builder builder, TypedElementInfo methodInfo) {
        MethodParams methodParams = this.generateHeader(builder, methodInfo);
        this.codegenContext().logger().log(System.Logger.Level.TRACE, String.format("JPQL method %s", methodInfo.elementName()));
        if (methodParams.dynamic()) {
            throw new IllegalArgumentException("Method " + methodInfo.elementName() + " contains dynamic query parameter of type Sort");
        }
        String jpql = (String)methodInfo.annotation(DataCodegenTypes.QUERY_ANNOTATION).value().orElseThrow(() -> new CodegenException("@Data.Query annotation value is missing", (Object)methodInfo.originatingElement()));
        PersistenceGenerator.Query query = this.queryBuilder().buildQuery(jpql, this.parser.parse(jpql), this.params(methodParams));
        if (QueryByJpqlMethodsGenerator.isStream((TypeName)methodInfo.typeName())) {
            QueryByJpqlMethodsGenerator.generateQueryStream(builder, methodInfo, this.statementGenerator(), query);
        } else if (QueryByJpqlMethodsGenerator.isListOrCollection((TypeName)methodInfo.typeName())) {
            QueryByJpqlMethodsGenerator.generateQueryList(builder, methodInfo, this.statementGenerator(), query);
        } else if (methodInfo.typeName().isOptional()) {
            this.generateQueryOptional(builder, methodInfo, query);
        } else if (QueryByJpqlMethodsGenerator.isSlice((TypeName)methodInfo.typeName())) {
            QueryByJpqlMethodsGenerator.generateQuerySlice(builder, methodInfo, this.statementGenerator(), query, methodParams);
        } else if (QueryByJpqlMethodsGenerator.isPage((TypeName)methodInfo.typeName())) {
            QueryByJpqlMethodsGenerator.generateQueryPage(builder, methodInfo, this.statementGenerator(), query, methodParams);
        } else {
            this.generateQueryItem(builder, query, methodInfo.typeName());
        }
    }

    private void generateQueryOptional(Method.Builder builder, TypedElementInfo methodInfo, PersistenceGenerator.Query query) {
        QueryByJpqlMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByJpqlMethodsGenerator.optionalFromQuery((Method.Builder)b1, b2 -> QueryByJpqlMethodsGenerator.call((Method.Builder)b2, b3 -> this.statementGenerator().addExecuteQueryList(b3, query, QueryByJpqlMethodsGenerator.genericReturnTypeArgument((TypedElementInfo)methodInfo)), (String)"executor"), (TypeName)this.statementGenerator().executorType()));
    }

    private void generateQueryItem(Method.Builder builder, PersistenceGenerator.Query query, TypeName resultType) {
        QueryByJpqlMethodsGenerator.returnStatement((Method.Builder)builder, b1 -> QueryByJpqlMethodsGenerator.call((Method.Builder)b1, b2 -> this.statementGenerator().addExecuteQueryItem(b2, query, resultType), (String)"executor"));
    }

    private List<PersistenceGenerator.QueryBuilder.MethodParameter> params(MethodParams methodParams) {
        ArrayList params = new ArrayList(methodParams.parameters().size());
        methodParams.parameters().forEach(param -> params.add(PersistenceGenerator.QueryBuilder.MethodParameter.create((CharSequence)param.elementName(), (CharSequence)param.elementName())));
        return List.copyOf(params);
    }
}

