/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.common.types.TypeName;
import io.helidon.data.codegen.BasicRepositoryInterfaceGenerator;
import io.helidon.data.codegen.CrudRepositoryInterfaceGenerator;
import io.helidon.data.codegen.DataCodegenTypes;
import io.helidon.data.codegen.PageableRepositoryInterfaceGenerator;
import io.helidon.data.codegen.QueryByJpqlMethodsGenerator;
import io.helidon.data.codegen.QueryByNameMethodsGenerator;
import io.helidon.data.codegen.QueryMethods;
import io.helidon.data.codegen.RepositoryInfoBuilder;
import io.helidon.data.codegen.common.BaseRepositoryGenerator;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.RepositoryInterfaceGenerator;
import io.helidon.data.codegen.common.RepositoryInterfaceInfo;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class DataGenerator
extends BaseRepositoryGenerator {
    private static final Map<TypeName, BaseRepositoryGenerator.GeneratorFactory> GENERATOR_FACTORIES;

    DataGenerator() {
    }

    public Set<TypeName> annotations() {
        return DataCodegenTypes.ANNOTATIONS;
    }

    public Set<TypeName> interfaces() {
        return DataCodegenTypes.INTERFACES;
    }

    public RepositoryInterfaceInfo genericInterface(Map<TypeName, RepositoryInterfaceInfo> interfacesInfo) {
        Objects.requireNonNull(interfacesInfo, "Implemented interfaces Map value is null");
        for (TypeName name : DataCodegenTypes.INTERFACES_PRIORITY) {
            if (!interfacesInfo.containsKey(name)) continue;
            return interfacesInfo.get(name);
        }
        throw new CodegenException("Provided implemented interfaces Map did not contain any known interface");
    }

    public void generateInterfaces(RepositoryInfo repositoryInfo, ClassModel.Builder classModel, CodegenContext codegenContext, PersistenceGenerator persistenceGenerator) {
        for (TypeName interfaceName : repositoryInfo.interfacesInfo().keySet()) {
            if (!GENERATOR_FACTORIES.containsKey(interfaceName)) continue;
            RepositoryInterfaceGenerator generator = GENERATOR_FACTORIES.get(interfaceName).create(repositoryInfo, classModel, codegenContext, persistenceGenerator);
            generator.generate();
        }
    }

    public void generateQueryMethods(RepositoryInfo repositoryInfo, ClassModel.Builder classModel, CodegenContext codegenContext, PersistenceGenerator persistenceGenerator) {
        QueryMethods.Builder builder = QueryMethods.builder();
        repositoryInfo.interfaceInfo().elementInfo().stream().filter(QueryMethods.Builder::filterMethods).forEach(builder::addMethod);
        QueryMethods methods = builder.build();
        QueryByNameMethodsGenerator.generate(repositoryInfo, methods.methods(QueryMethods.Type.BY_NAME), classModel, codegenContext, persistenceGenerator);
        QueryByJpqlMethodsGenerator.generate(repositoryInfo, methods.methods(QueryMethods.Type.QUERY), classModel, codegenContext, persistenceGenerator);
    }

    protected RepositoryInfo.Builder repositoryInfoBuilder(CodegenContext codegenContext) {
        return new RepositoryInfoBuilder(codegenContext);
    }

    static {
        HashMap<TypeName, BaseRepositoryGenerator.GeneratorFactory> generatorFactories = new HashMap<TypeName, BaseRepositoryGenerator.GeneratorFactory>();
        generatorFactories.put(DataCodegenTypes.BASIC_REPOSITORY, BasicRepositoryInterfaceGenerator::new);
        generatorFactories.put(DataCodegenTypes.CRUD_REPOSITORY, CrudRepositoryInterfaceGenerator::new);
        generatorFactories.put(DataCodegenTypes.PAGEABLE_REPOSITORY, PageableRepositoryInterfaceGenerator::new);
        GENERATOR_FACTORIES = Map.copyOf(generatorFactories);
    }
}

