/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.query;

import io.helidon.builder.api.Prototype;
import io.helidon.data.codegen.query.Property;
import java.util.Objects;

class PropertySupport {
    private PropertySupport() {
        throw new UnsupportedOperationException("No instances of PropertySupport are allowed");
    }

    @Prototype.PrototypeMethod
    static String toString(Property property) {
        if (property.nameParts().isEmpty()) {
            return "";
        }
        return property.name().toString();
    }

    @Prototype.PrototypeFactoryMethod
    static Property create(CharSequence namePart) {
        Objects.requireNonNull(namePart, "Value of namePart is null");
        return ((Property.Builder)Property.builder().addNamePart(namePart)).build();
    }

    @Prototype.PrototypeFactoryMethod
    static Property create(CharSequence[] nameParts) {
        Objects.requireNonNull(nameParts, "Value of nameParts is null");
        if (nameParts.length < 1) {
            throw new IllegalArgumentException("Array nameParts must contain at least one element");
        }
        Property.Builder builder = Property.builder();
        for (CharSequence namePart : nameParts) {
            if (namePart.isEmpty()) {
                throw new IllegalArgumentException("Array nameParts contains empty element");
            }
            builder.addNamePart(namePart);
        }
        return builder.build();
    }
}

