/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.query;

import io.helidon.builder.api.Prototype;
import io.helidon.data.codegen.query.Projection;
import io.helidon.data.codegen.query.ProjectionAction;
import io.helidon.data.codegen.query.ProjectionExpression;

class ProjectionSupport {
    private ProjectionSupport() {
        throw new UnsupportedOperationException("No instances of ProjectionSupport are allowed");
    }

    @Prototype.PrototypeFactoryMethod
    static Projection select() {
        return ((Projection.Builder)Projection.builder().action(ProjectionAction.Select)).build();
    }

    @Prototype.PrototypeFactoryMethod
    static Projection selectDistinct() {
        return ((Projection.Builder)((Projection.Builder)Projection.builder().action(ProjectionAction.Select)).distinct(true)).build();
    }

    @Prototype.PrototypeFactoryMethod
    static Projection selectFirst(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Value of count must be greater than 0");
        }
        return ((Projection.Builder)((Projection.Builder)Projection.builder().action(ProjectionAction.Select)).expression(ProjectionExpression.createFirst(count))).build();
    }

    @Prototype.PrototypeFactoryMethod
    static Projection selectCount() {
        return ((Projection.Builder)((Projection.Builder)Projection.builder().action(ProjectionAction.Select)).expression(ProjectionExpression.createCount())).build();
    }

    @Prototype.PrototypeFactoryMethod
    static Projection selectExists() {
        return ((Projection.Builder)((Projection.Builder)Projection.builder().action(ProjectionAction.Select)).expression(ProjectionExpression.createExists())).build();
    }

    @Prototype.PrototypeFactoryMethod
    static Projection delete() {
        return ((Projection.Builder)Projection.builder().action(ProjectionAction.Delete)).build();
    }

    @Prototype.PrototypeFactoryMethod
    static Projection update() {
        return ((Projection.Builder)Projection.builder().action(ProjectionAction.Update)).build();
    }
}

