/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.query;

import io.helidon.data.codegen.query.ProjectionOperator;
import io.helidon.data.codegen.query.ProjectionParameter;
import java.util.Optional;

public class ProjectionExpression {
    private final ProjectionOperator operator;
    private final ProjectionParameter<?> parameter;

    private ProjectionExpression(ProjectionOperator operator, ProjectionParameter<?> parameter) {
        this.operator = operator;
        this.parameter = parameter;
    }

    private ProjectionExpression(ProjectionOperator operator) {
        this(operator, null);
    }

    public static ProjectionExpression createFirst(int count) {
        return new ProjectionExpression(ProjectionOperator.First, ProjectionParameter.createInteger(count));
    }

    public static ProjectionExpression createCount() {
        return new ProjectionExpression(ProjectionOperator.Count);
    }

    public static ProjectionExpression createExists() {
        return new ProjectionExpression(ProjectionOperator.Exists);
    }

    public static ProjectionExpression createMin() {
        return new ProjectionExpression(ProjectionOperator.Min);
    }

    public static ProjectionExpression createMax() {
        return new ProjectionExpression(ProjectionOperator.Max);
    }

    public static ProjectionExpression createSum() {
        return new ProjectionExpression(ProjectionOperator.Sum);
    }

    public static ProjectionExpression createAvg() {
        return new ProjectionExpression(ProjectionOperator.Avg);
    }

    public ProjectionOperator operator() {
        return this.operator;
    }

    public Optional<ProjectionParameter<?>> parameter() {
        return Optional.ofNullable(this.parameter);
    }
}

