/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.query;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.data.codegen.query.ProjectionAction;
import io.helidon.data.codegen.query.ProjectionBlueprint;
import io.helidon.data.codegen.query.ProjectionExpression;
import io.helidon.data.codegen.query.ProjectionResult;
import io.helidon.data.codegen.query.ProjectionSupport;
import io.helidon.data.codegen.query.Property;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.data.codegen.query.ProjectionBlueprint")
public interface Projection
extends ProjectionBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Projection instance) {
        return (Builder)Projection.builder().from(instance);
    }

    public static Projection create() {
        return Projection.builder().buildPrototype();
    }

    public static Projection select() {
        return ProjectionSupport.select();
    }

    public static Projection selectDistinct() {
        return ProjectionSupport.selectDistinct();
    }

    public static Projection selectFirst(int count) {
        return ProjectionSupport.selectFirst(count);
    }

    public static Projection selectCount() {
        return ProjectionSupport.selectCount();
    }

    public static Projection selectExists() {
        return ProjectionSupport.selectExists();
    }

    public static Projection delete() {
        return ProjectionSupport.delete();
    }

    public static Projection update() {
        return ProjectionSupport.update();
    }

    @Override
    public ProjectionAction action();

    @Override
    public Optional<ProjectionResult> result();

    @Override
    public Optional<ProjectionExpression> expression();

    @Override
    public Optional<Property> property();

    @Override
    public boolean distinct();

    public static class Builder
    extends BuilderBase<Builder, Projection>
    implements io.helidon.common.Builder<Builder, Projection> {
        private Builder() {
        }

        public Projection buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ProjectionImpl(this);
        }

        public Projection build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Projection>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean distinct = false;
        private ProjectionAction action;
        private ProjectionExpression expression;
        private ProjectionResult result;
        private Property property;

        protected BuilderBase() {
        }

        public BUILDER from(Projection prototype) {
            this.action(prototype.action());
            this.result(prototype.result());
            this.expression(prototype.expression());
            this.property(prototype.property());
            this.distinct(prototype.distinct());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.action().ifPresent(this::action);
            builder.result().ifPresent(this::result);
            builder.expression().ifPresent(this::expression);
            builder.property().ifPresent(this::property);
            this.distinct(builder.distinct());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER action(ProjectionAction action) {
            Objects.requireNonNull(action);
            this.action = action;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearResult() {
            this.result = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER result(ProjectionResult result) {
            Objects.requireNonNull(result);
            this.result = result;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearExpression() {
            this.expression = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER expression(ProjectionExpression expression) {
            Objects.requireNonNull(expression);
            this.expression = expression;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearProperty() {
            this.property = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER property(Property property) {
            Objects.requireNonNull(property);
            this.property = property;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER property(Consumer<Property.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Property.Builder builder = Property.builder();
            consumer.accept(builder);
            this.property(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER distinct(boolean distinct) {
            this.distinct = distinct;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<ProjectionAction> action() {
            return Optional.ofNullable(this.action);
        }

        public Optional<ProjectionResult> result() {
            return Optional.ofNullable(this.result);
        }

        public Optional<ProjectionExpression> expression() {
            return Optional.ofNullable(this.expression);
        }

        public Optional<Property> property() {
            return Optional.ofNullable(this.property);
        }

        public boolean distinct() {
            return this.distinct;
        }

        public String toString() {
            return "ProjectionBuilder{action=" + String.valueOf((Object)this.action) + ",result=" + String.valueOf((Object)this.result) + ",expression=" + String.valueOf(this.expression) + ",property=" + String.valueOf(this.property) + ",distinct=" + this.distinct + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.action == null) {
                collector.fatal(this.getClass(), "Property \"action\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER result(Optional<? extends ProjectionResult> result) {
            Objects.requireNonNull(result);
            this.result = result.map(ProjectionResult.class::cast).orElse(this.result);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER expression(Optional<? extends ProjectionExpression> expression) {
            Objects.requireNonNull(expression);
            this.expression = expression.map(ProjectionExpression.class::cast).orElse(this.expression);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER property(Optional<? extends Property> property) {
            Objects.requireNonNull(property);
            this.property = property.map(Property.class::cast).orElse(this.property);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ProjectionImpl
        implements Projection {
            private final boolean distinct;
            private final Optional<Property> property;
            private final Optional<ProjectionExpression> expression;
            private final Optional<ProjectionResult> result;
            private final ProjectionAction action;

            protected ProjectionImpl(BuilderBase<?, ?> builder) {
                this.action = builder.action().get();
                this.result = builder.result().map(Function.identity());
                this.expression = builder.expression().map(Function.identity());
                this.property = builder.property().map(Function.identity());
                this.distinct = builder.distinct();
            }

            @Override
            public ProjectionAction action() {
                return this.action;
            }

            @Override
            public Optional<ProjectionResult> result() {
                return this.result;
            }

            @Override
            public Optional<ProjectionExpression> expression() {
                return this.expression;
            }

            @Override
            public Optional<Property> property() {
                return this.property;
            }

            @Override
            public boolean distinct() {
                return this.distinct;
            }

            public String toString() {
                return "Projection{action=" + String.valueOf((Object)this.action) + ",result=" + String.valueOf(this.result) + ",expression=" + String.valueOf(this.expression) + ",property=" + String.valueOf(this.property) + ",distinct=" + this.distinct + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Projection)) {
                    return false;
                }
                Projection other = (Projection)o;
                return Objects.equals((Object)this.action, (Object)other.action()) && Objects.equals(this.result, other.result()) && Objects.equals(this.expression, other.expression()) && Objects.equals(this.property, other.property()) && this.distinct == other.distinct();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.action, this.result, this.expression, this.property, this.distinct});
            }
        }
    }
}

