/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.common;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.data.codegen.common.BaseGenerator;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.RepositoryInterfaceGenerator;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import java.util.Optional;
import java.util.function.Consumer;

public abstract class BaseRepositoryInterfaceGenerator
extends BaseGenerator
implements RepositoryInterfaceGenerator {
    private final RepositoryInfo repositoryInfo;
    private final ClassModel.Builder classModel;
    private final CodegenContext codegenContext;
    private final PersistenceGenerator persistenceGenerator;
    private final PersistenceGenerator.QueryBuilder queryBuilder;
    private final PersistenceGenerator.StatementGenerator statementGenerator;

    protected BaseRepositoryInterfaceGenerator(RepositoryInfo repositoryInfo, ClassModel.Builder classModel, CodegenContext codegenContext, PersistenceGenerator persistenceGenerator) {
        this.repositoryInfo = repositoryInfo;
        this.classModel = classModel;
        this.codegenContext = codegenContext;
        this.persistenceGenerator = persistenceGenerator;
        this.queryBuilder = this.persistenceGenerator().queryBuilder(repositoryInfo);
        this.statementGenerator = this.persistenceGenerator().statementGenerator();
    }

    protected static void optionalOfNullable(Method.Builder builder, Consumer<Method.Builder> content) {
        ((Method.Builder)builder.addContent(Optional.class)).addContent(".ofNullable(");
        content.accept(builder);
        builder.addContent(")");
    }

    @Deprecated
    protected static void optionalFromQuery(Method.Builder builder, Consumer<Method.Builder> content, TypeName executorType) {
        ((Method.Builder)builder.addContent(executorType)).addContent(".optionalFromQuery(");
        content.accept(builder);
        builder.addContent(")");
    }

    protected static void call(Method.Builder builder, Consumer<Method.Builder> content, String identifier) {
        ((Method.Builder)builder.addContent(identifier)).addContent(".call(");
        content.accept(builder);
        builder.addContent(")");
    }

    protected static void run(Method.Builder builder, Consumer<Method.Builder> content, String identifier) {
        ((Method.Builder)builder.addContent(identifier)).addContent(".run(");
        content.accept(builder);
        builder.addContent(")");
    }

    protected static TypeArgument extendsType(String type, TypeName extended) {
        return TypeArgument.builder().bound(extended).token(type).build();
    }

    protected RepositoryInfo repositoryInfo() {
        return this.repositoryInfo;
    }

    protected ClassModel.Builder classModel() {
        return this.classModel;
    }

    protected CodegenContext codegenContext() {
        return this.codegenContext;
    }

    protected PersistenceGenerator persistenceGenerator() {
        return this.persistenceGenerator;
    }

    protected PersistenceGenerator.QueryBuilder queryBuilder() {
        return this.queryBuilder;
    }

    protected PersistenceGenerator.StatementGenerator statementGenerator() {
        return this.statementGenerator;
    }

    protected void methodWarning(TypedElementInfo methodInfo, String message) {
        this.codegenContext().logger().log(System.Logger.Level.WARNING, String.format("%s: %s", BaseRepositoryInterfaceGenerator.methodPrototypeString(methodInfo), message));
    }

    private static String methodPrototypeString(TypedElementInfo methodInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodInfo.elementName()).append('(');
        boolean first = true;
        for (TypedElementInfo info : methodInfo.parameterArguments()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(info.typeName().className());
        }
        sb.append(")");
        return sb.toString();
    }
}

