/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.common;

import io.helidon.common.types.TypeInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;

class TypeInfoSpliterator
extends Spliterators.AbstractSpliterator<TypeInfo> {
    private final List<TypeInfo> stack = new LinkedList<TypeInfo>();

    TypeInfoSpliterator(TypeInfo typeInfo) {
        super(TypeInfoSpliterator.estimateSize(typeInfo), 64);
        this.stack.add(typeInfo);
    }

    @Override
    public boolean tryAdvance(Consumer<? super TypeInfo> action) {
        if (!this.stack.isEmpty()) {
            TypeInfo current = this.stack.removeFirst();
            this.stack.addAll(current.interfaceTypeInfo());
            action.accept((TypeInfo)current);
            return true;
        }
        return false;
    }

    private static long estimateSize(TypeInfo typeInfo) {
        long count = 0L;
        LinkedList<TypeInfo> stack = new LinkedList<TypeInfo>();
        stack.add(typeInfo);
        while (!stack.isEmpty()) {
            TypeInfo current = (TypeInfo)stack.removeFirst();
            stack.addAll(current.interfaceTypeInfo());
            ++count;
        }
        return count;
    }
}

