/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen.common;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.data.codegen.common.TypeInfoSpliterator;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.common.spi.RepositoryGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.StreamSupport;

class RepositoryCodegen
implements CodegenExtension {
    private static final System.Logger LOGGER = System.getLogger(RepositoryCodegen.class.getName());
    private final CodegenContext codegenContext;
    private final List<RepositoryGenerator> repositoryGenerators;
    private final List<PersistenceGenerator> persistenceGenerators;
    private final Set<TypeName> annotations;

    RepositoryCodegen(CodegenContext codegenContext, List<RepositoryGenerator> repositoryGenerators, List<PersistenceGenerator> persistenceGenerators) {
        Objects.requireNonNull(codegenContext, "Codegen context value is null");
        Objects.requireNonNull(repositoryGenerators, "Data repository generators value is null");
        Objects.requireNonNull(persistenceGenerators, "Persistence generators value is null");
        this.codegenContext = codegenContext;
        this.repositoryGenerators = repositoryGenerators;
        this.persistenceGenerators = persistenceGenerators;
        HashSet annotations = new HashSet();
        repositoryGenerators.forEach(generator -> annotations.addAll(generator.annotations()));
        this.annotations = Set.copyOf(annotations);
    }

    public void process(RoundContext roundContext) {
        HashSet repositoryInterfaces = new HashSet();
        this.annotations.forEach(annotation -> roundContext.annotatedTypes(annotation).forEach(repositoryInterfaces::add));
        if (!repositoryInterfaces.isEmpty()) {
            HashMap interfaceAssignment = new HashMap();
            this.repositoryGenerators.forEach(generator -> generator.interfaces().forEach(iface -> interfaceAssignment.put(iface, generator)));
            repositoryInterfaces.forEach(repositoryInterface -> {
                RepositoryGenerator repositoryGenerator = this.analyseInterfaces((TypeInfo)repositoryInterface, interfaceAssignment);
                this.persistenceGenerators.forEach(generator -> generator.generate(this.codegenContext, roundContext, (TypeInfo)repositoryInterface, repositoryGenerator));
            });
        }
    }

    private RepositoryGenerator analyseInterfaces(TypeInfo repositoryInterface, Map<TypeName, RepositoryGenerator> interfaceAssignment) {
        HashSet assigned = new HashSet(this.repositoryGenerators.size());
        StreamSupport.stream(new TypeInfoSpliterator(repositoryInterface), false).forEach(info -> {
            if (interfaceAssignment.containsKey(info.typeName())) {
                assigned.add((RepositoryGenerator)interfaceAssignment.get(info.typeName()));
            }
        });
        if (assigned.size() > 1) {
            throw new CodegenException("Interface extends interfaces from multiple data repository providers", repositoryInterface.originatingElement().orElseGet(() -> repositoryInterface.typeName()));
        }
        if (assigned.isEmpty()) {
            throw new CodegenException("Interface extends no data repository provider's interface", repositoryInterface.originatingElement().orElseGet(() -> repositoryInterface.typeName()));
        }
        return (RepositoryGenerator)assigned.stream().findFirst().get();
    }
}

