/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.processor;

import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.config.metadata.processor.TypeHandlerBase;
import io.helidon.config.metadata.processor.UsedTypes;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

final class ConfiguredOptionData {
    private final List<AllowedValue> allowedValues = new LinkedList<AllowedValue>();
    private boolean configured = true;
    private String name;
    private TypeName type;
    private String description;
    private boolean required;
    private String defaultValue;
    private boolean experimental;
    private boolean provider;
    private boolean deprecated;
    private boolean merge;
    private String kind = "VALUE";
    private TypeName providerType;

    ConfiguredOptionData() {
    }

    static ConfiguredOptionData createMeta(ProcessingEnvironment aptEnv, Annotation option) {
        Elements aptElements;
        TypeElement typeElement;
        ConfiguredOptionData result = new ConfiguredOptionData();
        option.booleanValue("configured").ifPresent(result::configured);
        option.stringValue("key").filter(Predicate.not(String::isBlank)).ifPresent(result::name);
        option.stringValue("description").filter(Predicate.not(String::isBlank)).ifPresent(result::description);
        option.stringValue().filter(Predicate.not("io.helidon.config.metadata.ConfiguredOption.UNCONFIGURED"::equals)).ifPresent(result::defaultValue);
        option.booleanValue("experimental").ifPresent(result::experimental);
        option.booleanValue("required").ifPresent(result::required);
        option.booleanValue("mergeWithParent").ifPresent(result::merge);
        option.typeValue("type").ifPresent(result::type);
        option.stringValue("kind").ifPresent(result::kind);
        option.booleanValue("provider").ifPresent(result::provider);
        option.booleanValue("deprecated").ifPresent(result::deprecated);
        option.annotationValues("allowedValues").or(() -> option.annotationValue("allowedValue").map(List::of)).stream().flatMap(Collection::stream).map(AllowedValue::create).forEach(result::addAllowedValue);
        if (result.allowedValues.isEmpty() && (typeElement = (aptElements = aptEnv.getElementUtils()).getTypeElement(option.typeValue("type").orElse(TypeNames.STRING).fqName())) != null && typeElement.getKind() == ElementKind.ENUM) {
            result.allowedValues.addAll(ConfiguredOptionData.allowedValues(aptElements, typeElement));
        }
        return result;
    }

    static ConfiguredOptionData createBuilder(TypedElementInfo element) {
        ConfiguredOptionData result = new ConfiguredOptionData();
        Optional optionConfigured = element.findAnnotation(UsedTypes.OPTION_CONFIGURED);
        optionConfigured.flatMap(rec$ -> ((Annotation)rec$).stringValue()).filter(Predicate.not(String::isBlank)).ifPresent(result::name);
        optionConfigured.flatMap(it -> it.booleanValue("merge")).ifPresent(result::merge);
        element.findAnnotation(UsedTypes.DESCRIPTION).flatMap(rec$ -> ((Annotation)rec$).stringValue()).ifPresent(result::description);
        element.findAnnotation(UsedTypes.OPTION_REQUIRED).ifPresent(it -> result.required(true));
        element.findAnnotation(UsedTypes.OPTION_PROVIDER).ifPresent(it -> {
            it.typeValue().ifPresent(result::providerType);
            result.provider(true);
        });
        element.findAnnotation(UsedTypes.DEPRECATED).ifPresent(it -> result.deprecated(true));
        element.findAnnotation(UsedTypes.OPTION_ALLOWED_VALUES).flatMap(rec$ -> ((Annotation)rec$).annotationValues()).or(() -> element.findAnnotation(UsedTypes.OPTION_ALLOWED_VALUE).map(List::of)).stream().flatMap(Collection::stream).map(AllowedValue::create).forEach(result::addAllowedValue);
        Optional defaultValues = element.findAnnotation(UsedTypes.OPTION_DEFAULT).or(() -> element.findAnnotation(UsedTypes.OPTION_DEFAULT_INT)).or(() -> element.findAnnotation(UsedTypes.OPTION_DEFAULT_BOOLEAN)).or(() -> element.findAnnotation(UsedTypes.OPTION_DEFAULT_LONG)).or(() -> element.findAnnotation(UsedTypes.OPTION_DEFAULT_DOUBLE));
        if (defaultValues.isPresent()) {
            List strings = ((Annotation)defaultValues.get()).stringValues().orElseGet(List::of);
            result.defaultValue(String.join((CharSequence)", ", strings));
        } else if (element.hasAnnotation(UsedTypes.OPTION_DEFAULT_METHOD)) {
            Annotation annotation = element.annotation(UsedTypes.OPTION_DEFAULT_METHOD);
            TypeName type = annotation.typeValue("type").filter(Predicate.not(arg_0 -> ((TypeName)UsedTypes.OPTION_DEFAULT_METHOD).equals(arg_0))).or(() -> element.enclosingType()).orElse(null);
            String value = annotation.stringValue().orElse(null);
            if (value != null) {
                if (type == null) {
                    result.defaultValue(value + "()");
                } else {
                    result.defaultValue(type.fqName() + "." + value + "()");
                }
            }
        } else if (element.hasAnnotation(UsedTypes.OPTION_DEFAULT_CODE)) {
            element.annotation(UsedTypes.OPTION_DEFAULT_CODE).stringValue().ifPresent(result::defaultValue);
        }
        return result;
    }

    List<AllowedValue> allowedValues() {
        return this.allowedValues;
    }

    String name() {
        return this.name;
    }

    TypeName type() {
        return this.type;
    }

    String description() {
        return this.description;
    }

    boolean optional() {
        return !this.required;
    }

    String defaultValue() {
        return this.defaultValue;
    }

    boolean experimental() {
        return this.experimental;
    }

    boolean provider() {
        return this.provider;
    }

    TypeName providerType() {
        return this.providerType;
    }

    boolean deprecated() {
        return this.deprecated;
    }

    boolean merge() {
        return this.merge;
    }

    String kind() {
        return this.kind;
    }

    boolean configured() {
        return this.configured;
    }

    void type(TypeName type) {
        this.type = type;
    }

    void name(String name) {
        this.name = name;
    }

    void description(String description) {
        this.description = description;
    }

    void required(boolean required) {
        this.required = required;
    }

    void defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    void experimental(boolean experimental) {
        this.experimental = experimental;
    }

    void provider(boolean provider) {
        this.provider = provider;
    }

    void providerType(TypeName provider) {
        this.providerType = provider;
    }

    void deprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    void merge(boolean merge) {
        this.merge = merge;
    }

    void kind(String kind) {
        this.kind = kind;
    }

    void addAllowedValue(AllowedValue value) {
        this.allowedValues.add(value);
    }

    void configured(boolean configured) {
        this.configured = configured;
    }

    private static List<AllowedValue> allowedValues(Elements aptElements, TypeElement typeElement) {
        if (typeElement != null && typeElement.getKind() == ElementKind.ENUM) {
            return typeElement.getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(element -> new AllowedValue(element.toString(), TypeHandlerBase.javadoc(aptElements.getDocComment((Element)element)))).collect(Collectors.toList());
        }
        return List.of();
    }

    static final class AllowedValue {
        private String value;
        private String description;

        private AllowedValue() {
        }

        AllowedValue(String value, String description) {
            this.value = value;
            this.description = description;
        }

        String value() {
            return this.value;
        }

        String description() {
            return this.description;
        }

        private static AllowedValue create(Annotation annotation) {
            AllowedValue result = new AllowedValue();
            annotation.stringValue().ifPresent(it -> {
                result.value = it;
            });
            annotation.stringValue("description").filter(Predicate.not(String::isBlank)).ifPresent(it -> {
                result.description = it;
            });
            return result;
        }
    }
}

