/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.processor;

import io.helidon.common.processor.ElementInfoPredicates;
import io.helidon.common.processor.TypeInfoFactory;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.config.metadata.processor.ConfiguredType;
import io.helidon.config.metadata.processor.JArray;
import io.helidon.config.metadata.processor.JObject;
import io.helidon.config.metadata.processor.TypeHandlerBuilderApi;
import io.helidon.config.metadata.processor.TypeHandlerMetaApi;
import io.helidon.config.metadata.processor.TypeHandlerMetaApiBlueprint;
import io.helidon.config.metadata.processor.TypeHandlerResult;
import io.helidon.config.metadata.processor.UsedTypes;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

class ConfigMetadataHandler {
    private static final String META_FILE = "META-INF/helidon/config-metadata.json";
    private final Map<TypeName, ConfiguredType> newOptions = new HashMap<TypeName, ConfiguredType>();
    private final Map<String, List<TypeName>> moduleTypes = new HashMap<String, List<TypeName>>();
    private final Set<Element> classesToHandle = new LinkedHashSet<Element>();
    private Elements elementUtils;
    private Messager messager;
    private TypeElement configuredElement;
    private Filer filer;
    private TypeElement metaConfiguredElement;
    private ProcessingEnvironment processingEnv;

    ConfigMetadataHandler() {
    }

    synchronized void init(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.elementUtils = processingEnv.getElementUtils();
        this.configuredElement = this.elementUtils.getTypeElement(UsedTypes.CONFIGURED.fqName());
        this.metaConfiguredElement = this.elementUtils.getTypeElement(UsedTypes.META_CONFIGURED.fqName());
    }

    boolean process(RoundEnvironment roundEnv) {
        try {
            return this.doProcess(roundEnv);
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to process config metadata annotation processor. " + this.toMessage(e));
            e.printStackTrace();
            return false;
        }
    }

    private boolean doProcess(RoundEnvironment roundEnv) {
        if (this.configuredElement != null) {
            this.classesToHandle.addAll(roundEnv.getElementsAnnotatedWith(this.configuredElement));
        }
        if (this.metaConfiguredElement != null) {
            this.classesToHandle.addAll(roundEnv.getElementsAnnotatedWith(this.metaConfiguredElement));
        }
        if (roundEnv.processingOver()) {
            for (Element aClass : this.classesToHandle) {
                this.processClass(aClass);
            }
            this.storeMetadata();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void processClass(Element aClass) {
        if (aClass instanceof TypeElement) {
            void var4_8;
            TypeElement typeElement = (TypeElement)aClass;
            Optional typeInfo = TypeInfoFactory.create((ProcessingEnvironment)this.processingEnv, (TypeElement)typeElement, ElementInfoPredicates::isMethod);
            if (typeInfo.isEmpty()) {
                return;
            }
            TypeInfo configuredType = (TypeInfo)typeInfo.get();
            if (configuredType.hasAnnotation(UsedTypes.META_CONFIGURED)) {
                if (configuredType.hasAnnotation(UsedTypes.BLUEPRINT)) {
                    TypeHandlerMetaApiBlueprint typeHandlerMetaApiBlueprint = new TypeHandlerMetaApiBlueprint(this.processingEnv, configuredType);
                } else {
                    TypeHandlerMetaApi typeHandlerMetaApi = new TypeHandlerMetaApi(this.processingEnv, configuredType);
                }
            } else {
                if (!configuredType.hasAnnotation(UsedTypes.CONFIGURED)) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Requested to process type: " + String.valueOf(aClass) + ", but it does not have required annotation", aClass);
                    return;
                }
                if (!configuredType.hasAnnotation(UsedTypes.BLUEPRINT)) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Requested to process type: " + String.valueOf(aClass) + ", annotated with @" + UsedTypes.CONFIGURED.className() + " does not have @" + UsedTypes.BLUEPRINT.className() + " annotation", aClass);
                    return;
                }
                TypeHandlerBuilderApi typeHandlerBuilderApi = new TypeHandlerBuilderApi(this.processingEnv, configuredType);
            }
            TypeHandlerResult result = var4_8.handle();
            TypeName targetType = result.targetType();
            ConfiguredType configured = result.configuredType();
            this.newOptions.put(targetType, configured);
            this.moduleTypes.computeIfAbsent(result.moduleName(), it -> new ArrayList()).add(targetType);
        }
    }

    private void storeMetadata() {
        try (PrintWriter metaWriter = new PrintWriter(this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", META_FILE, new Element[0]).openWriter());){
            JArray moduleArray = new JArray();
            for (Map.Entry<String, List<TypeName>> module : this.moduleTypes.entrySet()) {
                String moduleName = module.getKey();
                List<TypeName> types = module.getValue();
                JArray typeArray = new JArray();
                types.forEach(it -> this.newOptions.get(it).write(typeArray));
                moduleArray.add(new JObject().add("module", moduleName).add("types", typeArray));
            }
            moduleArray.write(metaWriter);
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write configuration metadata: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String toMessage(Exception e) {
        return e.getClass().getName() + ": " + e.getMessage();
    }
}

