/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.processor;

import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.config.metadata.processor.ConfiguredOptionData;
import io.helidon.config.metadata.processor.ConfiguredType;
import io.helidon.config.metadata.processor.TypeHandlerBase;
import io.helidon.config.metadata.processor.UsedTypes;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.processing.ProcessingEnvironment;

abstract class TypeHandlerMetaApiBase
extends TypeHandlerBase {
    TypeHandlerMetaApiBase(ProcessingEnvironment aptEnv) {
        super(aptEnv);
    }

    List<ConfiguredOptionData> findConfiguredOptionAnnotations(TypedElementInfo elementInfo) {
        if (elementInfo.hasAnnotation(UsedTypes.META_OPTIONS)) {
            Annotation metaOptions = elementInfo.annotation(UsedTypes.META_OPTIONS);
            return metaOptions.annotationValues().stream().flatMap(Collection::stream).map(it -> ConfiguredOptionData.createMeta(this.aptEnv(), it)).toList();
        }
        if (elementInfo.hasAnnotation(UsedTypes.META_OPTION)) {
            Annotation metaOption = elementInfo.annotation(UsedTypes.META_OPTION);
            return List.of(ConfiguredOptionData.createMeta(this.aptEnv(), metaOption));
        }
        return List.of();
    }

    void processBuilderMethod(TypeName typeName, ConfiguredType configuredType, TypedElementInfo elementInfo, BiFunction<TypedElementInfo, ConfiguredOptionData, OptionType> optionTypeMethod, BiFunction<TypedElementInfo, OptionType, List<TypeName>> builderParamsMethod) {
        List<ConfiguredOptionData> options = this.findConfiguredOptionAnnotations(elementInfo);
        if (options.isEmpty()) {
            return;
        }
        for (ConfiguredOptionData data : options) {
            if (!data.configured()) continue;
            String name = this.key(elementInfo, data);
            String description = this.description(elementInfo, data);
            String defaultValue = this.defaultValue(data.defaultValue());
            boolean experimental = data.experimental();
            OptionType type = optionTypeMethod.apply(elementInfo, data);
            boolean optional = defaultValue != null || data.optional();
            boolean deprecated = data.deprecated();
            List<ConfiguredOptionData.AllowedValue> allowedValues = this.allowedValues(data, type.elementType());
            List<TypeName> paramTypes = builderParamsMethod.apply(elementInfo, type);
            ConfiguredType.ProducerMethod builderMethod = new ConfiguredType.ProducerMethod(false, typeName, elementInfo.elementName(), paramTypes);
            ConfiguredType.ConfiguredProperty property = new ConfiguredType.ConfiguredProperty(builderMethod.toString(), name, description, defaultValue, type.elementType(), experimental, optional, type.kind(), data.provider(), data.providerType(), deprecated, data.merge(), allowedValues);
            configuredType.addProperty(property);
        }
    }

    static final class OptionType {
        private final TypeName elementType;
        private final String kind;

        OptionType(TypeName elementType, String kind) {
            this.elementType = elementType;
            this.kind = kind;
        }

        TypeName elementType() {
            return this.elementType;
        }

        String kind() {
            return this.kind;
        }
    }
}

