/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.processor;

import io.helidon.common.processor.TypeInfoFactory;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.config.metadata.processor.ConfiguredOptionData;
import io.helidon.config.metadata.processor.ConfiguredType;
import io.helidon.config.metadata.processor.UsedTypes;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

abstract class TypeHandlerBase {
    static final String UNCONFIGURED_OPTION = "io.helidon.config.metadata.ConfiguredOption.UNCONFIGURED";
    private static final Pattern JAVADOC_CODE = Pattern.compile("\\{@code (.*?)}");
    private static final Pattern JAVADOC_LINK = Pattern.compile("\\{@link (.*?)}");
    private final ProcessingEnvironment aptEnv;

    TypeHandlerBase(ProcessingEnvironment aptEnv) {
        this.aptEnv = aptEnv;
    }

    static Predicate<TypedElementInfo> isMine(TypeName type) {
        TypeName withoutGenerics = type.genericTypeName();
        return info -> info.enclosingType().map(TypeName::genericTypeName).map(arg_0 -> ((TypeName)withoutGenerics).equals(arg_0)).orElse(true);
    }

    static boolean hasConfigParam(TypedElementInfo info) {
        List arguments = info.parameterArguments();
        if (arguments.size() != 1) {
            return false;
        }
        TypeName argumentType = ((TypedElementInfo)arguments.get(0)).typeName();
        return UsedTypes.CONFIG.equals((Object)argumentType) || UsedTypes.COMMON_CONFIG.equals((Object)argumentType);
    }

    static Element elementFor(Elements aptElements, TypedElementInfo elementInfo) {
        return elementInfo.enclosingType().map(rec$ -> ((TypeName)rec$).fqName()).map(aptElements::getTypeElement).orElse(null);
    }

    static String toConfigKey(String methodName) {
        char[] chars;
        StringBuilder result = new StringBuilder();
        for (char aChar : chars = methodName.toCharArray()) {
            if (Character.isUpperCase(aChar)) {
                if (result.isEmpty()) {
                    result.append(Character.toLowerCase(aChar));
                    continue;
                }
                result.append('-').append(Character.toLowerCase(aChar));
                continue;
            }
            result.append(aChar);
        }
        return result.toString();
    }

    static String javadoc(String docComment) {
        if (docComment == null) {
            return "";
        }
        String javadoc = docComment;
        int index = javadoc.indexOf("@param");
        if (index > -1) {
            javadoc = docComment.substring(0, index);
        }
        javadoc = JAVADOC_CODE.matcher(javadoc).replaceAll(it -> "`" + it.group(1) + "`");
        javadoc = JAVADOC_LINK.matcher(javadoc).replaceAll(it -> it.group(1));
        return javadoc.trim();
    }

    String key(TypedElementInfo elementInfo, ConfiguredOptionData configuredOption) {
        String name = configuredOption.name();
        if (name == null || name.isBlank()) {
            return TypeHandlerBase.toConfigKey(elementInfo.elementName());
        }
        return name;
    }

    String description(TypedElementInfo elementInfo, ConfiguredOptionData configuredOption) {
        String desc = configuredOption.description();
        if (desc == null) {
            return TypeHandlerBase.javadoc(elementInfo.description().orElse(null));
        }
        return desc;
    }

    String defaultValue(String defaultValue) {
        return UNCONFIGURED_OPTION.equals(defaultValue) ? null : defaultValue;
    }

    List<ConfiguredOptionData.AllowedValue> allowedValues(ConfiguredOptionData configuredOption, TypeName type) {
        if (type.equals((Object)configuredOption.type()) || !configuredOption.allowedValues().isEmpty()) {
            return configuredOption.allowedValues();
        }
        return this.allowedValues(type);
    }

    Optional<TypeInfo> typeInfo(TypeName typeName, Predicate<TypedElementInfo> predicate) {
        return TypeInfoFactory.create((ProcessingEnvironment)this.aptEnv, (TypeName)typeName);
    }

    ProcessingEnvironment aptEnv() {
        return this.aptEnv;
    }

    Messager aptMessager() {
        return this.aptEnv.getMessager();
    }

    Elements aptElements() {
        return this.aptEnv.getElementUtils();
    }

    List<TypeName> params(TypedElementInfo info) {
        return info.parameterArguments().stream().map(rec$ -> ((TypedElementInfo)rec$).typeName()).toList();
    }

    void addInterfaces(ConfiguredType type, TypeInfo typeInfo, TypeName requiredAnnotation) {
        for (TypeInfo interfaceInfo : typeInfo.interfaceTypeInfo()) {
            if (interfaceInfo.hasAnnotation(requiredAnnotation)) {
                type.addInherited(interfaceInfo.typeName());
                continue;
            }
            this.addSuperClasses(type, interfaceInfo, requiredAnnotation);
        }
    }

    void addSuperClasses(ConfiguredType type, TypeInfo typeInfo, TypeName requiredAnnotation) {
        Optional foundSuperType = typeInfo.superTypeInfo();
        if (foundSuperType.isEmpty()) {
            return;
        }
        TypeInfo superClass = (TypeInfo)foundSuperType.get();
        while (true) {
            if (superClass.hasAnnotation(requiredAnnotation)) {
                type.addInherited(superClass.typeName());
                return;
            }
            foundSuperType = superClass.superTypeInfo();
            if (foundSuperType.isEmpty()) {
                return;
            }
            superClass = (TypeInfo)foundSuperType.get();
        }
    }

    private List<ConfiguredOptionData.AllowedValue> allowedValues(TypeName type) {
        TypeElement typeElement = this.aptElements().getTypeElement(type.fqName());
        if (typeElement != null && typeElement.getKind() == ElementKind.ENUM) {
            return typeElement.getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(element -> new ConfiguredOptionData.AllowedValue(element.toString(), TypeHandlerBase.javadoc(this.aptElements().getDocComment((Element)element)))).toList();
        }
        return List.of();
    }
}

