/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.git;

import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.git.GitConfigSource;
import io.helidon.config.spi.AbstractParsableConfigSource;
import io.helidon.config.spi.PollingStrategy;
import java.net.URI;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public final class GitConfigSourceBuilder
extends AbstractParsableConfigSource.Builder<GitConfigSourceBuilder, GitEndpoint> {
    private static final String PATH_KEY = "path";
    private static final String URI_KEY = "uri";
    private static final String BRANCH_KEY = "branch";
    private static final String DIRECTORY_KEY = "directory";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private final String path;
    private URI uri;
    private String branch = "master";
    private Path directory;
    private CredentialsProvider credentialsProvider;

    private GitConfigSourceBuilder(String path) {
        super(GitEndpoint.class);
        Objects.requireNonNull(path, "path cannot be null");
        this.path = path;
        this.credentialsProvider = CredentialsProvider.getDefault();
    }

    public static GitConfigSourceBuilder create(String path) {
        return new GitConfigSourceBuilder(path);
    }

    public static GitConfigSourceBuilder create(Config metaConfig) throws ConfigMappingException, MissingValueException {
        return GitConfigSourceBuilder.create((String)metaConfig.get(PATH_KEY).asString().get()).init(metaConfig);
    }

    protected GitConfigSourceBuilder init(Config metaConfig) {
        metaConfig.get(URI_KEY).as(URI.class).ifPresent(this::uri);
        metaConfig.get(BRANCH_KEY).asString().ifPresent(this::branch);
        metaConfig.get(DIRECTORY_KEY).as(Path.class).ifPresent(this::directory);
        metaConfig.get(USERNAME).as(String.class).ifPresent(user -> {
            String password = (String)metaConfig.get(PASSWORD).as(String.class).orElse(null);
            this.credentialsProvider = new UsernamePasswordCredentialsProvider(user, password);
        });
        return (GitConfigSourceBuilder)super.init(metaConfig);
    }

    protected GitEndpoint target() {
        return new GitEndpoint(this.uri, this.branch, this.directory, this.path, this.credentialsProvider);
    }

    public GitConfigSourceBuilder branch(String branch) {
        this.branch = branch;
        return this;
    }

    public GitConfigSourceBuilder directory(Path directory) {
        this.directory = directory;
        return this;
    }

    public GitConfigSourceBuilder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public GitConfigSourceBuilder credentials(String user, String password) {
        Objects.requireNonNull(user);
        this.credentialsProvider = new UsernamePasswordCredentialsProvider(user, password);
        return this;
    }

    public GitConfigSourceBuilder credentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    PollingStrategy pollingStrategyInternal() {
        return super.pollingStrategy();
    }

    public GitConfigSource build() {
        return new GitConfigSource(this, this.target());
    }

    public static class GitEndpoint {
        private final URI uri;
        private final String branch;
        private final Path directory;
        private final String path;
        private final CredentialsProvider credentialsProvider;

        public GitEndpoint(URI uri, String branch, Path directory, String path, CredentialsProvider credentialsProvider) {
            this.uri = uri;
            this.branch = branch;
            this.path = path;
            this.directory = directory;
            this.credentialsProvider = credentialsProvider;
        }

        public URI uri() {
            return this.uri;
        }

        public String branch() {
            return this.branch;
        }

        public Path directory() {
            return this.directory;
        }

        public String path() {
            return this.path;
        }

        public CredentialsProvider credentialsProvider() {
            return this.credentialsProvider;
        }
    }
}

