/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.testing.http.junit5;

import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public final class HttpHeaderMatcher {
    private HttpHeaderMatcher() {
    }

    public static Matcher<Headers> noHeader(HeaderName name) {
        return new NoHeaderMatcher(name);
    }

    public static Matcher<Headers> hasHeader(HeaderName name) {
        return new HasHeaderMatcher(name);
    }

    public static Matcher<Headers> hasHeader(Header header) {
        return new HasValueMatcher(header);
    }

    public static Matcher<Headers> hasHeader(HeaderName name, String ... value) {
        return new HasValueMatcher(HeaderValues.create((HeaderName)name, (String[])value));
    }

    public static Matcher<Headers> hasHeader(HeaderName name, Matcher<Iterable<? extends String>> valuesMatcher) {
        return new HasValueMatcher(name, valuesMatcher);
    }

    public static Matcher<Headers> hasHeaderValue(HeaderName name, Matcher<String> valueMatcher) {
        return new HasSingleValueMatcher(name, valueMatcher);
    }

    private static class NoHeaderMatcher
    extends TypeSafeMatcher<Headers> {
        private final HeaderName name;

        private NoHeaderMatcher(HeaderName name) {
            this.name = name;
        }

        public void describeTo(Description description) {
            description.appendValue((Object)this.name.defaultCase()).appendText(" should not be present");
        }

        protected boolean matchesSafely(Headers httpHeaders) {
            return !httpHeaders.contains(this.name);
        }

        protected void describeMismatchSafely(Headers item, Description mismatchDescription) {
            if (item.contains(this.name)) {
                mismatchDescription.appendValue((Object)this.name.defaultCase()).appendText(" header is present, and its value is ");
                mismatchDescription.appendValue((Object)item.get(this.name).allValues());
            }
        }
    }

    private static class HasHeaderMatcher
    extends TypeSafeMatcher<Headers> {
        private final HeaderName name;

        HasHeaderMatcher(HeaderName header) {
            this.name = header;
        }

        public void describeTo(Description description) {
            description.appendValue((Object)this.name.defaultCase()).appendText(" should be present");
        }

        protected boolean matchesSafely(Headers httpHeaders) {
            return httpHeaders.contains(this.name);
        }

        protected void describeMismatchSafely(Headers item, Description mismatchDescription) {
            mismatchDescription.appendValue((Object)this.name.defaultCase()).appendText(" header is not present");
        }
    }

    private static class HasValueMatcher
    extends TypeSafeMatcher<Headers> {
        private final HeaderName name;
        private final Matcher<Iterable<? extends String>> valuesMatcher;

        HasValueMatcher(Header header) {
            this.name = header.headerName();
            this.valuesMatcher = Matchers.containsInAnyOrder((Object[])header.allValues().toArray(new String[0]));
        }

        HasValueMatcher(HeaderName name, Matcher<Iterable<? extends String>> valuesMatcher) {
            this.name = name;
            this.valuesMatcher = valuesMatcher;
        }

        public void describeTo(Description description) {
            description.appendValue((Object)this.name.defaultCase()).appendText(" should be present and values should match ");
            this.valuesMatcher.describeTo(description);
        }

        protected boolean matchesSafely(Headers httpHeaders) {
            if (httpHeaders.contains(this.name)) {
                return this.valuesMatcher.matches((Object)httpHeaders.all(this.name, List::of));
            }
            return false;
        }

        protected void describeMismatchSafely(Headers item, Description mismatchDescription) {
            if (item.contains(this.name)) {
                List all = item.all(this.name, List::of);
                mismatchDescription.appendValue((Object)this.name.defaultCase()).appendText(" header is present with wrong values ");
                this.valuesMatcher.describeMismatch((Object)all, mismatchDescription);
            } else {
                mismatchDescription.appendValue((Object)this.name.defaultCase()).appendText(" header is not present");
            }
        }
    }

    private static class HasSingleValueMatcher
    extends TypeSafeMatcher<Headers> {
        private final HeaderName name;
        private final Matcher<String> valuesMatcher;

        HasSingleValueMatcher(HeaderName name, Matcher<String> valuesMatcher) {
            this.name = name;
            this.valuesMatcher = valuesMatcher;
        }

        public void describeTo(Description description) {
            description.appendValue((Object)this.name.defaultCase()).appendText(" should be present and value should match ");
            this.valuesMatcher.describeTo(description);
        }

        protected boolean matchesSafely(Headers httpHeaders) {
            if (httpHeaders.contains(this.name)) {
                Header headerValue = httpHeaders.get(this.name);
                if (headerValue.allValues().size() == 1) {
                    return this.valuesMatcher.matches((Object)headerValue.value());
                }
                return false;
            }
            return false;
        }

        protected void describeMismatchSafely(Headers item, Description mismatchDescription) {
            if (item.contains(this.name)) {
                List all = item.all(this.name, List::of);
                if (all.size() == 1) {
                    mismatchDescription.appendValue((Object)this.name.defaultCase()).appendText(" header is present with wrong value ");
                    this.valuesMatcher.describeMismatch((Object)all, mismatchDescription);
                } else {
                    mismatchDescription.appendValue((Object)this.name.defaultCase()).appendText(" header is present with more than one value");
                }
            } else {
                mismatchDescription.appendValue((Object)this.name.defaultCase()).appendText("header is not present");
            }
        }
    }
}

