/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.testing.http.junit5;

import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.HeaderNames;
import io.helidon.http.Headers;
import io.helidon.http.Method;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;

public class SocketHttpClient
implements AutoCloseable {
    private static final System.Logger LOGGER = System.getLogger(SocketHttpClient.class.getName());
    private static final String EOL = "\r\n";
    private static final Pattern FIRST_LINE_PATTERN = Pattern.compile("HTTP/\\d+\\.\\d+ (\\d\\d\\d) (.*)");
    private final String host;
    private final int port;
    private final Duration timeout;
    private Socket socket;
    private boolean connected;
    private BufferedReader socketReader;

    protected SocketHttpClient(String host, int port, Duration timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    public static SocketHttpClient create(String host, int port, Duration timeout) {
        return new SocketHttpClient(host, port, timeout);
    }

    public static SocketHttpClient create(int port) {
        return SocketHttpClient.create("localhost", port, Duration.ofSeconds(5L));
    }

    public static StringBuilder longData(int bytes) {
        StringBuilder data = new StringBuilder(bytes);
        int i = 0;
        while (data.length() < bytes) {
            data.append(i).append("\n");
            ++i;
        }
        return data;
    }

    public static ClientResponseHeaders headersFromResponse(String response) {
        WritableHeaders headers = WritableHeaders.create();
        MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.notNullValue());
        int index = response.indexOf("\n\n");
        if (index < 0) {
            throw new AssertionError((Object)"Missing end of headers in response!");
        }
        String hdrsPart = response.substring(0, index);
        String[] lines = hdrsPart.split("\\n");
        if (lines.length <= 1) {
            return ClientResponseHeaders.create((Headers)headers);
        }
        boolean first = true;
        for (String line : lines) {
            if (first) {
                first = false;
                continue;
            }
            int i = line.indexOf(58);
            if (i < 0) {
                throw new AssertionError((Object)("Header without semicolon - " + line));
            }
            headers.add(HeaderNames.create((String)line.substring(0, i).trim()), new String[]{line.substring(i + 1).trim()});
        }
        return ClientResponseHeaders.create((Headers)headers);
    }

    public static Status statusFromResponse(String response) {
        int eol = response.indexOf(10);
        MatcherAssert.assertThat((String)("There must be at least a line end after first line: " + response), (eol > -1 ? 1 : 0) != 0);
        String firstLine = response.substring(0, eol).trim();
        java.util.regex.Matcher matcher = FIRST_LINE_PATTERN.matcher(firstLine);
        MatcherAssert.assertThat((String)("Status line must match the patter of 'HTTP/0.0 000 ReasonPhrase', but is: " + response), (boolean)matcher.matches());
        int statusCode = Integer.parseInt(matcher.group(1));
        String phrase = matcher.group(2);
        return Status.create((int)statusCode, (String)phrase);
    }

    public static String entityFromResponse(String response, boolean validateHeaderFormat) {
        MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.notNullValue());
        int index = response.indexOf("\n\n");
        if (index < 0) {
            throw new AssertionError((Object)"Missing end of headers in response!");
        }
        if (validateHeaderFormat) {
            String headers = response.substring(0, index);
            String[] lines = headers.split("\\n");
            MatcherAssert.assertThat((Object)lines[0], (Matcher)CoreMatchers.startsWith((String)"HTTP/"));
            for (int i = 1; i < lines.length; ++i) {
                MatcherAssert.assertThat((Object)lines[i], (Matcher)CoreMatchers.containsString((String)":"));
            }
        }
        return response.substring(index + 2);
    }

    @Override
    public void close() throws Exception {
        this.disconnect();
    }

    public void assertConnectionIsOpen() {
        this.request(Method.GET, "/this/path/should/not/exist", null);
        MatcherAssert.assertThat((Object)this.receive(), (Matcher)CoreMatchers.containsString((String)"HTTP/1.1"));
    }

    public void assertConnectionIsClosed() {
        this.request(Method.POST, null);
        try {
            MatcherAssert.assertThat((Object)this.receive(), (Matcher)Is.is((Object)""));
        }
        catch (UncheckedIOException e) {
            if (e.getCause() instanceof SocketException) {
                LOGGER.log(System.Logger.Level.TRACE, "Received: " + e.getMessage());
            }
            throw e;
        }
    }

    public String sendAndReceive(Method method, String payload) {
        return this.sendAndReceive(method, "/", payload);
    }

    public String sendAndReceive(Method method, String path, String payload) {
        return this.sendAndReceive(method, path, payload, Collections.emptyList());
    }

    public String sendAndReceive(Method method, String path, String payload, Iterable<String> headers) {
        this.request(method, path, payload, headers);
        return this.receive();
    }

    public String receive() {
        try {
            String t;
            BufferedReader br = this.socketReader;
            StringBuilder sb = new StringBuilder();
            boolean ending = false;
            int contentLength = -1;
            while ((t = br.readLine()) != null) {
                LOGGER.log(System.Logger.Level.TRACE, "< " + t);
                if (t.toLowerCase().startsWith("content-length")) {
                    int k = t.indexOf(58);
                    contentLength = Integer.parseInt(t.substring(k + 1).trim());
                }
                sb.append(t).append("\n");
                if ("".equalsIgnoreCase(t) && contentLength >= 0) {
                    int read;
                    char[] content = new char[contentLength];
                    for (int expected = contentLength; expected != 0; expected -= read) {
                        read = br.read(content);
                        if (read == 0) {
                            throw new IllegalStateException("Read zero bytes from a blocking stream, this is a bug");
                        }
                        if (read == -1) {
                            throw new IllegalStateException("Received end of stream while expecting more bytes");
                        }
                        sb.append(content, 0, read);
                    }
                    break;
                }
                if (ending && "".equalsIgnoreCase(t)) break;
                if (ending || !"0".equalsIgnoreCase(t)) continue;
                ending = true;
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public SocketHttpClient then(Consumer<SocketHttpClient> exec) {
        exec.accept(this);
        return this;
    }

    public SocketHttpClient awaitResponse(String expectedStartsWith, String expectedEndsWith) {
        StringBuilder sb = new StringBuilder();
        do {
            String t;
            block3: {
                try {
                    t = this.socketReader.readLine();
                    if (t != null) break block3;
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            LOGGER.log(System.Logger.Level.TRACE, "< " + t);
            sb.append(t).append("\n");
        } while (!sb.toString().startsWith(expectedStartsWith) || !sb.toString().endsWith(expectedEndsWith));
        return this;
    }

    public void request(Method method) {
        this.request(method, null);
    }

    public void request(Method method, String payload) {
        this.request(method, "/", payload);
    }

    public void request(Method method, String path, String payload) {
        this.request(method, path, payload, List.of("Content-Type: application/x-www-form-urlencoded"));
    }

    public void request(Method method, String path, String payload, Iterable<String> headers) {
        this.request(method.text(), path, "HTTP/1.1", "127.0.0.1", headers, payload);
    }

    public void request(String method, String path, String protocol, String host, Iterable<String> headers, String payload) {
        if (this.socket == null) {
            this.connect();
        }
        try {
            LinkedList<CallSite> usedHeaders = new LinkedList<CallSite>();
            if (headers != null) {
                headers.forEach(usedHeaders::add);
            }
            if (host != null) {
                usedHeaders.add(0, (CallSite)((Object)("Host: " + host)));
            }
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.UTF_8));
            pw.print(method);
            pw.print(" ");
            pw.print(path);
            pw.print(" ");
            pw.print(protocol);
            pw.print(EOL);
            for (String string : usedHeaders) {
                pw.print(string);
                pw.print(EOL);
            }
            this.sendPayload(pw, payload);
            pw.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void requestRaw(String content) {
        if (this.socket == null) {
            this.connect();
        }
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.UTF_8));
            pw.print(content);
            pw.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeProxyHeader(byte[] header) {
        try {
            if (this.socket == null) {
                this.connect();
            }
            this.socket.getOutputStream().write(header);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void disconnect() {
        if (this.socket == null) {
            return;
        }
        try {
            this.connected = false;
            this.socket.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.socket = null;
    }

    public void connect() {
        this.connect(this.timeout);
    }

    public void connect(Duration timeout) {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connected = false;
        }
        try {
            this.socket = new Socket(this.host, this.port);
            this.socket.setSoTimeout((int)timeout.toMillis());
            this.socketReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), StandardCharsets.UTF_8));
            this.connected = true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean connected() {
        return this.connected;
    }

    public SocketHttpClient manualRequest(String formatString, Object ... args) throws IOException {
        if (this.socket == null) {
            this.connect();
        }
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.UTF_8));
        LOGGER.log(System.Logger.Level.TRACE, () -> {
            String msg = "\n> " + formatString.replaceAll("\\n", "\r\n> ");
            return String.format(msg.substring(0, msg.length() - "> ".length()), args);
        });
        pw.printf(formatString.replaceAll("\\n", EOL), args);
        pw.flush();
        return this;
    }

    public SocketHttpClient continuePayload(String payload) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.UTF_8));
        if (payload != null) {
            pw.print(payload);
        }
        pw.flush();
        return this;
    }

    public SocketHttpClient sendChunk(String payload) throws IOException {
        this.continuePayload(Integer.toHexString(payload.length()) + EOL + payload + EOL);
        return this;
    }

    protected void sendPayload(PrintWriter pw, String payload) {
        if (payload == null) {
            pw.print(EOL);
        } else {
            pw.print("Content-Length: " + payload.length());
            pw.print(EOL);
            pw.print(EOL);
            pw.print(payload);
        }
    }
}

