/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.socket.SocketWriter;
import io.helidon.common.socket.SocketWriterAsync;
import java.util.concurrent.ExecutorService;

public class SmartSocketWriter
extends SocketWriter {
    private static final long WINDOW_SIZE = 1000L;
    private static final double QUEUE_SIZE_THRESHOLD = 2.0;
    private final SocketWriterAsync asyncWriter;
    private volatile long windowIndex;
    private volatile boolean asyncMode;

    SmartSocketWriter(ExecutorService executor, HelidonSocket socket, int writeQueueLength) {
        super(socket);
        this.asyncWriter = new SocketWriterAsync(executor, socket, writeQueueLength);
        this.asyncMode = true;
        this.windowIndex = 0L;
    }

    public void write(BufferData ... buffers) {
        for (BufferData buffer : buffers) {
            this.write(buffer);
        }
    }

    public void write(BufferData buffer) {
        if (this.asyncMode) {
            this.asyncWriter.write(buffer);
            if (++this.windowIndex % 1000L == 0L && this.asyncWriter.avgQueueSize() < 2.0) {
                this.asyncMode = false;
            }
        } else {
            this.asyncWriter.drainQueue();
            this.writeNow(buffer);
        }
    }
}

