/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import io.helidon.common.LazyValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

class IdleInputStream
extends InputStream {
    private static final int ITERATION_TIME_MILLIS = 101;
    private final Socket socket;
    private final InputStream upstream;
    private final LazyValue<ExecutorService> executor;
    private volatile int next = -1;
    private volatile boolean closed = false;
    private volatile boolean cancelled = false;
    private Future<?> idlingThread;

    IdleInputStream(Socket socket, InputStream upstream, String childSocketId, String socketId) {
        this.socket = socket;
        this.upstream = upstream;
        this.executor = LazyValue.create(() -> Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("helidon-socket-monitor-" + childSocketId + "-" + socketId, 0L).factory()));
    }

    @Override
    public int read() throws IOException {
        if (this.idlingThread != null) {
            this.endIdle();
        }
        if (this.next < 0) {
            return this.upstream.read();
        }
        int res = this.next;
        this.next = -1;
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.idlingThread != null) {
            this.endIdle();
        }
        if (this.next < 0) {
            return this.upstream.read(b, off, len);
        }
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return 0;
        }
        b[off] = (byte)this.next;
        this.next = -1;
        return 1;
    }

    @Override
    public void close() throws IOException {
        this.upstream.close();
        this.closed = true;
    }

    void idle() {
        if (this.idlingThread != null) {
            return;
        }
        this.idlingThread = ((ExecutorService)this.executor.get()).submit(this::handle);
    }

    boolean isClosed() {
        return this.closed;
    }

    private void handle() {
        try {
            int toRestore = this.socket.getSoTimeout();
            int idleTimeoutIterations = Math.ceilDiv(Math.max(1, toRestore), 101);
            int i = 0;
            while (!this.cancelled) {
                try {
                    int currentSoTimeout = this.socket.getSoTimeout();
                    if (currentSoTimeout != 101) {
                        toRestore = currentSoTimeout;
                    }
                    this.socket.setSoTimeout(101);
                    this.next = this.upstream.read();
                    if (this.next <= 0) {
                        this.closed = true;
                        return;
                    }
                    break;
                }
                catch (SocketTimeoutException e) {
                    if (i + 1 >= idleTimeoutIterations) {
                        throw e;
                    }
                    ++i;
                }
            }
            if (this.socket.getSoTimeout() == 101) {
                this.socket.setSoTimeout(toRestore);
            }
        }
        catch (IOException e) {
            this.closed = true;
            throw new UncheckedIOException(e);
        }
    }

    private void endIdle() {
        try {
            this.cancelled = true;
            this.idlingThread.get();
            this.idlingThread = null;
            this.cancelled = false;
        }
        catch (InterruptedException | ExecutionException e) {
            this.closed = true;
            throw new RuntimeException("Exception in socket monitor thread.", e);
        }
    }
}

