/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import io.helidon.common.socket.PeerInfo;

public interface SocketContext {
    public PeerInfo remotePeer();

    public PeerInfo localPeer();

    public boolean isSecure();

    public String socketId();

    public String childSocketId();

    default public void log(System.Logger logger, System.Logger.Level level, String format, Object ... variables) {
        if (logger.isLoggable(level)) {
            logger.log(level, this.message(format, variables));
        }
    }

    default public void log(System.Logger logger, System.Logger.Level level, String format, Throwable t, Object ... variables) {
        if (logger.isLoggable(level)) {
            logger.log(level, this.message(format, variables), t);
        }
    }

    private String message(String format, Object ... variables) {
        Object[] newVars = new Object[2 + variables.length];
        newVars[0] = this.socketId();
        newVars[1] = this.childSocketId();
        System.arraycopy(variables, 0, newVars, 2, variables.length);
        return String.format("[%s %s] " + format, newVars);
    }
}

