/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.common.socket.SocketOptionsBlueprint;
import java.net.SocketOption;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.socket.SocketOptionsBlueprint")
public interface SocketOptions
extends SocketOptionsBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SocketOptions instance) {
        return (Builder)SocketOptions.builder().from(instance);
    }

    public static SocketOptions create(Config config) {
        return ((Builder)SocketOptions.builder().config(config)).buildPrototype();
    }

    public static SocketOptions create() {
        return SocketOptions.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, SocketOptions>
    implements io.helidon.common.Builder<Builder, SocketOptions> {
        private Builder() {
        }

        public SocketOptions buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.SocketOptionsImpl(this);
        }

        public SocketOptions build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends SocketOptions>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final Map<SocketOption<?>, Object> socketOptions = new LinkedHashMap();
        private boolean socketKeepAlive = true;
        private boolean socketReuseAddress = true;
        private boolean tcpNoDelay = false;
        private Config config;
        private Duration connectTimeout = Duration.parse("PT10S");
        private Duration readTimeout = Duration.parse("PT30S");
        private Integer socketReceiveBufferSize;
        private Integer socketSendBufferSize;

        protected BuilderBase() {
        }

        public BUILDER from(SocketOptions prototype) {
            this.addSocketOptions(prototype.socketOptions());
            this.connectTimeout(prototype.connectTimeout());
            this.readTimeout(prototype.readTimeout());
            this.socketReceiveBufferSize(prototype.socketReceiveBufferSize());
            this.socketSendBufferSize(prototype.socketSendBufferSize());
            this.socketReuseAddress(prototype.socketReuseAddress());
            this.socketKeepAlive(prototype.socketKeepAlive());
            this.tcpNoDelay(prototype.tcpNoDelay());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.addSocketOptions(builder.socketOptions);
            this.connectTimeout(builder.connectTimeout());
            this.readTimeout(builder.readTimeout());
            builder.socketReceiveBufferSize().ifPresent(this::socketReceiveBufferSize);
            builder.socketSendBufferSize().ifPresent(this::socketSendBufferSize);
            this.socketReuseAddress(builder.socketReuseAddress());
            this.socketKeepAlive(builder.socketKeepAlive());
            this.tcpNoDelay(builder.tcpNoDelay());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("connect-timeout").as(Duration.class).ifPresent(this::connectTimeout);
            config.get("read-timeout").as(Duration.class).ifPresent(this::readTimeout);
            config.get("socket-receive-buffer-size").as(Integer.class).ifPresent(this::socketReceiveBufferSize);
            config.get("socket-send-buffer-size").as(Integer.class).ifPresent(this::socketSendBufferSize);
            config.get("socket-reuse-address").as(Boolean.class).ifPresent(this::socketReuseAddress);
            config.get("socket-keep-alive").as(Boolean.class).ifPresent(this::socketKeepAlive);
            config.get("tcp-no-delay").as(Boolean.class).ifPresent(this::tcpNoDelay);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketOptions(Map<SocketOption<?>, ?> socketOptions) {
            Objects.requireNonNull(socketOptions);
            this.socketOptions.clear();
            this.socketOptions.putAll(socketOptions);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSocketOptions(Map<SocketOption<?>, ?> socketOptions) {
            Objects.requireNonNull(socketOptions);
            this.socketOptions.putAll(socketOptions);
            return (BUILDER)((BuilderBase)this.self());
        }

        public <TYPE> BUILDER putSocketOption(SocketOption<TYPE> key, TYPE socketOption) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(socketOption);
            this.socketOptions.put(key, socketOption);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connectTimeout(Duration connectTimeout) {
            Objects.requireNonNull(connectTimeout);
            this.connectTimeout = connectTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER readTimeout(Duration readTimeout) {
            Objects.requireNonNull(readTimeout);
            this.readTimeout = readTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSocketReceiveBufferSize() {
            this.socketReceiveBufferSize = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketReceiveBufferSize(int socketReceiveBufferSize) {
            Objects.requireNonNull(socketReceiveBufferSize);
            this.socketReceiveBufferSize = socketReceiveBufferSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSocketSendBufferSize() {
            this.socketSendBufferSize = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketSendBufferSize(int socketSendBufferSize) {
            Objects.requireNonNull(socketSendBufferSize);
            this.socketSendBufferSize = socketSendBufferSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketReuseAddress(boolean socketReuseAddress) {
            this.socketReuseAddress = socketReuseAddress;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketKeepAlive(boolean socketKeepAlive) {
            this.socketKeepAlive = socketKeepAlive;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Map<SocketOption<?>, Object> socketOptions() {
            return this.socketOptions;
        }

        public Duration connectTimeout() {
            return this.connectTimeout;
        }

        public Duration readTimeout() {
            return this.readTimeout;
        }

        public Optional<Integer> socketReceiveBufferSize() {
            return Optional.ofNullable(this.socketReceiveBufferSize);
        }

        public Optional<Integer> socketSendBufferSize() {
            return Optional.ofNullable(this.socketSendBufferSize);
        }

        public boolean socketReuseAddress() {
            return this.socketReuseAddress;
        }

        public boolean socketKeepAlive() {
            return this.socketKeepAlive;
        }

        public boolean tcpNoDelay() {
            return this.tcpNoDelay;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "SocketOptionsBuilder{socketOptions=" + String.valueOf(this.socketOptions) + ",connectTimeout=" + String.valueOf(this.connectTimeout) + ",readTimeout=" + String.valueOf(this.readTimeout) + ",socketReceiveBufferSize=" + this.socketReceiveBufferSize + ",socketSendBufferSize=" + this.socketSendBufferSize + ",socketReuseAddress=" + this.socketReuseAddress + ",socketKeepAlive=" + this.socketKeepAlive + ",tcpNoDelay=" + this.tcpNoDelay + "}";
        }

        protected void preBuildPrototype() {
            new SocketOptionsBlueprint.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        BUILDER socketReceiveBufferSize(Optional<Integer> socketReceiveBufferSize) {
            Objects.requireNonNull(socketReceiveBufferSize);
            this.socketReceiveBufferSize = socketReceiveBufferSize.map(Integer.class::cast).orElse(this.socketReceiveBufferSize);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER socketSendBufferSize(Optional<Integer> socketSendBufferSize) {
            Objects.requireNonNull(socketSendBufferSize);
            this.socketSendBufferSize = socketSendBufferSize.map(Integer.class::cast).orElse(this.socketSendBufferSize);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class SocketOptionsImpl
        implements SocketOptions {
            private final boolean socketKeepAlive;
            private final boolean socketReuseAddress;
            private final boolean tcpNoDelay;
            private final Duration connectTimeout;
            private final Duration readTimeout;
            private final Map<SocketOption<?>, Object> socketOptions;
            private final Optional<Integer> socketReceiveBufferSize;
            private final Optional<Integer> socketSendBufferSize;

            protected SocketOptionsImpl(BuilderBase<?, ?> builder) {
                this.socketOptions = Collections.unmodifiableMap(new LinkedHashMap(builder.socketOptions()));
                this.connectTimeout = builder.connectTimeout();
                this.readTimeout = builder.readTimeout();
                this.socketReceiveBufferSize = builder.socketReceiveBufferSize();
                this.socketSendBufferSize = builder.socketSendBufferSize();
                this.socketReuseAddress = builder.socketReuseAddress();
                this.socketKeepAlive = builder.socketKeepAlive();
                this.tcpNoDelay = builder.tcpNoDelay();
            }

            @Override
            public Map<SocketOption<?>, Object> socketOptions() {
                return this.socketOptions;
            }

            @Override
            public Duration connectTimeout() {
                return this.connectTimeout;
            }

            @Override
            public Duration readTimeout() {
                return this.readTimeout;
            }

            @Override
            public Optional<Integer> socketReceiveBufferSize() {
                return this.socketReceiveBufferSize;
            }

            @Override
            public Optional<Integer> socketSendBufferSize() {
                return this.socketSendBufferSize;
            }

            @Override
            public boolean socketReuseAddress() {
                return this.socketReuseAddress;
            }

            @Override
            public boolean socketKeepAlive() {
                return this.socketKeepAlive;
            }

            @Override
            public boolean tcpNoDelay() {
                return this.tcpNoDelay;
            }

            public String toString() {
                return "SocketOptions{socketOptions=" + String.valueOf(this.socketOptions) + ",connectTimeout=" + String.valueOf(this.connectTimeout) + ",readTimeout=" + String.valueOf(this.readTimeout) + ",socketReceiveBufferSize=" + String.valueOf(this.socketReceiveBufferSize) + ",socketSendBufferSize=" + String.valueOf(this.socketSendBufferSize) + ",socketReuseAddress=" + this.socketReuseAddress + ",socketKeepAlive=" + this.socketKeepAlive + ",tcpNoDelay=" + this.tcpNoDelay + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SocketOptions)) {
                    return false;
                }
                SocketOptions other = (SocketOptions)o;
                return Objects.equals(this.socketOptions, other.socketOptions()) && Objects.equals(this.connectTimeout, other.connectTimeout()) && Objects.equals(this.readTimeout, other.readTimeout()) && Objects.equals(this.socketReceiveBufferSize, other.socketReceiveBufferSize()) && Objects.equals(this.socketSendBufferSize, other.socketSendBufferSize()) && this.socketReuseAddress == other.socketReuseAddress() && this.socketKeepAlive == other.socketKeepAlive() && this.tcpNoDelay == other.tcpNoDelay();
            }

            public int hashCode() {
                return Objects.hash(this.socketOptions, this.connectTimeout, this.readTimeout, this.socketReceiveBufferSize, this.socketSendBufferSize, this.socketReuseAddress, this.socketKeepAlive, this.tcpNoDelay);
            }
        }
    }
}

