/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import io.helidon.builder.api.Prototype;
import io.helidon.common.socket.SocketOptions;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.time.Duration;
import java.util.Map;

@Configured
@Prototype.Blueprint(builderInterceptor=BuilderInterceptor.class)
interface SocketOptionsBlueprint {
    @Prototype.Singular
    @Prototype.SameGeneric
    public Map<SocketOption<?>, Object> socketOptions();

    @ConfiguredOption(value="PT10S")
    public Duration connectTimeout();

    @ConfiguredOption(value="PT30S")
    public Duration readTimeout();

    @ConfiguredOption(value="32768")
    public int socketReceiveBufferSize();

    @ConfiguredOption(value="32768")
    public int socketSendBufferSize();

    @ConfiguredOption(value="true")
    public boolean socketReuseAddress();

    @ConfiguredOption(value="true")
    public boolean socketKeepAlive();

    @ConfiguredOption(value="false")
    public boolean tcpNoDelay();

    default public void configureSocket(Socket socket) {
        for (Map.Entry<SocketOption<?>, Object> entry : this.socketOptions().entrySet()) {
            try {
                SocketOption<?> opt = entry.getKey();
                socket.setOption(opt, entry.getValue());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static class BuilderInterceptor
    implements Prototype.BuilderInterceptor<SocketOptions.BuilderBase<?, ?>> {
        public SocketOptions.BuilderBase<?, ?> intercept(SocketOptions.BuilderBase<?, ?> target) {
            target.putSocketOption(StandardSocketOptions.SO_RCVBUF, target.socketReceiveBufferSize());
            target.putSocketOption(StandardSocketOptions.SO_SNDBUF, target.socketSendBufferSize());
            target.putSocketOption(StandardSocketOptions.SO_REUSEADDR, target.socketReuseAddress());
            target.putSocketOption(StandardSocketOptions.SO_KEEPALIVE, target.socketKeepAlive());
            target.putSocketOption(StandardSocketOptions.TCP_NODELAY, target.tcpNoDelay());
            return target;
        }
    }
}

