/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.socket.SocketOptionsBlueprint;
import java.net.SocketOption;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.common.socket.SocketOptionsBlueprint")
public interface SocketOptions
extends SocketOptionsBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SocketOptions instance) {
        return (Builder)SocketOptions.builder().from(instance);
    }

    public static SocketOptions create(Config config) {
        return ((Builder)SocketOptions.builder().config(config)).buildPrototype();
    }

    public static SocketOptions create() {
        return SocketOptions.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, SocketOptions>
    implements io.helidon.common.Builder<Builder, SocketOptions> {
        private Builder() {
        }

        public SocketOptions buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.SocketOptionsImpl(this);
        }

        public SocketOptions build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends SocketOptions>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE>,
    SocketOptions {
        private Config config;
        private final Map<SocketOption<?>, Object> socketOptions = new LinkedHashMap();
        private Duration connectTimeout = Duration.parse("PT10S");
        private Duration readTimeout = Duration.parse("PT30S");
        private int socketReceiveBufferSize = 32768;
        private int socketSendBufferSize = 32768;
        private boolean socketReuseAddress = true;
        private boolean socketKeepAlive = true;
        private boolean tcpNoDelay = false;

        protected BuilderBase() {
        }

        public BUILDER from(SocketOptions prototype) {
            this.addSocketOptions(prototype.socketOptions());
            this.connectTimeout(prototype.connectTimeout());
            this.readTimeout(prototype.readTimeout());
            this.socketReceiveBufferSize(prototype.socketReceiveBufferSize());
            this.socketSendBufferSize(prototype.socketSendBufferSize());
            this.socketReuseAddress(prototype.socketReuseAddress());
            this.socketKeepAlive(prototype.socketKeepAlive());
            this.tcpNoDelay(prototype.tcpNoDelay());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.addSocketOptions(builder.socketOptions());
            if (builder.connectTimeout() != null) {
                this.connectTimeout(builder.connectTimeout());
            }
            if (builder.readTimeout() != null) {
                this.readTimeout(builder.readTimeout());
            }
            this.socketReceiveBufferSize(builder.socketReceiveBufferSize());
            this.socketSendBufferSize(builder.socketSendBufferSize());
            this.socketReuseAddress(builder.socketReuseAddress());
            this.socketKeepAlive(builder.socketKeepAlive());
            this.tcpNoDelay(builder.tcpNoDelay());
            return (BUILDER)((BuilderBase)this.self());
        }

        protected void preBuildPrototype() {
            new SocketOptionsBlueprint.BuilderInterceptor().intercept(this);
        }

        protected void validatePrototype() {
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("connect-timeout").as(Duration.class).ifPresent(this::connectTimeout);
            config.get("read-timeout").as(Duration.class).ifPresent(this::readTimeout);
            config.get("socket-receive-buffer-size").as(Integer.class).ifPresent(this::socketReceiveBufferSize);
            config.get("socket-send-buffer-size").as(Integer.class).ifPresent(this::socketSendBufferSize);
            config.get("socket-reuse-address").as(Boolean.class).ifPresent(this::socketReuseAddress);
            config.get("socket-keep-alive").as(Boolean.class).ifPresent(this::socketKeepAlive);
            config.get("tcp-no-delay").as(Boolean.class).ifPresent(this::tcpNoDelay);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketOptions(Map<? extends SocketOption<?>, ?> socketOptions) {
            Objects.requireNonNull(socketOptions);
            this.socketOptions.clear();
            this.socketOptions.putAll(socketOptions);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSocketOptions(Map<? extends SocketOption<?>, ?> socketOptions) {
            Objects.requireNonNull(socketOptions);
            this.socketOptions.putAll(socketOptions);
            return (BUILDER)((BuilderBase)this.self());
        }

        public <TYPE> BUILDER putSocketOption(SocketOption<TYPE> key, TYPE socketOption) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(socketOption);
            this.socketOptions.put(key, socketOption);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connectTimeout(Duration connectTimeout) {
            Objects.requireNonNull(connectTimeout);
            this.connectTimeout = connectTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER readTimeout(Duration readTimeout) {
            Objects.requireNonNull(readTimeout);
            this.readTimeout = readTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketReceiveBufferSize(int socketReceiveBufferSize) {
            this.socketReceiveBufferSize = socketReceiveBufferSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketSendBufferSize(int socketSendBufferSize) {
            this.socketSendBufferSize = socketSendBufferSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketReuseAddress(boolean socketReuseAddress) {
            this.socketReuseAddress = socketReuseAddress;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER socketKeepAlive(boolean socketKeepAlive) {
            this.socketKeepAlive = socketKeepAlive;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public Map<SocketOption<?>, Object> socketOptions() {
            return this.socketOptions;
        }

        @Override
        public Duration connectTimeout() {
            return this.connectTimeout;
        }

        @Override
        public Duration readTimeout() {
            return this.readTimeout;
        }

        @Override
        public int socketReceiveBufferSize() {
            return this.socketReceiveBufferSize;
        }

        @Override
        public int socketSendBufferSize() {
            return this.socketSendBufferSize;
        }

        @Override
        public boolean socketReuseAddress() {
            return this.socketReuseAddress;
        }

        @Override
        public boolean socketKeepAlive() {
            return this.socketKeepAlive;
        }

        @Override
        public boolean tcpNoDelay() {
            return this.tcpNoDelay;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "SocketOptionsBuilder{socketOptions=" + String.valueOf(this.socketOptions) + ",connectTimeout=" + String.valueOf(this.connectTimeout) + ",readTimeout=" + String.valueOf(this.readTimeout) + ",socketReceiveBufferSize=" + this.socketReceiveBufferSize + ",socketSendBufferSize=" + this.socketSendBufferSize + ",socketReuseAddress=" + this.socketReuseAddress + ",socketKeepAlive=" + this.socketKeepAlive + ",tcpNoDelay=" + this.tcpNoDelay + "}";
        }

        protected static class SocketOptionsImpl
        implements SocketOptions {
            private final Map<SocketOption<?>, Object> socketOptions;
            private final Duration connectTimeout;
            private final Duration readTimeout;
            private final int socketReceiveBufferSize;
            private final int socketSendBufferSize;
            private final boolean socketReuseAddress;
            private final boolean socketKeepAlive;
            private final boolean tcpNoDelay;

            protected SocketOptionsImpl(BuilderBase<?, ?> builder) {
                this.socketOptions = Collections.unmodifiableMap(new LinkedHashMap(builder.socketOptions()));
                this.connectTimeout = builder.connectTimeout();
                this.readTimeout = builder.readTimeout();
                this.socketReceiveBufferSize = builder.socketReceiveBufferSize();
                this.socketSendBufferSize = builder.socketSendBufferSize();
                this.socketReuseAddress = builder.socketReuseAddress();
                this.socketKeepAlive = builder.socketKeepAlive();
                this.tcpNoDelay = builder.tcpNoDelay();
            }

            @Override
            public Map<SocketOption<?>, Object> socketOptions() {
                return this.socketOptions;
            }

            @Override
            public Duration connectTimeout() {
                return this.connectTimeout;
            }

            @Override
            public Duration readTimeout() {
                return this.readTimeout;
            }

            @Override
            public int socketReceiveBufferSize() {
                return this.socketReceiveBufferSize;
            }

            @Override
            public int socketSendBufferSize() {
                return this.socketSendBufferSize;
            }

            @Override
            public boolean socketReuseAddress() {
                return this.socketReuseAddress;
            }

            @Override
            public boolean socketKeepAlive() {
                return this.socketKeepAlive;
            }

            @Override
            public boolean tcpNoDelay() {
                return this.tcpNoDelay;
            }

            public String toString() {
                return "SocketOptions{socketOptions=" + String.valueOf(this.socketOptions) + ",connectTimeout=" + String.valueOf(this.connectTimeout) + ",readTimeout=" + String.valueOf(this.readTimeout) + ",socketReceiveBufferSize=" + this.socketReceiveBufferSize + ",socketSendBufferSize=" + this.socketSendBufferSize + ",socketReuseAddress=" + this.socketReuseAddress + ",socketKeepAlive=" + this.socketKeepAlive + ",tcpNoDelay=" + this.tcpNoDelay + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SocketOptions)) {
                    return false;
                }
                SocketOptions other = (SocketOptions)o;
                return Objects.equals(this.socketOptions, other.socketOptions()) && Objects.equals(this.connectTimeout, other.connectTimeout()) && Objects.equals(this.readTimeout, other.readTimeout()) && this.socketReceiveBufferSize == other.socketReceiveBufferSize() && this.socketSendBufferSize == other.socketSendBufferSize() && this.socketReuseAddress == other.socketReuseAddress() && this.socketKeepAlive == other.socketKeepAlive() && this.tcpNoDelay == other.tcpNoDelay();
            }

            public int hashCode() {
                return Objects.hash(this.socketOptions, this.connectTimeout, this.readTimeout, this.socketReceiveBufferSize, this.socketSendBufferSize, this.socketReuseAddress, this.socketKeepAlive, this.tcpNoDelay);
            }
        }
    }
}

