/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.pki;

import io.helidon.common.configurable.Resource;
import io.helidon.common.configurable.ResourceException;
import io.helidon.common.pki.PemReader;
import io.helidon.common.pki.PkiException;
import io.helidon.common.pki.PkiUtil;
import io.helidon.config.Config;
import io.helidon.config.DeprecatedConfig;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class KeyConfig {
    private static final String DEFAULT_PRIVATE_KEY_ALIAS = "1";
    private static final Logger LOGGER = Logger.getLogger(KeyConfig.class.getName());
    private static final char[] EMPTY_CHARS = new char[0];
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final X509Certificate publicCert;
    private final List<X509Certificate> certChain = new LinkedList<X509Certificate>();
    private final List<X509Certificate> certificates = new LinkedList<X509Certificate>();

    private KeyConfig(PrivateKey privateKey, PublicKey publicKey, X509Certificate publicCert, Collection<X509Certificate> certChain, Collection<X509Certificate> certificates) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.publicCert = publicCert;
        this.certChain.addAll(certChain);
        this.certificates.addAll(certificates);
    }

    public static KeyConfig create(Config config) throws PkiException {
        try {
            return KeyConfig.fullBuilder().config(config).build();
        }
        catch (ResourceException e) {
            throw new PkiException("Failed to load from config", e);
        }
    }

    public static Builder fullBuilder() {
        return new Builder();
    }

    public static PemBuilder pemBuilder() {
        return new PemBuilder();
    }

    public static KeystoreBuilder keystoreBuilder() {
        return new KeystoreBuilder();
    }

    public Optional<PublicKey> publicKey() {
        return Optional.ofNullable(this.publicKey);
    }

    public Optional<PrivateKey> privateKey() {
        return Optional.ofNullable(this.privateKey);
    }

    public Optional<X509Certificate> publicCert() {
        return Optional.ofNullable(this.publicCert);
    }

    public List<X509Certificate> certChain() {
        return Collections.unmodifiableList(this.certChain);
    }

    public List<X509Certificate> certs() {
        return Collections.unmodifiableList(this.certificates);
    }

    private static final class StreamHolder {
        private final String baseMessage;
        private InputStream inputStream;
        private String message;

        private StreamHolder(String message) {
            this.baseMessage = message;
            this.message = message;
        }

        private boolean isSet() {
            return this.inputStream != null;
        }

        private void stream(Resource resource) {
            this.closeStream();
            Objects.requireNonNull(resource, "Resource for \"" + this.message + "\" must not be null");
            this.inputStream = resource.stream();
            this.message = this.message + ":" + resource.sourceType() + ":" + resource.location();
        }

        private InputStream stream() {
            return this.inputStream;
        }

        private String message() {
            return this.message;
        }

        private void closeStream() {
            if (null != this.inputStream) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to close input stream: " + this.message, e);
                }
            }
            this.message = this.baseMessage;
        }
    }

    public static final class PemBuilder
    implements io.helidon.common.Builder<KeyConfig> {
        private final StreamHolder privateKeyStream = new StreamHolder("privateKey");
        private final StreamHolder publicKeyStream = new StreamHolder("publicKey");
        private final StreamHolder certChainStream = new StreamHolder("certChain");
        private char[] pemKeyPassphrase;

        private PemBuilder() {
        }

        public PemBuilder key(Resource resource) {
            this.privateKeyStream.stream(resource);
            return this;
        }

        public PemBuilder publicKey(Resource resource) {
            this.publicKeyStream.stream(resource);
            return this;
        }

        public PemBuilder keyPassphrase(char[] passphrase) {
            this.pemKeyPassphrase = Arrays.copyOf(passphrase, passphrase.length);
            return this;
        }

        public PemBuilder keyPassphrase(String passphrase) {
            return this.keyPassphrase(passphrase.toCharArray());
        }

        public PemBuilder certChain(Resource resource) {
            this.certChainStream.stream(resource);
            return this;
        }

        public KeyConfig build() {
            return this.toFullBuilder().build();
        }

        public Builder toFullBuilder() {
            return this.updateBuilder(KeyConfig.fullBuilder());
        }

        private Builder updateBuilder(Builder builder) {
            if (this.privateKeyStream.isSet()) {
                builder.privateKey(PemReader.readPrivateKey(this.privateKeyStream.stream(), this.pemKeyPassphrase));
            }
            if (this.publicKeyStream.isSet()) {
                builder.publicKey(PemReader.readPublicKey(this.publicKeyStream.stream()));
            }
            if (this.certChainStream.isSet()) {
                List<X509Certificate> chain = PemReader.readCertificates(this.certChainStream.stream());
                chain.forEach(builder::addCertChain);
                if (!chain.isEmpty()) {
                    builder.publicKeyCert(chain.get(0));
                }
            }
            return builder;
        }

        public PemBuilder config(Config config) {
            Config pemConfig = config.get("pem");
            pemConfig.get("key.resource").as(Resource::create).ifPresent(this::key);
            pemConfig.get("key.passphrase").asString().map(String::toCharArray).ifPresent(this::keyPassphrase);
            pemConfig.get("cert-chain.resource").as(Resource::create).ifPresent(this::certChain);
            Resource.create((Config)config, (String)"pem-key").ifPresent(this::key);
            config.get("pem-key-passphrase").asString().map(String::toCharArray).ifPresent(this::keyPassphrase);
            Resource.create((Config)config, (String)"pem-cert-chain").ifPresent(this::certChain);
            return this;
        }
    }

    public static final class KeystoreBuilder
    implements io.helidon.common.Builder<KeyConfig> {
        private static final String DEFAULT_KEYSTORE_TYPE = "PKCS12";
        private String keystoreType = "PKCS12";
        private char[] keystorePassphrase = EMPTY_CHARS;
        private char[] keyPassphrase = null;
        private String keyAlias;
        private String certAlias;
        private String certChainAlias;
        private boolean addAllCertificates;
        private final List<String> certificateAliases = new LinkedList<String>();
        private final StreamHolder keystoreStream = new StreamHolder("keystore");

        private KeystoreBuilder() {
        }

        public KeystoreBuilder trustStore() {
            return this.trustStore(true);
        }

        private KeystoreBuilder trustStore(boolean isTrustStore) {
            this.addAllCertificates = isTrustStore;
            return this;
        }

        public KeystoreBuilder addCertAlias(String alias) {
            this.certificateAliases.add(alias);
            return this;
        }

        public KeystoreBuilder keystore(Resource keystore) {
            this.keystoreStream.stream(keystore);
            return this;
        }

        public KeystoreBuilder keystoreType(String keystoreType) {
            this.keystoreType = keystoreType;
            return this;
        }

        public KeystoreBuilder keystorePassphrase(char[] keystorePassphrase) {
            this.keystorePassphrase = Arrays.copyOf(keystorePassphrase, keystorePassphrase.length);
            return this;
        }

        public KeystoreBuilder keystorePassphrase(String keystorePassword) {
            return this.keystorePassphrase(keystorePassword.toCharArray());
        }

        public KeystoreBuilder keyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
            return this;
        }

        public KeystoreBuilder certAlias(String alias) {
            this.certAlias = alias;
            return this;
        }

        public KeystoreBuilder certChainAlias(String alias) {
            this.certChainAlias = alias;
            return this;
        }

        public KeystoreBuilder keyPassphrase(char[] privateKeyPassphrase) {
            this.keyPassphrase = Arrays.copyOf(privateKeyPassphrase, privateKeyPassphrase.length);
            return this;
        }

        public KeystoreBuilder keyPassphrase(String privateKeyPassphrase) {
            return this.keyPassphrase(privateKeyPassphrase.toCharArray());
        }

        public KeyConfig build() {
            return this.toFullBuilder().build();
        }

        public Builder toFullBuilder() {
            return this.updateBuilder(KeyConfig.fullBuilder());
        }

        private Builder updateBuilder(Builder builder) {
            if (this.keystoreStream.isSet()) {
                KeyStore keyStore;
                if (null == this.keyPassphrase) {
                    this.keyPassphrase = this.keystorePassphrase;
                }
                try {
                    keyStore = PkiUtil.loadKeystore(this.keystoreType, this.keystoreStream.stream(), this.keystorePassphrase, this.keystoreStream.message());
                }
                finally {
                    this.keystoreStream.closeStream();
                }
                boolean guessing = false;
                if (null == this.keyAlias) {
                    this.keyAlias = KeyConfig.DEFAULT_PRIVATE_KEY_ALIAS;
                    guessing = true;
                }
                try {
                    builder.privateKey(PkiUtil.loadPrivateKey(keyStore, this.keyAlias, this.keyPassphrase));
                }
                catch (Exception e) {
                    if (guessing) {
                        LOGGER.log(Level.FINEST, "Failed to read private key from default alias", e);
                    }
                    throw e;
                }
                List<X509Certificate> certChain = null;
                if (null == this.certChainAlias) {
                    guessing = true;
                    this.certChainAlias = this.keyAlias;
                } else {
                    guessing = false;
                }
                if (null != this.certChainAlias) {
                    try {
                        certChain = PkiUtil.loadCertChain(keyStore, this.certChainAlias);
                        certChain.forEach(builder::addCertChain);
                    }
                    catch (Exception e) {
                        if (guessing) {
                            LOGGER.log(Level.FINEST, "Failed to certificate chain from alias \"" + this.certChainAlias + "\"", e);
                        }
                        throw e;
                    }
                }
                if (null == this.certAlias) {
                    if (null != certChain && !certChain.isEmpty()) {
                        builder.publicKeyCert(certChain.get(0));
                    }
                } else {
                    builder.publicKeyCert(PkiUtil.loadCertificate(keyStore, this.certAlias));
                }
                if (this.addAllCertificates) {
                    PkiUtil.loadCertificates(keyStore).forEach(builder::addCert);
                } else {
                    this.certificateAliases.forEach(it -> builder.addCert(PkiUtil.loadCertificate(keyStore, it)));
                }
            }
            return builder;
        }

        public KeystoreBuilder config(Config config) {
            Config keystoreConfig = config.get("keystore");
            keystoreConfig.get("resource").as(Resource::create).ifPresent(this::keystore);
            Resource.create((Config)config, (String)"keystore").ifPresent(this::keystore);
            DeprecatedConfig.get((Config)config, (String)"keystore.type", (String)"keystore-type").asString().ifPresent(this::keystoreType);
            DeprecatedConfig.get((Config)config, (String)"keystore.passphrase", (String)"keystore-passphrase").asString().map(String::toCharArray).ifPresent(this::keystorePassphrase);
            DeprecatedConfig.get((Config)config, (String)"keystore.key.alias", (String)"key-alias").asString().ifPresent(this::keyAlias);
            DeprecatedConfig.get((Config)config, (String)"keystore.key.passphrase", (String)"key-passphrase").asString().map(String::toCharArray).ifPresent(this::keyPassphrase);
            DeprecatedConfig.get((Config)config, (String)"keystore.cert.alias", (String)"cert-alias").asString().ifPresent(this::certAlias);
            DeprecatedConfig.get((Config)config, (String)"keystore.cert-chain.alias", (String)"cert-chain").asString().ifPresent(this::certChainAlias);
            DeprecatedConfig.get((Config)config, (String)"keystore.trust-store", (String)"trust-store").asBoolean().ifPresent(this::trustStore);
            return this;
        }
    }

    public static class Builder
    implements io.helidon.common.Builder<KeyConfig> {
        private PrivateKey explicitPrivateKey;
        private PublicKey explicitPublicKey;
        private X509Certificate explicitPublicCert;
        private final List<X509Certificate> explicitCertChain = new LinkedList<X509Certificate>();
        private final List<X509Certificate> explicitCertificates = new LinkedList<X509Certificate>();

        public KeyConfig build() throws PkiException {
            PrivateKey privateKey = this.explicitPrivateKey;
            PublicKey publicKey = this.explicitPublicKey;
            X509Certificate publicCert = this.explicitPublicCert;
            LinkedList<X509Certificate> certChain = new LinkedList<X509Certificate>(this.explicitCertChain);
            LinkedList<X509Certificate> certificates = new LinkedList<X509Certificate>(this.explicitCertificates);
            if (null == publicKey && null != publicCert) {
                publicKey = publicCert.getPublicKey();
            }
            return new KeyConfig(privateKey, publicKey, publicCert, certChain, certificates);
        }

        public Builder privateKey(PrivateKey privateKey) {
            this.explicitPrivateKey = privateKey;
            return this;
        }

        public Builder publicKey(PublicKey publicKey) {
            this.explicitPublicKey = publicKey;
            return this;
        }

        public Builder publicKeyCert(X509Certificate certificate) {
            this.explicitPublicCert = certificate;
            return this;
        }

        public Builder addCertChain(X509Certificate certificate) {
            this.explicitCertChain.add(certificate);
            return this;
        }

        public Builder addCert(X509Certificate certificate) {
            this.explicitCertificates.add(certificate);
            return this;
        }

        public Builder updateWith(PemBuilder builder) {
            builder.updateBuilder(this);
            return this;
        }

        public Builder updateWith(KeystoreBuilder builder) {
            builder.updateBuilder(this);
            return this;
        }

        public Builder config(Config config) {
            this.updateWith(KeyConfig.pemBuilder().config(config));
            this.updateWith(KeyConfig.keystoreBuilder().config(config));
            return this;
        }
    }
}

