/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.features.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenFiler;
import io.helidon.codegen.FilerResource;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.common.features.codegen.FeatureCodegenTypes;
import io.helidon.common.features.metadata.Aot;
import io.helidon.common.features.metadata.Deprecation;
import io.helidon.common.features.metadata.FeatureMetadata;
import io.helidon.common.features.metadata.FeatureStatus;
import io.helidon.common.features.metadata.Flavor;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ModuleTypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.metadata.hson.Hson;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class FeatureCodegenExtension
implements CodegenExtension {
    private final CodegenContext ctx;
    private final List<FeatureMetadata> processedModules = new ArrayList<FeatureMetadata>();

    FeatureCodegenExtension(CodegenContext ctx) {
        this.ctx = ctx;
    }

    public void process(RoundContext roundContext) {
        for (ModuleTypeInfo module : roundContext.modules()) {
            this.validate(module);
            this.process(module);
        }
    }

    public void processingOver(RoundContext roundContext) {
        if (this.processedModules.isEmpty()) {
            return;
        }
        List features = this.processedModules.stream().map(rec$ -> ((FeatureMetadata)rec$).toHson()).collect(Collectors.toUnmodifiableList());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));){
            Hson.Array array = Hson.Array.create(features);
            array.write(pw);
        }
        CodegenFiler filer = this.ctx.filer();
        FilerResource resource = filer.resource("META-INF/helidon/feature-registry.json", new Object[0]);
        resource.bytes(baos.toByteArray());
        resource.write();
    }

    private void process(ModuleTypeInfo module) {
        TypeName deprecatedType;
        FeatureMetadata.Builder builder = (FeatureMetadata.Builder)FeatureMetadata.builder().module(module.name());
        builder.name((String)module.annotation(FeatureCodegenTypes.NAME).value().orElseThrow(() -> new CodegenException("Failed to get annotation value " + FeatureCodegenTypes.NAME.fqName(), module.originatingElementValue())));
        module.findAnnotation(FeatureCodegenTypes.DESCRIPTION).flatMap(rec$ -> ((Annotation)rec$).value()).ifPresent(arg_0 -> ((FeatureMetadata.Builder)builder).description(arg_0));
        module.findAnnotation(FeatureCodegenTypes.SINCE).flatMap(rec$ -> ((Annotation)rec$).value()).ifPresent(arg_0 -> ((FeatureMetadata.Builder)builder).since(arg_0));
        module.findAnnotation(FeatureCodegenTypes.PATH).flatMap(rec$ -> ((Annotation)rec$).stringValues()).ifPresent(arg_0 -> ((FeatureMetadata.Builder)builder).path(arg_0));
        module.findAnnotation(FeatureCodegenTypes.FLAVOR).flatMap(it -> it.stringValues()).stream().flatMap(Collection::stream).map(Flavor::valueOf).forEach(arg_0 -> ((FeatureMetadata.Builder)builder).addFlavor(arg_0));
        module.findAnnotation(FeatureCodegenTypes.INVALID_FLAVOR).flatMap(it -> it.stringValues()).stream().flatMap(Collection::stream).map(Flavor::valueOf).forEach(arg_0 -> ((FeatureMetadata.Builder)builder).addFlavor(arg_0));
        if (module.hasAnnotation(FeatureCodegenTypes.INCUBATING)) {
            builder.status(FeatureStatus.INCUBATING);
        }
        if (module.hasAnnotation(FeatureCodegenTypes.PREVIEW)) {
            builder.status(FeatureStatus.PREVIEW);
        }
        if (module.hasAnnotation(deprecatedType = TypeName.create(Deprecated.class))) {
            builder.status(FeatureStatus.DEPRECATED);
            Deprecation.Builder deprecation = (Deprecation.Builder)Deprecation.builder().isDeprecated(true);
            Annotation annotation = module.annotation(deprecatedType);
            annotation.stringValue("since").filter(Predicate.not(String::isBlank)).ifPresent(arg_0 -> ((Deprecation.Builder)deprecation).since(arg_0));
            this.deprecationMessage(module).ifPresent(arg_0 -> ((Deprecation.Builder)deprecation).description(arg_0));
            builder.deprecation(deprecation.build());
        }
        if (module.hasAnnotation(FeatureCodegenTypes.AOT)) {
            Annotation annotation = module.annotation(FeatureCodegenTypes.AOT);
            Aot.Builder aot = Aot.builder();
            aot.supported(annotation.booleanValue().orElse(true).booleanValue());
            annotation.stringValue("description").ifPresent(arg_0 -> ((Aot.Builder)aot).description(arg_0));
            builder.aot(aot.build());
        }
        this.processedModules.add(builder.build());
    }

    private Optional<String> deprecationMessage(ModuleTypeInfo module) {
        Optional description = module.description();
        if (description.isEmpty()) {
            return Optional.empty();
        }
        Javadoc javadoc = Javadoc.parse((String)((String)description.get()));
        if (javadoc.deprecation().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)"\n", javadoc.deprecation()));
    }

    private void validate(ModuleTypeInfo module) {
        if (!module.hasAnnotation(FeatureCodegenTypes.NAME)) {
            throw new CodegenException("Feature must have at least " + FeatureCodegenTypes.NAME.fqName() + " annotation", module.originatingElementValue());
        }
        if (module.hasAnnotation(FeatureCodegenTypes.INCUBATING) && module.hasAnnotation(FeatureCodegenTypes.PREVIEW)) {
            throw new CodegenException("Illegal combination of annotations, feature can be either Incubating, or Preview", module.originatingElementValue());
        }
        if (module.hasAnnotation(FeatureCodegenTypes.FLAVOR) && module.hasAnnotation(FeatureCodegenTypes.INVALID_FLAVOR)) {
            List<Flavor> in = module.annotation(FeatureCodegenTypes.FLAVOR).stringValues().stream().flatMap(Collection::stream).map(Flavor::valueOf).toList();
            List<Flavor> notIn = module.annotation(FeatureCodegenTypes.INVALID_FLAVOR).stringValues().stream().flatMap(Collection::stream).map(Flavor::valueOf).toList();
            for (Flavor helidonFlavor : in) {
                if (!notIn.contains(helidonFlavor)) continue;
                throw new CodegenException("Illegal combination of flavors, where " + String.valueOf(helidonFlavor) + " is configured both as valid and invalid", module.originatingElementValue());
            }
        }
    }
}

