/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.spi.AnnotationMapper;
import io.helidon.codegen.spi.ElementMapper;
import io.helidon.codegen.spi.TypeMapper;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public abstract class TypeInfoFactoryBase {
    private static final Set<TypeName> IGNORED_ANNOTATIONS = Set.of(TypeName.create(SuppressWarnings.class), TypeName.create(Override.class), TypeName.create(Target.class), TypeName.create(Retention.class), TypeName.create(Repeatable.class));
    private static final Set<String> ACCESS_MODIFIERS = Set.of("PUBLIC", "PRIVATE", "PROTECTED");

    protected TypeInfoFactoryBase() {
    }

    protected static Optional<TypeInfo> mapType(CodegenContext ctx, TypeInfo type) {
        TypeInfo toReturn = type;
        for (TypeMapper typeMapper : ctx.typeMappers()) {
            if (!typeMapper.supportsType(toReturn)) continue;
            Optional<TypeInfo> mapped = typeMapper.map(ctx, toReturn);
            if (mapped.isEmpty()) {
                return mapped;
            }
            toReturn = mapped.get();
        }
        return Optional.of(toReturn);
    }

    protected static Optional<TypedElementInfo> mapElement(CodegenContext ctx, TypedElementInfo element) {
        TypedElementInfo toReturn = element;
        for (ElementMapper elementMapper : ctx.elementMappers()) {
            if (!elementMapper.supportsElement(toReturn)) continue;
            Optional<TypedElementInfo> mapped = elementMapper.mapElement(ctx, toReturn);
            if (mapped.isEmpty()) {
                return mapped;
            }
            toReturn = mapped.get();
        }
        return Optional.of(toReturn);
    }

    protected static List<Annotation> mapAnnotation(CodegenContext ctx, Annotation annotation, ElementKind kind) {
        ArrayList<Annotation> toProcess = new ArrayList<Annotation>();
        toProcess.add(annotation);
        for (AnnotationMapper annotationMapper : ctx.annotationMappers()) {
            ArrayList<Annotation> nextToProcess = new ArrayList<Annotation>();
            for (Annotation annot : toProcess) {
                if (annotationMapper.supportsAnnotation(annot)) {
                    nextToProcess.addAll(annotationMapper.mapAnnotation(ctx, annot, kind));
                    continue;
                }
                nextToProcess.add(annot);
            }
            toProcess = nextToProcess;
        }
        return toProcess;
    }

    protected static boolean annotationFilter(Annotation annotation) {
        return !IGNORED_ANNOTATIONS.contains(annotation.typeName());
    }

    protected static Set<Modifier> modifiers(CodegenContext ctx, Set<String> stringModifiers) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        for (String stringModifier : stringModifiers) {
            String upperCased = stringModifier.toUpperCase(Locale.ROOT);
            if (ACCESS_MODIFIERS.contains(upperCased)) continue;
            try {
                result.add(Modifier.valueOf((String)upperCased));
            }
            catch (Exception ignored) {
                ctx.logger().log(System.Logger.Level.TRACE, "Modifier " + stringModifier + " not understood by type info factory.");
            }
        }
        return result;
    }

    protected static boolean isBuiltInJavaType(TypeName type) {
        return type.primitive() || type.packageName().startsWith("java.");
    }
}

