/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class TypeHierarchy {
    private TypeHierarchy() {
    }

    public static List<Annotation> hierarchyAnnotations(CodegenContext ctx, TypeInfo type) {
        LinkedHashMap<TypeName, Annotation> annotations = new LinkedHashMap<TypeName, Annotation>();
        type.annotations().forEach(annot -> annotations.put(annot.typeName(), (Annotation)annot));
        type.superTypeInfo().ifPresent(it -> it.inheritedAnnotations().forEach(annot -> annotations.putIfAbsent(annot.typeName(), (Annotation)annot)));
        for (TypeInfo typeInfo : type.interfaceTypeInfo()) {
            typeInfo.annotations().stream().filter(annot -> typeInfo.hasMetaAnnotation(annot.typeName(), TypeNames.INHERITED)).forEach(annot -> annotations.putIfAbsent(annot.typeName(), (Annotation)annot));
        }
        HashSet<TypeName> processedTypes = new HashSet<TypeName>(annotations.keySet());
        TypeHierarchy.processMetaAnnotations(ctx, processedTypes, annotations);
        return List.copyOf(annotations.values());
    }

    public static List<Annotation> hierarchyAnnotations(CodegenContext ctx, TypeInfo type, TypedElementInfo element) {
        if (element.kind() != ElementKind.METHOD) {
            return element.annotations();
        }
        ArrayList prototypes = new ArrayList();
        HashSet<TypeName> processedTypes = new HashSet<TypeName>();
        String packageName = type.typeName().packageName();
        type.superTypeInfo().ifPresent(it -> TypeHierarchy.collectInheritedMethods(processedTypes, prototypes, it, element, packageName));
        type.interfaceTypeInfo().forEach(it -> TypeHierarchy.collectInheritedMethods(processedTypes, prototypes, it, element, packageName));
        LinkedHashMap<TypeName, Annotation> annotations = new LinkedHashMap<TypeName, Annotation>();
        element.annotations().forEach(annot -> annotations.put(annot.typeName(), (Annotation)annot));
        for (TypedElementInfo prototype : prototypes) {
            prototype.annotations().forEach(annot -> annotations.putIfAbsent(annot.typeName(), (Annotation)annot));
        }
        TypeHierarchy.processMetaAnnotations(ctx, processedTypes, annotations);
        return List.copyOf(annotations.values());
    }

    public static List<Annotation> hierarchyAnnotations(CodegenContext ctx, TypeInfo type, TypedElementInfo executable, TypedElementInfo parameter, int parameterIndex) {
        if (parameter.kind() != ElementKind.PARAMETER) {
            throw new CodegenException("This method only supports processing of parameter, yet kind is: " + String.valueOf(parameter.kind()));
        }
        if (executable.kind() != ElementKind.CONSTRUCTOR && executable.kind() != ElementKind.METHOD) {
            throw new CodegenException("This method only supports processing of parameters of methods or constructors, yet executable kind is: " + String.valueOf(executable.kind()));
        }
        if (executable.kind() == ElementKind.CONSTRUCTOR) {
            return parameter.annotations();
        }
        ArrayList prototypes = new ArrayList();
        HashSet<TypeName> processedTypes = new HashSet<TypeName>();
        String packageName = type.typeName().packageName();
        type.superTypeInfo().ifPresent(it -> TypeHierarchy.collectInheritedMethods(processedTypes, prototypes, it, executable, packageName));
        type.interfaceTypeInfo().forEach(it -> TypeHierarchy.collectInheritedMethods(processedTypes, prototypes, it, executable, packageName));
        LinkedHashMap<TypeName, Annotation> annotations = new LinkedHashMap<TypeName, Annotation>();
        parameter.annotations().forEach(annot -> annotations.put(annot.typeName(), (Annotation)annot));
        for (TypedElementInfo prototype : prototypes) {
            ((TypedElementInfo)prototype.parameterArguments().get(parameterIndex)).annotations().forEach(annot -> annotations.putIfAbsent(annot.typeName(), (Annotation)annot));
        }
        TypeHierarchy.processMetaAnnotations(ctx, processedTypes, annotations);
        return List.copyOf(annotations.values());
    }

    public static Set<TypeName> nestedAnnotations(CodegenContext ctx, TypeInfo typeInfo) {
        HashSet<TypeName> result = new HashSet<TypeName>();
        typeInfo.annotations().stream().map(Annotation::typeName).forEach(result::add);
        typeInfo.inheritedAnnotations().stream().map(Annotation::typeName).forEach(result::add);
        TypeHierarchy.genericTypeAnnotations(typeInfo.typeName()).stream().map(Annotation::typeName).forEach(result::add);
        typeInfo.elementInfo().stream().map(Annotated::annotations).flatMap(Collection::stream).map(Annotation::typeName).forEach(result::add);
        typeInfo.elementInfo().stream().map(Annotated::inheritedAnnotations).flatMap(Collection::stream).map(Annotation::typeName).forEach(result::add);
        typeInfo.elementInfo().stream().map(TypedElementInfo::typeName).map(TypeHierarchy::genericTypeAnnotations).flatMap(Collection::stream).map(Annotation::typeName).forEach(result::add);
        typeInfo.elementInfo().stream().map(TypedElementInfo::parameterArguments).flatMap(Collection::stream).map(Annotated::annotations).flatMap(Collection::stream).map(Annotation::typeName).forEach(result::add);
        typeInfo.elementInfo().stream().map(TypedElementInfo::parameterArguments).flatMap(Collection::stream).map(Annotated::inheritedAnnotations).flatMap(Collection::stream).map(Annotation::typeName).forEach(result::add);
        typeInfo.elementInfo().stream().map(TypedElementInfo::parameterArguments).flatMap(Collection::stream).map(TypedElementInfo::typeName).map(TypeHierarchy::genericTypeAnnotations).flatMap(Collection::stream).map(Annotation::typeName).forEach(result::add);
        return result;
    }

    private static List<Annotation> genericTypeAnnotations(TypeName typeName) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (TypeName typeArgument : typeName.typeArguments()) {
            result.addAll(typeArgument.annotations());
            TypeHierarchy.genericTypeAnnotations(typeArgument);
        }
        return result;
    }

    private static void processMetaAnnotations(CodegenContext ctx, Set<TypeName> processedTypes, Map<TypeName, Annotation> annotations) {
        ArrayList newAnnotations = new ArrayList();
        for (Annotation value : annotations.values()) {
            Optional<TypeInfo> typeInfo = ctx.typeInfo(value.typeName());
            if (!typeInfo.isPresent()) continue;
            TypeInfo annotationInfo = typeInfo.get();
            annotationInfo.annotations().forEach(metaAnnotation -> TypeHierarchy.collectMetaAnnotations(ctx, processedTypes, newAnnotations, metaAnnotation));
        }
        newAnnotations.forEach(it -> annotations.putIfAbsent(it.typeName(), (Annotation)it));
    }

    private static void collectMetaAnnotations(CodegenContext ctx, Set<TypeName> processedTypes, List<Annotation> metaAnnotations, Annotation annotation) {
        if (!processedTypes.add(annotation.typeName())) {
            return;
        }
        Optional<TypeInfo> typeInfo = ctx.typeInfo(annotation.typeName());
        if (typeInfo.isEmpty()) {
            return;
        }
        TypeInfo annotationInfo = typeInfo.get();
        if (annotationInfo.hasAnnotation(TypeNames.INHERITED)) {
            metaAnnotations.add(annotation);
        }
        annotationInfo.annotations().forEach(metaAnnotation -> TypeHierarchy.collectMetaAnnotations(ctx, processedTypes, metaAnnotations, metaAnnotation));
    }

    private static void collectInheritedMethods(Set<TypeName> processed, List<TypedElementInfo> collected, TypeInfo type, TypedElementInfo method, String currentPackage) {
        if (!processed.add(type.typeName())) {
            return;
        }
        TypeHierarchy.inherited(type, method, method.parameterArguments().stream().map(TypedElementInfo::typeName).collect(Collectors.toUnmodifiableList()), currentPackage).ifPresent(collected::add);
        type.superTypeInfo().ifPresent(it -> TypeHierarchy.collectInheritedMethods(processed, collected, it, method, currentPackage));
        for (TypeInfo typeInfo : type.interfaceTypeInfo()) {
            TypeHierarchy.collectInheritedMethods(processed, collected, typeInfo, method, currentPackage);
        }
    }

    private static Optional<TypedElementInfo> inherited(TypeInfo type, TypedElementInfo method, List<TypeName> arguments, String currentPackage) {
        String methodName = method.elementName();
        Optional<TypedElementInfo> found = type.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(ElementInfoPredicates.elementName(methodName)).filter(ElementInfoPredicates.hasParams(arguments)).findFirst();
        if (found.isPresent()) {
            boolean realOverride;
            TypedElementInfo superMethod = found.get();
            boolean bl = realOverride = superMethod.accessModifier() != AccessModifier.PACKAGE_PRIVATE || currentPackage.equals(type.typeName().packageName());
            if (realOverride) {
                return Optional.of(superMethod);
            }
        }
        return Optional.empty();
    }
}

