/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CodegenScope;
import io.helidon.codegen.IndentType;
import io.helidon.codegen.Option;
import io.helidon.common.GenericType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public interface CodegenOptions {
    public static final String TAG_CODEGEN_MODULE = "helidon.codegen.module-name";
    public static final String TAG_CODEGEN_PACKAGE = "helidon.codegen.package-name";
    public static final Option<CodegenScope> CODEGEN_SCOPE = Option.create("helidon.codegen.scope", "Override scope that is \"guessed\" from the environment. By default we support production and test scopes", CodegenScope.PRODUCTION, CodegenScope::new, GenericType.create(CodegenScope.class));
    public static final Option<String> CODEGEN_MODULE = Option.create("helidon.codegen.module-name", "Override name of the module that is being processed, or provide it if this module does not have a module-info.java", "");
    public static final Option<String> CODEGEN_PACKAGE = Option.create("helidon.codegen.package-name", "Define package to use for generated types.", "");
    public static final Option<IndentType> INDENT_TYPE = Option.create("helidon.codegen.indent.type", "Type of indentation, either of " + Arrays.toString((Object[])IndentType.values()), IndentType.SPACE, IndentType::valueOf, GenericType.create(IndentType.class));
    public static final Option<Integer> INDENT_COUNT = Option.create("helidon.codegen.indent.count", "Number of indents to use (such as 4, if combined with SPACE will indent by 4 spaces", 4);
    public static final Option<Boolean> CREATE_META_INF_SERVICES = Option.create("helidon.codegen.meta-inf.services", "Whether to create META-INF/services for generated services even if module-info.java is present", true);

    public Optional<String> option(String var1);

    default public <T extends Enum<T>> T option(String option, T defaultValue, Class<T> enumType) {
        return (T)this.option(option).map(it -> Enum.valueOf(enumType, it)).orElse(defaultValue);
    }

    default public boolean enabled(Option<Boolean> option) {
        return option.value(this);
    }

    default public List<String> asList(String option) {
        return this.option(option).stream().map(it -> it.split(",")).flatMap(Stream::of).map(String::trim).toList();
    }

    default public Set<String> asSet(String option) {
        return Set.copyOf(this.asList(option));
    }

    default public void validate(Set<Option<?>> permittedOptions) {
    }
}

