/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.common.Size;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.net.URI;
import java.time.Duration;

public final class CodegenValidator {
    private CodegenValidator() {
    }

    public static String validateUri(TypeName enclosingType, TypedElementInfo element, TypeName annotationType, String property, String value) {
        try {
            URI.create(value);
            return value;
        }
        catch (Exception e) {
            throw new CodegenException("URI expression of annotation " + annotationType.fqName() + "." + property + "(): \"" + value + "\" cannot be parsed. Invalid URI.", e, element.originatingElementValue());
        }
    }

    public static String validateDuration(TypeName enclosingType, TypedElementInfo element, TypeName annotationType, String property, String value) {
        try {
            Duration.parse(value);
            return value;
        }
        catch (Exception e) {
            throw new CodegenException("Duration expression of annotation " + annotationType.fqName() + "." + property + "(): \"" + value + "\" cannot be parsed. Duration expects an expression such as 'PT1S' (1 second), 'PT0.1S' (tenth of a second). Please check javadoc of " + Duration.class.getName() + " class.", e, element.originatingElementValue());
        }
    }

    public static String validateSize(TypeName enclosingType, TypedElementInfo element, TypeName annotationType, String property, String value) {
        try {
            Size.parse((String)value);
            return value;
        }
        catch (Exception e) {
            throw new CodegenException("Size expression of annotation " + annotationType.fqName() + "." + property + "(): \"" + value + "\" cannot be parsed. Size expects an expression such as '120 KB' (120 * 1024 * 1024), '120 kB' (120 * 1000 * 1000), or '120 KiB' (same as KB) Please check javadoc of " + Size.class.getName() + " class.", e, element.originatingElementValue());
        }
    }
}

