/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.FilerResource;
import io.helidon.codegen.FilerTextResource;
import io.helidon.codegen.GeneratedAnnotationHandler;
import io.helidon.codegen.ManifestResource;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.common.types.TypeName;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface CodegenFiler {
    public Path writeSourceFile(ClassModel var1, Object ... var2);

    public Path writeSourceFile(TypeName var1, String var2, Object ... var3);

    public Path writeResource(byte[] var1, String var2, Object ... var3);

    default public FilerTextResource textResource(String location, Object ... originatingElements) {
        throw new UnsupportedOperationException("Method textResource not implemented yet on " + this.getClass().getName());
    }

    default public FilerResource resource(String location, Object ... originatingElements) {
        throw new UnsupportedOperationException("Method resource not implemented yet on " + this.getClass().getName());
    }

    default public ManifestResource manifest() {
        return ManifestResource.create(this);
    }

    default public void services(TypeName generator, TypeName providerInterface, List<TypeName> providers, Object ... originatingElements) {
        Objects.requireNonNull(generator);
        Objects.requireNonNull(providerInterface);
        Objects.requireNonNull(providers);
        if (providers.isEmpty()) {
            return;
        }
        String location = "META-INF/services/" + providerInterface.fqName();
        FilerTextResource resource = this.textResource(location, originatingElements);
        ArrayList<String> lines = new ArrayList<String>(resource.lines());
        Set existingServices = lines.stream().map(String::trim).filter(Predicate.not(it -> it.startsWith("#"))).map(TypeName::create).collect(Collectors.toSet());
        if (lines.isEmpty()) {
            lines.add("# " + String.valueOf(GeneratedAnnotationHandler.create(generator, providers.getFirst(), TypeName.create((String)"MetaInfServicesModuleComponent"), "1", "")));
        }
        for (TypeName provider : providers) {
            if (!existingServices.add(provider)) continue;
            lines.add(provider.fqName());
        }
        resource.lines(lines);
        resource.write();
    }
}

