/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.scan;

import io.github.classgraph.ModuleRef;
import io.helidon.codegen.ModuleInfo;
import io.helidon.codegen.ModuleInfoRequires;
import io.helidon.common.types.TypeName;
import java.lang.module.ModuleDescriptor;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class ScanModuleInfo {
    private ScanModuleInfo() {
    }

    public static Optional<ModuleInfo> map(ModuleRef scanModuleInfo) {
        Object descriptor = scanModuleInfo.getDescriptor();
        if (!(descriptor instanceof ModuleDescriptor)) {
            return Optional.empty();
        }
        ModuleDescriptor javaDescriptor = (ModuleDescriptor)descriptor;
        ModuleInfo.Builder builder = (ModuleInfo.Builder)((ModuleInfo.Builder)ModuleInfo.builder().name(javaDescriptor.name())).isOpen(javaDescriptor.isOpen());
        javaDescriptor.exports().forEach(it -> builder.putExports(it.source(), List.copyOf(it.targets())));
        javaDescriptor.opens().forEach(opens -> builder.putOpen(opens.source(), List.copyOf(opens.targets())));
        javaDescriptor.uses().forEach(uses -> builder.addUse(TypeName.create((String)uses)));
        javaDescriptor.requires().stream().map(it -> new ModuleInfoRequires(it.name(), ScanModuleInfo.isTransitive(it.modifiers()), ScanModuleInfo.isStatic(it.modifiers()))).forEach(arg_0 -> ((ModuleInfo.Builder)builder).addRequire(arg_0));
        javaDescriptor.provides().forEach(it -> builder.putProvide(TypeName.create((String)it.service()), it.providers().stream().map(TypeName::create).toList()));
        return Optional.of(builder.build());
    }

    private static boolean isTransitive(Set<ModuleDescriptor.Requires.Modifier> modifiers) {
        return modifiers.contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE);
    }

    private static boolean isStatic(Set<ModuleDescriptor.Requires.Modifier> modifiers) {
        return modifiers.contains((Object)ModuleDescriptor.Requires.Modifier.STATIC);
    }
}

