/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.scan;

import io.github.classgraph.AnnotationClassRef;
import io.github.classgraph.AnnotationEnumValue;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.AnnotationParameterValueList;
import io.helidon.codegen.scan.ScanContext;
import io.helidon.codegen.scan.ScanTypeFactory;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

final class ScanAnnotationFactory {
    private ScanAnnotationFactory() {
    }

    public static Annotation createAnnotation(ScanContext ctx, AnnotationInfo am) {
        TypeName typeName = ScanTypeFactory.create(am.getClassInfo());
        return Annotation.create((TypeName)typeName, ScanAnnotationFactory.extractAnnotationValues(ctx, am));
    }

    private static Map<String, Object> extractAnnotationValues(ScanContext ctx, AnnotationInfo am) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        AnnotationParameterValueList parameterValues = am.getParameterValues();
        for (AnnotationParameterValue parameterValue : parameterValues) {
            String name = parameterValue.getName();
            Object value = parameterValue.getValue();
            if (value == null) continue;
            result.put(name, ScanAnnotationFactory.toAnnotationValue(ctx, value));
        }
        return result;
    }

    private static Object toAnnotationValue(ScanContext ctx, Object scanAnnotationValue) {
        if (scanAnnotationValue.getClass().isArray()) {
            ArrayList<Object> result = new ArrayList<Object>();
            int length = Array.getLength(scanAnnotationValue);
            for (int i = 0; i < length; ++i) {
                result.add(ScanAnnotationFactory.toAnnotationValue(ctx, Array.get(scanAnnotationValue, i)));
            }
            return result;
        }
        if (scanAnnotationValue instanceof AnnotationEnumValue) {
            AnnotationEnumValue anEnum = (AnnotationEnumValue)scanAnnotationValue;
            return anEnum.getValueName();
        }
        if (scanAnnotationValue instanceof AnnotationClassRef) {
            AnnotationClassRef aClass = (AnnotationClassRef)scanAnnotationValue;
            return TypeName.create((String)aClass.getName());
        }
        if (scanAnnotationValue instanceof AnnotationInfo) {
            AnnotationInfo annotation = (AnnotationInfo)scanAnnotationValue;
            return ScanAnnotationFactory.createAnnotation(ctx, annotation);
        }
        return scanAnnotationValue;
    }
}

