/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.ContentSupport;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;

public interface ContentBuilder<T extends ContentBuilder<T>> {
    default public T content(String content) {
        return this.content(List.of(content));
    }

    public T content(List<String> var1);

    default public T addContentLine(String line) {
        return this.addContent(line).addContent("\n");
    }

    default public T addContentLine() {
        return this.addContent("\n");
    }

    default public T addContentLiteral(String literal) {
        return this.addContent("\"" + literal + "\"");
    }

    public T addContent(String var1);

    default public T addContent(TypeName typeName) {
        return this.addTypeToContent(typeName.resolvedName());
    }

    default public T addContent(Class<?> type) {
        return this.addTypeToContent(type.getCanonicalName());
    }

    default public T addContentCreate(TypeName typeName) {
        ContentSupport.addCreateTypeName(this, typeName);
        return this.addContent("");
    }

    default public T addContentCreate(ResolvedType type) {
        return this.addContent(ResolvedType.class).addContent(".create(\"").addContent(type.resolvedName()).addContent("\")");
    }

    default public T addContentCreate(Annotation annotation) {
        ContentSupport.addCreateAnnotation(this, annotation);
        return this.addContent("");
    }

    default public T addContentCreate(TypedElementInfo element) {
        ContentSupport.addCreateElement(this, element);
        return this.addContent("");
    }

    public T addTypeToContent(String var1);

    public T padContent();

    public T padContent(int var1);

    public T increaseContentPadding();

    public T decreaseContentPadding();

    public T clearContent();
}

