/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.AnnotatedComponent;
import io.helidon.codegen.classmodel.Annotation;
import io.helidon.codegen.classmodel.ClassModelException;
import io.helidon.codegen.classmodel.ClassType;
import io.helidon.codegen.classmodel.ImportOrganizer;
import io.helidon.codegen.classmodel.ModelWriter;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class Parameter
extends AnnotatedComponent {
    private final boolean vararg;
    private final List<String> description;

    private Parameter(Builder builder) {
        super(builder);
        this.vararg = builder.vararg;
        this.description = List.copyOf(builder.description);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        return this.vararg == parameter.vararg && this.type().equals(parameter.type());
    }

    public int hashCode() {
        return Objects.hash(this.vararg);
    }

    public String toString() {
        return "Parameter{type=" + this.type().fqTypeName() + ", simpleType=" + this.type().simpleTypeName() + ", name=" + this.name() + "}";
    }

    @Override
    public List<String> description() {
        return this.description;
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ClassType classType) throws IOException {
        for (Annotation annotation : this.annotations()) {
            annotation.writeComponent(writer, declaredTokens, imports, classType);
            writer.write(" ");
        }
        this.type().writeComponent(writer, declaredTokens, imports, classType);
        if (this.vararg) {
            writer.write("...");
        }
        writer.write(" " + this.name());
    }

    public static final class Builder
    extends AnnotatedComponent.Builder<Builder, Parameter> {
        private final List<String> description = new ArrayList<String>();
        private boolean vararg = false;

        private Builder() {
        }

        public Parameter build() {
            if (this.type() == null || this.name() == null) {
                throw new ClassModelException("Annotation parameter must have name and type set");
            }
            return new Parameter(this);
        }

        public Builder vararg(boolean vararg) {
            this.vararg = vararg;
            return this;
        }

        @Override
        public Builder description(List<String> description) {
            this.description.clear();
            this.description.addAll(description);
            return this;
        }

        @Override
        public Builder type(TypeName type) {
            if (type.vararg()) {
                this.vararg(true);
                return (Builder)super.type(((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)type).array(false)).vararg(false)).build());
            }
            return (Builder)super.type(type);
        }

        @Override
        public Builder type(String type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder type(Class<?> type) {
            return (Builder)super.type(type);
        }
    }
}

