/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.Annotation;
import io.helidon.common.types.EnumValue;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.List;

final class AnnotationParser {
    private static final System.Logger LOGGER = System.getLogger(AnnotationParser.class.getName());
    private static final String CLASS_PREFIX = "class::";
    private static final String ENUM_PREFIX = "enum::";

    private AnnotationParser() {
    }

    static Annotation parse(String annotationDefinition) {
        String annotationString = annotationDefinition.replaceAll("\n", "");
        int annotationBodyStart = annotationString.indexOf("(");
        int annotationBodyEnd = annotationString.lastIndexOf(")");
        if (annotationBodyStart > 0 || annotationBodyEnd > 0) {
            if (annotationBodyStart < 0 || annotationBodyEnd < 0) {
                throw new IllegalArgumentException("Invalid annotation definition, inconsistent braces: " + annotationDefinition);
            }
            return AnnotationParser.parseWithValues(annotationString, annotationBodyStart, annotationBodyEnd);
        }
        return Annotation.builder().type(annotationString).build();
    }

    private static Annotation parseWithValues(String annotationDefinition, int annotationBodyStart, int annotationBodyEnd) {
        String annotationName = annotationDefinition.substring(0, annotationBodyStart).trim();
        String annotationBody = annotationDefinition.substring(annotationBodyStart + 1, annotationBodyEnd).trim();
        int equals = annotationDefinition.indexOf(61, annotationBodyStart);
        if (annotationBody.startsWith("\"") || annotationBody.startsWith("@") || equals == -1) {
            return Annotation.builder().type(annotationName).addParameter("value", AnnotationParser.toValue(annotationDefinition.substring(annotationBodyStart + 1, annotationBodyEnd))).build();
        }
        return AnnotationParser.parseWithNamedValues(annotationName, annotationBody);
    }

    private static Object toValue(String value) {
        if (value.isBlank()) {
            throw new IllegalArgumentException("Invalid custom annotation value specified (blank)");
        }
        if (value.indexOf(34) == 0) {
            if (value.lastIndexOf(34) == value.length() - 1) {
                return value.substring(1, value.length() - 1).replaceAll("\\\\", "");
            }
            throw new IllegalArgumentException("Invalid annotation value specified, inconsistent quotes: " + value);
        }
        if (value.indexOf(39) == 0) {
            if (value.lastIndexOf(39) == value.length() - 1) {
                if (value.length() == 3) {
                    return Character.valueOf(value.charAt(1));
                }
                if (value.length() == 4) {
                    char backslash = value.charAt(1);
                    if (backslash != '\\') {
                        throw new IllegalArgumentException("Invalid annotation value specified, expected escaped value: " + value);
                    }
                    char next = value.charAt(2);
                    return switch (next) {
                        case 't' -> Character.valueOf('\t');
                        case 'n' -> Character.valueOf('\n');
                        case 'r' -> Character.valueOf('\r');
                        case 'f' -> Character.valueOf('\f');
                        case '\'' -> Character.valueOf('\'');
                        default -> throw new IllegalArgumentException("Invalid annotation value specified, invalid escaped value (expected one of t, n, r, f, '): " + value);
                    };
                }
                throw new IllegalArgumentException("Invalid annotation value specified, char must be a single character,or an escaped character : " + value);
            }
            throw new IllegalArgumentException("Invalid annotation value specified, inconsistent single quotes: " + value);
        }
        if (value.startsWith(CLASS_PREFIX)) {
            return TypeName.create((String)value.substring(CLASS_PREFIX.length()));
        }
        if (value.startsWith(ENUM_PREFIX)) {
            String enumAndValue = value.substring(ENUM_PREFIX.length());
            int dot = enumAndValue.lastIndexOf(46);
            if (dot > 0) {
                return EnumValue.create((TypeName)TypeName.create((String)enumAndValue.substring(0, dot)), (String)enumAndValue.substring(dot + 1));
            }
            throw new IllegalArgumentException("Invalid annotation value specified, invalid enum (must be enum::class.VALUE): " + value);
        }
        if (value.charAt(0) == '@') {
            return AnnotationParser.parse(value.substring(1)).toTypesAnnotation();
        }
        if (value.charAt(0) == '{') {
            if (value.charAt(value.length() - 1) != '}') {
                throw new IllegalArgumentException("Invalid annotation value specified, inconsistent array: " + value);
            }
            return AnnotationParser.parseArray(value.substring(1, value.length() - 1));
        }
        if (value.equals("true") || value.equals("false")) {
            return Boolean.parseBoolean(value);
        }
        char lastChar = value.charAt(value.length() - 1);
        try {
            return switch (lastChar) {
                case 'D', 'd' -> Double.parseDouble(value.substring(0, value.length() - 1));
                case 'L', 'l' -> Long.parseLong(value.substring(0, value.length() - 1));
                case 'F', 'f' -> Float.valueOf(Float.parseFloat(value.substring(0, value.length() - 1)));
                case 'B', 'b' -> Byte.parseByte(value.substring(0, value.length() - 1));
                case 'S', 's' -> Short.parseShort(value.substring(0, value.length() - 1));
                default -> Integer.parseInt(value);
            };
        }
        catch (Exception e) {
            int dot = value.lastIndexOf(46);
            if (dot > 0) {
                LOGGER.log(System.Logger.Level.WARNING, "Unquoted annotation value found, assuming enum. Please prefix the value with 'enum::', this will be removed in future versions.  Value: " + value);
                return EnumValue.create((TypeName)TypeName.create((String)value.substring(0, dot)), (String)value.substring(dot + 1));
            }
            throw new IllegalArgumentException("Invalid annotation value specified. Unquoted value must be one of: true, false, integer, or a number suffixed by D, L, F, B, or S (double, long, float, byte, short), or prefixed with class:: or enum::, but was: " + value);
        }
    }

    private static Object parseArray(String arrayString) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (arrayString.isEmpty()) {
            return List.of();
        }
        if (arrayString.isBlank()) {
            return List.of();
        }
        int index = 0;
        block0: while (true) {
            int nextValueEnd = AnnotationParser.nextValueEnd(arrayString, index);
            list.add(AnnotationParser.toValue(arrayString.substring(index, nextValueEnd)));
            index = nextValueEnd;
            if (arrayString.length() == index || arrayString.length() == index + 1) {
                return list;
            }
            if (arrayString.charAt(index) != ',') {
                return list;
            }
            ++index;
            while (true) {
                if (!Character.isWhitespace(arrayString.charAt(index))) continue block0;
                ++index;
            }
            break;
        }
    }

    private static int nextValueEnd(String valueString, int index) {
        if (valueString.charAt(index) == '\"') {
            int previousChar = 32;
            for (int i = index + 1; i < valueString.length(); ++i) {
                char current = valueString.charAt(i);
                if (previousChar == 92) {
                    previousChar = current;
                    continue;
                }
                previousChar = current;
                if (current != '\"') continue;
                return i + 1;
            }
            return valueString.length();
        }
        if (valueString.charAt(index) == '\'') {
            if (valueString.charAt(index + 1) == '\\') {
                return index + 4;
            }
            return index + 3;
        }
        if (valueString.charAt(index) == '{') {
            int nextArrayEnd;
            int arrayIndex = index;
            while (true) {
                int end = AnnotationParser.nextValueEnd(valueString, arrayIndex + 1);
                int nextComma = AnnotationParser.nextComma(valueString, end);
                nextArrayEnd = AnnotationParser.nextArrayEnd(valueString, end);
                if (nextComma != -1 && nextArrayEnd != -1) {
                    if (nextComma < nextArrayEnd) {
                        arrayIndex = nextComma;
                        continue;
                    }
                    return nextArrayEnd + 1;
                }
                if (nextComma == -1) break;
                arrayIndex = nextComma;
            }
            if (nextArrayEnd != -1) {
                return nextArrayEnd + 1;
            }
            throw new IllegalArgumentException("Invalid annotation value specified. Inconsistent array: " + valueString);
        }
        for (int i = index; i < valueString.length(); ++i) {
            char current = valueString.charAt(i);
            switch (current) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case '}': {
                    return i;
                }
            }
        }
        return valueString.length();
    }

    private static int nextArrayEnd(String valueString, int index) {
        for (int i = index; i < valueString.length(); ++i) {
            if (valueString.charAt(i) != '}') continue;
            return i;
        }
        return -1;
    }

    private static int nextComma(String valueString, int index) {
        for (int i = index; i < valueString.length(); ++i) {
            if (valueString.charAt(i) != ',') continue;
            return i;
        }
        return -1;
    }

    private static Annotation parseWithNamedValues(String annotationName, String annotationBody) {
        int end;
        Annotation.Builder builder = Annotation.builder().type(annotationName);
        int equals = annotationBody.indexOf(61);
        String remainder = annotationBody;
        do {
            String key = remainder.substring(0, equals).trim();
            remainder = remainder.substring(equals + 1).trim();
            end = AnnotationParser.nextValueEnd(remainder, 0);
            Object value = AnnotationParser.toValue(remainder.substring(0, end));
            builder.addParameter(param -> param.name(key).value(value));
            if (remainder.length() > end + 1) continue;
            return builder.build();
        } while ((equals = (remainder = remainder.substring(end + 1).trim()).indexOf(61)) != -1);
        throw new IllegalArgumentException("Invalid annotation value specified, unexpected values structure: " + annotationBody);
    }
}

