/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.ConcreteType;
import io.helidon.codegen.classmodel.ModelComponent;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.types.TypeName;
import java.util.List;
import java.util.Optional;

abstract class Type
extends ModelComponent {
    Type(ModelComponent.Builder<?, ?> builder) {
        super(builder);
    }

    static Type fromTypeName(TypeName typeName) {
        if (typeName instanceof TypeArgument) {
            TypeArgument argument = (TypeArgument)typeName;
            return argument;
        }
        if (typeName.typeArguments().isEmpty()) {
            if (typeName.array() || Optional.class.getName().equals(typeName.declaredName())) {
                return ConcreteType.builder().type(typeName).build();
            }
            if (typeName.wildcard()) {
                List upperBounds = typeName.upperBounds();
                if (upperBounds.isEmpty()) {
                    if (typeName.lowerBounds().isEmpty()) {
                        return TypeArgument.create("?");
                    }
                    return TypeArgument.builder().token("?").bound((TypeName)typeName.lowerBounds().getFirst()).lowerBound(true).build();
                }
                return TypeArgument.builder().token("?").bound((TypeName)upperBounds.getFirst()).build();
            }
            return ConcreteType.builder().type(typeName).build();
        }
        ConcreteType.Builder typeBuilder = ConcreteType.builder().type(typeName);
        typeName.typeArguments().forEach(typeBuilder::addParam);
        return typeBuilder.build();
    }

    abstract TypeName typeName();

    abstract String fqTypeName();

    abstract String resolvedTypeName();

    abstract String packageName();

    abstract String simpleTypeName();

    abstract boolean isArray();

    abstract boolean innerClass();

    abstract Optional<Type> declaringClass();

    abstract TypeName genericTypeName();
}

