/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.EnumValue;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class ContentSupport {
    private static final TypeName ANNOTATION = TypeName.create(Annotation.class);
    private static final TypeName ELEMENT = TypeName.create(TypedElementInfo.class);
    private static final TypeName ELEMENT_KIND = TypeName.create(ElementKind.class);
    private static final TypeName MODIFIER = TypeName.create(Modifier.class);
    private static final TypeName ACCESS_MODIFIER = TypeName.create(AccessModifier.class);

    private ContentSupport() {
    }

    static void addCreateElement(ContentBuilder<?> contentBuilder, TypedElementInfo element) {
        contentBuilder.addContent(ELEMENT).addContentLine(".builder()").increaseContentPadding().increaseContentPadding();
        contentBuilder.addContent(".kind(").addContent(ELEMENT_KIND).addContent(".").addContent(element.kind().name()).addContentLine(")");
        contentBuilder.addContent(".typeName(").addContentCreate(element.typeName()).addContentLine(")");
        if (element.kind() != ElementKind.CONSTRUCTOR) {
            contentBuilder.addContent(".elementName(\"").addContent(element.elementName()).addContentLine("\")");
        }
        for (Annotation annotation : element.annotations()) {
            contentBuilder.addContent(".addAnnotation(").addContentCreate(annotation).addContentLine(")");
        }
        for (Annotation annotation : element.inheritedAnnotations()) {
            contentBuilder.addContent(".addInheritedAnnotation(").addContentCreate(annotation).addContentLine(")");
        }
        AccessModifier accessModifier = element.accessModifier();
        if (accessModifier != AccessModifier.PACKAGE_PRIVATE) {
            contentBuilder.addContent(".accessModifier(").addContent(ACCESS_MODIFIER).addContent(".").addContent(accessModifier.name()).addContentLine(")");
        }
        Set modifiers = element.elementModifiers();
        for (Modifier modifier : modifiers) {
            contentBuilder.addContent(".addElementModifier(").addContent(MODIFIER).addContent(".").addContent(modifier.name()).addContentLine(")");
        }
        for (TypedElementInfo parameterArgument : element.parameterArguments()) {
            contentBuilder.addContent(".addParameterArgument(").addContentCreate(parameterArgument).addContentLine(")");
        }
        contentBuilder.addContentLine(".build()").decreaseContentPadding().decreaseContentPadding();
    }

    static void addCreateAnnotation(ContentBuilder<?> contentBuilder, Annotation annotation) {
        Map values = annotation.values();
        if (values.isEmpty() && annotation.metaAnnotations().isEmpty()) {
            contentBuilder.addContent(ANNOTATION).addContent(".create(").addContentCreate(annotation.typeName()).addContent(")");
            return;
        }
        contentBuilder.addContent(ANNOTATION).addContentLine(".builder()").increaseContentPadding().increaseContentPadding().addContent(".typeName(").addContentCreate(annotation.typeName()).addContentLine(")");
        annotation.values().keySet().forEach(propertyName -> {
            contentBuilder.addContent(".putValue(\"").addContent((String)propertyName).addContent("\", ");
            ContentSupport.addAnnotationValue(contentBuilder, annotation.objectValue(propertyName).get());
            contentBuilder.addContentLine(")");
        });
        annotation.metaAnnotations().forEach(it -> contentBuilder.addContent(".addMetaAnnotation(").increaseContentPadding().increaseContentPadding().addContentCreate((Annotation)it).addContentLine(")").decreaseContentPadding().decreaseContentPadding());
        contentBuilder.addContentLine(".build()").decreaseContentPadding().decreaseContentPadding();
    }

    static void addCreateTypeName(ContentBuilder<?> builder, TypeName typeName) {
        builder.addContent(TypeNames.TYPE_NAME).addContent(".create(\"").addContent(typeName.resolvedName()).addContent("\")");
    }

    private static void addAnnotationValue(ContentBuilder<?> contentBuilder, Object objectValue) {
        Object object = objectValue;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Boolean.class, Long.class, Double.class, Integer.class, Byte.class, Character.class, Short.class, Float.class, Class.class, TypeName.class, Annotation.class, Enum.class, EnumValue.class, List.class}, (Object)object2, n)) {
            case 0: {
                String value = (String)object2;
                contentBuilder.addContent("\"" + value + "\"");
                break;
            }
            case 1: {
                Boolean value = (Boolean)object2;
                contentBuilder.addContent(String.valueOf(value));
                break;
            }
            case 2: {
                Long value = (Long)object2;
                contentBuilder.addContent(String.valueOf(value) + "L");
                break;
            }
            case 3: {
                Double value = (Double)object2;
                contentBuilder.addContent(String.valueOf(value) + "D");
                break;
            }
            case 4: {
                Integer value = (Integer)object2;
                contentBuilder.addContent(String.valueOf(value));
                break;
            }
            case 5: {
                Byte value = (Byte)object2;
                contentBuilder.addContent("(byte)" + value);
                break;
            }
            case 6: {
                Character value = (Character)object2;
                contentBuilder.addContent("'" + value + "'");
                break;
            }
            case 7: {
                Short value = (Short)object2;
                contentBuilder.addContent("(short)" + value);
                break;
            }
            case 8: {
                Float value = (Float)object2;
                contentBuilder.addContent(String.valueOf(value) + "F");
                break;
            }
            case 9: {
                Class value = (Class)object2;
                contentBuilder.addContentCreate(TypeName.create((Type)value));
                break;
            }
            case 10: {
                TypeName value = (TypeName)object2;
                contentBuilder.addContentCreate(value);
                break;
            }
            case 11: {
                Annotation value = (Annotation)object2;
                contentBuilder.addContentCreate(value);
                break;
            }
            case 12: {
                Enum value = (Enum)object2;
                ContentSupport.toEnumValue(contentBuilder, EnumValue.create((TypeName)TypeName.create(value.getDeclaringClass()), (String)value.name()));
                break;
            }
            case 13: {
                EnumValue value = (EnumValue)object2;
                ContentSupport.toEnumValue(contentBuilder, value);
                break;
            }
            case 14: {
                List values = (List)object2;
                ContentSupport.toListValues(contentBuilder, values);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected annotation value type " + objectValue.getClass().getName() + ": " + String.valueOf(objectValue));
            }
        }
    }

    private static void toListValues(ContentBuilder<?> contentBuilder, List<?> values) {
        contentBuilder.addContent(List.class).addContent(".of(");
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            Object value = values.get(i);
            ContentSupport.addAnnotationValue(contentBuilder, value);
            if (i == size - 1) continue;
            contentBuilder.addContent(",");
        }
        contentBuilder.addContent(")");
    }

    private static void toEnumValue(ContentBuilder<?> contentBuilder, EnumValue enumValue) {
        contentBuilder.addContent(EnumValue.class).addContent(".create(").addContentCreate(enumValue.type()).addContent(",").addContent("\"").addContent(enumValue.name()).addContent("\")");
    }
}

