/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.AnnotatedComponent;
import io.helidon.codegen.classmodel.Annotation;
import io.helidon.codegen.classmodel.ClassType;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.ImportOrganizer;
import io.helidon.codegen.classmodel.InnerClass;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.ModelWriter;
import io.helidon.codegen.classmodel.Type;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ClassBase
extends AnnotatedComponent {
    private final boolean isFinal;
    private final boolean isAbstract;
    private final boolean isStatic;
    private final List<Field> fields;
    private final List<Field> staticFields;
    private final List<Method> methods;
    private final List<Method> staticMethods;
    private final Set<Type> interfaces;
    private final Set<String> tokenNames;
    private final List<Constructor> constructors;
    private final List<TypeArgument> genericParameters;
    private final List<InnerClass> innerClasses;
    private final ClassType classType;
    private final Type superType;

    ClassBase(Builder<?, ?> builder) {
        super((AnnotatedComponent.Builder<?, ?>)builder);
        this.isFinal = builder.isFinal;
        this.isAbstract = builder.isAbstract;
        this.isStatic = builder.isStatic;
        this.fields = builder.sortFields ? builder.fields.values().stream().sorted(ClassBase::fieldComparator).toList() : List.copyOf(builder.fields.values());
        this.staticFields = builder.sortStaticFields ? builder.staticFields.values().stream().sorted(ClassBase::fieldComparator).toList() : List.copyOf(builder.staticFields.values());
        this.methods = builder.methods.stream().sorted(ClassBase::methodCompare).toList();
        this.staticMethods = builder.staticMethods.stream().sorted(ClassBase::methodCompare).toList();
        this.constructors = List.copyOf(builder.constructors);
        this.interfaces = Collections.unmodifiableSet(new LinkedHashSet<Type>(builder.interfaces));
        this.innerClasses = List.copyOf(builder.innerClasses.values());
        this.genericParameters = List.copyOf(builder.genericParameters);
        this.tokenNames = this.genericParameters.stream().map(TypeArgument::token).collect(Collectors.toSet());
        this.classType = builder.classType;
        this.superType = builder.superType;
    }

    private static int methodCompare(Method method1, Method method2) {
        if (method1.accessModifier() == method2.accessModifier()) {
            return 0;
        }
        return method1.accessModifier().compareTo((Enum)method2.accessModifier());
    }

    private static int fieldComparator(Field field1, Field field2) {
        if (field1.accessModifier() == field2.accessModifier()) {
            if (field1.isFinal() == field2.isFinal()) {
                if (field1.type().simpleTypeName().equals(field2.type().simpleTypeName())) {
                    if (field1.type().resolvedTypeName().equals(field2.type().resolvedTypeName())) {
                        return field1.name().compareTo(field2.name());
                    }
                    return field1.type().resolvedTypeName().compareTo(field2.type().resolvedTypeName());
                }
                if (field1.type().simpleTypeName().equalsIgnoreCase(field2.type().simpleTypeName())) {
                    return field1.type().simpleTypeName().compareTo(field2.type().simpleTypeName());
                }
                return field1.type().simpleTypeName().compareToIgnoreCase(field2.type().simpleTypeName());
            }
            return Boolean.compare(field2.isFinal(), field1.isFinal());
        }
        return field1.accessModifier().compareTo((Enum)field2.accessModifier());
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ClassType classType) throws IOException {
        Set<String> combinedTokens = Stream.concat(declaredTokens.stream(), this.tokenNames.stream()).collect(Collectors.toSet());
        if (this.javadoc().generate()) {
            this.javadoc().writeComponent(writer, combinedTokens, imports, this.classType);
            writer.write("\n");
        }
        if (!this.annotations().isEmpty()) {
            for (Annotation annotation : this.annotations()) {
                annotation.writeComponent(writer, combinedTokens, imports, this.classType);
                writer.write("\n");
            }
        }
        if (AccessModifier.PACKAGE_PRIVATE != this.accessModifier()) {
            writer.write(this.accessModifier().modifierName() + " ");
        }
        if (this.isStatic) {
            writer.write("static ");
        }
        if (this.isFinal) {
            writer.write("final ");
        }
        if (this.isAbstract) {
            if (this.isFinal) {
                throw new IllegalStateException("Class cannot be abstract and final");
            }
            writer.write("abstract ");
        }
        writer.write(this.classType.typeName() + " " + this.name());
        if (!this.genericParameters.isEmpty()) {
            this.writeGenericParameters(writer, combinedTokens, imports);
        }
        writer.write(" ");
        if (this.superType != null) {
            writer.write("extends ");
            this.superType.writeComponent(writer, combinedTokens, imports, this.classType);
            writer.write(" ");
        }
        if (!this.interfaces.isEmpty()) {
            this.writeClassInterfaces(writer, combinedTokens, imports);
        }
        writer.write("{");
        writer.writeSeparatorLine();
        if (!this.staticFields.isEmpty()) {
            this.writeClassFields(this.staticFields, writer, combinedTokens, imports);
        }
        if (!this.fields.isEmpty()) {
            this.writeClassFields(this.fields, writer, combinedTokens, imports);
        }
        if (!this.constructors.isEmpty()) {
            this.writerClassConstructors(writer, combinedTokens, imports);
        }
        if (!this.staticMethods.isEmpty()) {
            this.writerClassMethods(this.staticMethods, writer, combinedTokens, imports);
        }
        if (!this.methods.isEmpty()) {
            this.writerClassMethods(this.methods, writer, combinedTokens, imports);
        }
        if (!this.innerClasses.isEmpty()) {
            this.writeInnerClasses(writer, combinedTokens, imports);
        }
        writer.write("\n");
        writer.write("}");
    }

    private void writeGenericParameters(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports) throws IOException {
        writer.write("<");
        boolean first = true;
        for (Type type : this.genericParameters) {
            if (first) {
                first = false;
            } else {
                writer.write(", ");
            }
            type.writeComponent(writer, declaredTokens, imports, this.classType);
        }
        writer.write(">");
    }

    private void writeClassInterfaces(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports) throws IOException {
        if (this.classType == ClassType.INTERFACE) {
            writer.write("extends ");
        } else {
            writer.write("implements ");
        }
        boolean first = true;
        for (Type interfaceName : this.interfaces) {
            if (first) {
                first = false;
            } else {
                writer.write(", ");
            }
            interfaceName.writeComponent(writer, declaredTokens, imports, this.classType);
        }
        writer.write(" ");
    }

    private void writeClassFields(Collection<Field> fields, ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports) throws IOException {
        writer.increasePaddingLevel();
        for (Field field : fields) {
            writer.write("\n");
            field.writeComponent(writer, declaredTokens, imports, this.classType);
        }
        writer.decreasePaddingLevel();
        writer.writeSeparatorLine();
    }

    private void writerClassConstructors(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports) throws IOException {
        writer.increasePaddingLevel();
        for (Constructor constructor : this.constructors) {
            writer.write("\n");
            constructor.writeComponent(writer, declaredTokens, imports, this.classType);
            writer.writeSeparatorLine();
        }
        writer.decreasePaddingLevel();
    }

    private void writerClassMethods(List<Method> methods, ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports) throws IOException {
        writer.increasePaddingLevel();
        for (Method method : methods) {
            writer.write("\n");
            method.writeComponent(writer, declaredTokens, imports, this.classType);
            writer.writeSeparatorLine();
        }
        writer.decreasePaddingLevel();
    }

    private void writeInnerClasses(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports) throws IOException {
        writer.increasePaddingLevel();
        for (InnerClass innerClass : this.innerClasses) {
            writer.write("\n");
            innerClass.writeComponent(writer, declaredTokens, imports, this.classType);
            writer.writeSeparatorLine();
        }
        writer.decreasePaddingLevel();
    }

    @Override
    void addImports(ImportOrganizer.Builder imports) {
        super.addImports(imports);
        this.fields.forEach(field -> field.addImports(imports));
        this.staticFields.forEach(field -> field.addImports(imports));
        this.methods.forEach(method -> method.addImports(imports));
        this.staticMethods.forEach(method -> method.addImports(imports));
        this.interfaces.forEach(imp -> imp.addImports(imports));
        this.constructors.forEach(constructor -> constructor.addImports(imports));
        this.genericParameters.forEach(param -> param.addImports(imports));
        this.innerClasses.forEach(innerClass -> {
            imports.from(innerClass.imports());
            innerClass.addImports(imports);
        });
        if (this.superType != null) {
            this.superType.addImports(imports);
        }
    }

    ClassType classType() {
        return this.classType;
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends ClassBase>
    extends AnnotatedComponent.Builder<B, T> {
        private final Set<Method> methods = new LinkedHashSet<Method>();
        private final Set<Method> staticMethods = new LinkedHashSet<Method>();
        private final Set<Type> interfaces = new LinkedHashSet<Type>();
        private final Map<String, Field> fields = new LinkedHashMap<String, Field>();
        private final Map<String, Field> staticFields = new LinkedHashMap<String, Field>();
        private final Map<String, InnerClass> innerClasses = new LinkedHashMap<String, InnerClass>();
        private final List<Constructor> constructors = new ArrayList<Constructor>();
        private final List<TypeArgument> genericParameters = new ArrayList<TypeArgument>();
        private final ImportOrganizer.Builder importOrganizer = ImportOrganizer.builder();
        private ClassType classType = ClassType.CLASS;
        private Type superType;
        private boolean isFinal;
        private boolean isAbstract;
        private boolean isStatic;
        private boolean sortFields = true;
        private boolean sortStaticFields = true;

        Builder() {
        }

        @Override
        public B javadoc(Javadoc javadoc) {
            return (B)((Builder)super.javadoc(javadoc));
        }

        @Override
        public B addJavadocTag(String tag, String description) {
            return (B)((Builder)super.addJavadocTag(tag, description));
        }

        @Override
        public B accessModifier(AccessModifier accessModifier) {
            return (B)((Builder)super.accessModifier(accessModifier));
        }

        public B isFinal(boolean isFinal) {
            this.isFinal = isFinal;
            return (B)((Builder)this.identity());
        }

        public B isAbstract(boolean isAbstract) {
            this.isAbstract = isAbstract;
            return (B)((Builder)this.identity());
        }

        public B superType(Class<?> superType) {
            return this.superType(TypeName.create(superType));
        }

        public B superType(String superType) {
            return this.superType(TypeName.create((String)superType));
        }

        public B superType(TypeName superType) {
            this.superType = Type.fromTypeName(superType);
            return (B)((Builder)this.identity());
        }

        public B addField(Consumer<Field.Builder> consumer) {
            Field.Builder builder = Field.builder();
            consumer.accept(builder);
            return this.addField(builder.build());
        }

        public B addField(Field.Builder builder) {
            return this.addField(builder.build());
        }

        public B addField(Field field) {
            String fieldName = field.name();
            if (field.isStatic()) {
                this.fields.remove(fieldName);
                this.staticFields.put(fieldName, field);
            } else {
                this.staticFields.remove(fieldName);
                this.fields.put(fieldName, field);
            }
            return (B)((Builder)this.identity());
        }

        public B addMethod(Consumer<Method.Builder> consumer) {
            Method.Builder methodBuilder = Method.builder();
            consumer.accept(methodBuilder);
            return this.addMethod(methodBuilder);
        }

        public B addMethod(Method.Builder builder) {
            return this.addMethod(builder.build());
        }

        public B addMethod(Method method) {
            this.methods.remove(method);
            this.staticMethods.remove(method);
            if (method.isStatic()) {
                this.staticMethods.add(method);
            } else {
                this.methods.add(method);
            }
            return (B)((Builder)this.identity());
        }

        public B addInterface(Class<?> interfaceType) {
            if (interfaceType.isInterface()) {
                return this.addInterface(TypeName.create(interfaceType));
            }
            throw new IllegalArgumentException("Provided value needs to be interface, but it was not: " + interfaceType.getName());
        }

        public B addInterface(String interfaceName) {
            return this.addInterface(TypeName.create((String)interfaceName));
        }

        public B addInterface(TypeName interfaceType) {
            this.interfaces.add(Type.fromTypeName(interfaceType));
            return (B)((Builder)this.identity());
        }

        public B addInnerClass(Consumer<InnerClass.Builder> consumer) {
            InnerClass.Builder innerClassBuilder = InnerClass.builder();
            consumer.accept(innerClassBuilder);
            return this.addInnerClass((Supplier<InnerClass>)((Object)innerClassBuilder));
        }

        public B addInnerClass(Supplier<InnerClass> supplier) {
            return this.addInnerClass(supplier.get());
        }

        public B addInnerClass(InnerClass innerClass) {
            this.innerClasses.put(innerClass.name(), innerClass);
            return (B)((Builder)this.identity());
        }

        public B addConstructor(Constructor.Builder constructor) {
            this.constructors.add(((Constructor.Builder)constructor.type(this.name())).build());
            return (B)((Builder)this.identity());
        }

        public B addConstructor(Consumer<Constructor.Builder> consumer) {
            Constructor.Builder constructorBuilder = (Constructor.Builder)Constructor.builder().type(this.name());
            consumer.accept(constructorBuilder);
            this.constructors.add(constructorBuilder.build());
            return (B)((Builder)this.identity());
        }

        public B addGenericArgument(TypeArgument typeArgument) {
            this.genericParameters.add(typeArgument);
            return (B)((Builder)this.addGenericToken(typeArgument.token(), typeArgument.description()));
        }

        public B addGenericArgument(Consumer<TypeArgument.Builder> consumer) {
            TypeArgument.Builder tokenBuilder = TypeArgument.builder();
            consumer.accept(tokenBuilder);
            return this.addGenericArgument(tokenBuilder.build());
        }

        public B addImport(Class<?> typeImport) {
            this.importOrganizer.addImport(typeImport);
            return (B)((Builder)this.identity());
        }

        public B addImport(String importName) {
            this.importOrganizer.addImport(importName);
            return (B)((Builder)this.identity());
        }

        public B addImport(TypeName typeName) {
            this.importOrganizer.addImport(typeName);
            return (B)((Builder)this.identity());
        }

        public B addStaticImport(String staticImport) {
            this.importOrganizer.addStaticImport(staticImport);
            return (B)((Builder)this.identity());
        }

        public B classType(ClassType classType) {
            this.classType = classType;
            return (B)((Builder)this.identity());
        }

        public B classType(ElementKind kind) {
            return (B)(switch (kind) {
                case ElementKind.CLASS -> (Builder)this.classType(ClassType.CLASS);
                case ElementKind.INTERFACE -> (Builder)this.classType(ClassType.INTERFACE);
                default -> throw new IllegalArgumentException("Top level class is not supported for kind: " + String.valueOf(kind));
            });
        }

        public B sortFields(boolean sort) {
            this.sortFields = sort;
            return (B)((Builder)this.identity());
        }

        public B sortStaticFields(boolean sort) {
            this.sortStaticFields = sort;
            return (B)((Builder)this.identity());
        }

        B isStatic(boolean isStatic) {
            this.isStatic = isStatic;
            return (B)((Builder)this.identity());
        }

        ImportOrganizer.Builder importOrganizer() {
            return this.importOrganizer;
        }
    }
}

