/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import io.helidon.codegen.apt.AptTypeFactory;
import io.helidon.codegen.apt.ToAnnotationValueVisitor;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;

final class AptAnnotationFactory {
    private AptAnnotationFactory() {
    }

    public static Annotation createAnnotation(AnnotationMirror am, Elements elements) {
        TypeName val = AptTypeFactory.createTypeName(am.getAnnotationType()).orElseThrow(() -> new IllegalArgumentException("Cannot create annotation for non-existent type: " + String.valueOf(am.getAnnotationType())));
        HashSet<TypeName> set = new HashSet<TypeName>();
        set.add(TypeNames.INHERITED);
        set.add(TypeNames.TARGET);
        set.add(TypeNames.RETENTION);
        set.add(TypeNames.DOCUMENTED);
        set.remove(val);
        return AptAnnotationFactory.createAnnotation(elements, am, set).orElseThrow();
    }

    private static Optional<Annotation> createAnnotation(Elements elements, AnnotationMirror am, Set<TypeName> processedTypes) {
        TypeName val = AptTypeFactory.createTypeName(am.getAnnotationType()).orElseThrow(() -> new IllegalArgumentException("Cannot create annotation for non-existent type: " + String.valueOf(am.getAnnotationType())));
        if (processedTypes.contains(val)) {
            return Optional.empty();
        }
        Annotation.Builder builder = Annotation.builder();
        elements.getAllAnnotationMirrors(am.getAnnotationType().asElement()).stream().map(it -> {
            HashSet<TypeName> newProcessed = new HashSet<TypeName>(processedTypes);
            newProcessed.add(val);
            return AptAnnotationFactory.createAnnotation(elements, it, newProcessed);
        }).flatMap(Optional::stream).forEach(arg_0 -> ((Annotation.Builder)builder).addMetaAnnotation(arg_0));
        return Optional.of(((Annotation.Builder)((Annotation.Builder)builder.typeName(val)).values(AptAnnotationFactory.extractAnnotationValues(am, elements))).build());
    }

    private static Map<String, Object> extractAnnotationValues(AnnotationMirror am, Elements elements) {
        return AptAnnotationFactory.extractAnnotationValues(elements, elements.getElementValuesWithDefaults(am));
    }

    private static Map<String, Object> extractAnnotationValues(Elements elements, Map<? extends ExecutableElement, ? extends AnnotationValue> values) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        values.forEach((el, val) -> {
            String name = el.getSimpleName().toString();
            Object value = val.accept(new ToAnnotationValueVisitor(elements), null);
            if (value != null) {
                result.put(name, value);
            }
        });
        return result;
    }
}

