/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import io.helidon.codegen.CodegenContextBase;
import io.helidon.codegen.CodegenFiler;
import io.helidon.codegen.CodegenLogger;
import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.CodegenScope;
import io.helidon.codegen.ModuleInfo;
import io.helidon.codegen.ModuleInfoSourceParser;
import io.helidon.codegen.Option;
import io.helidon.codegen.apt.AptContext;
import io.helidon.codegen.apt.AptFiler;
import io.helidon.codegen.apt.AptLogger;
import io.helidon.codegen.apt.AptOptions;
import io.helidon.codegen.apt.AptTypeInfoFactory;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

class AptContextImpl
extends CodegenContextBase
implements AptContext {
    private static final Pattern SCOPE_PATTERN = Pattern.compile("(\\w+).*classes");
    private final ProcessingEnvironment env;
    private final ModuleInfo moduleInfo;
    private final Map<TypeName, Optional<TypeInfo>> safeTypeCache = new HashMap<TypeName, Optional<TypeInfo>>();
    private final Map<TypeName, Optional<TypeInfo>> typeCache = new HashMap<TypeName, Optional<TypeInfo>>();

    AptContextImpl(ProcessingEnvironment env, CodegenOptions options, Set<Option<?>> supportedOptions, AptFiler aptFiler, AptLogger aptLogger, CodegenScope scope, ModuleInfo moduleInfo) {
        super(options, supportedOptions, (CodegenFiler)aptFiler, (CodegenLogger)aptLogger, scope);
        this.env = env;
        this.moduleInfo = moduleInfo;
    }

    static AptContextImpl create(ProcessingEnvironment env, Set<Option<?>> supportedOptions) {
        CodegenOptions options = AptOptions.create(env);
        CodegenScope scope = AptContextImpl.guessScope(env, options);
        Optional<ModuleInfo> module = AptContextImpl.findModule(env.getFiler());
        return new AptContextImpl(env, options, supportedOptions, new AptFiler(env, options), new AptLogger(env, options), scope, module.orElse(null));
    }

    @Override
    public ProcessingEnvironment aptEnv() {
        return this.env;
    }

    public Optional<TypeInfo> typeInfo(TypeName typeName) {
        if (this.typeCache.containsKey(typeName)) {
            return this.typeCache.get(typeName);
        }
        return AptTypeInfoFactory.create((AptContext)this, typeName);
    }

    public Optional<TypeInfo> typeInfo(TypeName typeName, Predicate<TypedElementInfo> elementPredicate) {
        return AptTypeInfoFactory.create((AptContext)this, typeName, elementPredicate);
    }

    public Optional<ModuleInfo> module() {
        return Optional.ofNullable(this.moduleInfo);
    }

    @Override
    public Optional<TypeInfo> cache(TypeName typeName, Supplier<Optional<TypeInfo>> typeInfoSupplier) {
        if (typeName.generic() || !typeName.typeArguments().isEmpty() || !typeName.typeParameters().isEmpty()) {
            return typeInfoSupplier.get();
        }
        if (typeName.packageName().startsWith("java.") || typeName.packageName().startsWith("javax.") || typeName.packageName().startsWith("sun.") || typeName.packageName().startsWith("com.sun")) {
            Optional<TypeInfo> typeInfo = this.safeTypeCache.get(typeName);
            if (typeInfo != null) {
                return typeInfo;
            }
            typeInfo = typeInfoSupplier.get();
            this.safeTypeCache.put(typeName, typeInfo);
            return typeInfo;
        }
        Optional<TypeInfo> typeInfo = this.typeCache.get(typeName);
        if (typeInfo != null) {
            return typeInfo;
        }
        typeInfo = typeInfoSupplier.get();
        this.typeCache.put(typeName, typeInfo);
        return typeInfo;
    }

    void resetCache() {
        this.typeCache.clear();
    }

    private static Optional<ModuleInfo> findModule(Filer filer) {
        Optional<ModuleInfo> optional;
        block16: {
            FileObject resource2 = filer.getResource(StandardLocation.SOURCE_PATH, "", "module-info.java");
            InputStream in = resource2.openInputStream();
            try {
                optional = Optional.of(ModuleInfoSourceParser.parse((InputStream)in));
                if (in == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception resource2) {
                    Optional<ModuleInfo> optional2;
                    block17: {
                        FileObject resource3 = filer.getResource(StandardLocation.SOURCE_OUTPUT, "", "module-info.java");
                        in = resource3.openInputStream();
                        try {
                            optional2 = Optional.of(ModuleInfoSourceParser.parse((InputStream)in));
                            if (in == null) break block17;
                        }
                        catch (Throwable throwable3) {
                            try {
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                }
                                throw throwable3;
                            }
                            catch (IOException iOException) {
                                return Optional.empty();
                            }
                        }
                        in.close();
                    }
                    return optional2;
                }
            }
            in.close();
        }
        return optional;
    }

    private static CodegenScope guessScope(ProcessingEnvironment env, CodegenOptions options) {
        CodegenScope scopeFromOptions = CodegenOptions.CODEGEN_SCOPE.findValue(options).orElse(null);
        if (scopeFromOptions != null) {
            return scopeFromOptions;
        }
        try {
            URI resourceUri = env.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "does.not.exist", "DefinitelyDoesNotExist").toUri();
            String resourceUriString = resourceUri.toString();
            if (!resourceUriString.endsWith("/does/not/exist/DefinitelyDoesNotExist")) {
                return CodegenScope.PRODUCTION;
            }
            int lastSlash = (resourceUriString = resourceUriString.substring(0, resourceUriString.length() - "/does/not/exist/DefinitelyDoesNotExist".length())).lastIndexOf(47);
            if (lastSlash < 0) {
                return CodegenScope.PRODUCTION;
            }
            Matcher matcher = SCOPE_PATTERN.matcher(resourceUriString = resourceUriString.substring(lastSlash + 1));
            if (matcher.matches()) {
                return new CodegenScope(matcher.group(1));
            }
            return CodegenScope.PRODUCTION;
        }
        catch (IOException e) {
            return CodegenScope.PRODUCTION;
        }
    }
}

