/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.FilerResource;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

class FilerResourceImpl
implements FilerResource {
    private final Filer filer;
    private final String location;
    private final Element[] originatingElements;
    private final FileObject originalResource;
    private byte[] currentBytes;
    private boolean modified;

    FilerResourceImpl(Filer filer, String location, Element[] originatingElements) {
        this.filer = filer;
        this.location = location;
        this.originatingElements = originatingElements;
        this.originalResource = null;
        this.currentBytes = new byte[0];
    }

    FilerResourceImpl(Filer filer, String location, Element[] originatingElements, FileObject originalResource, byte[] existingBytes) {
        this.filer = filer;
        this.location = location;
        this.originatingElements = originatingElements;
        this.originalResource = originalResource;
        this.currentBytes = existingBytes;
    }

    public byte[] bytes() {
        return Arrays.copyOf(this.currentBytes, this.currentBytes.length);
    }

    public void bytes(byte[] newBytes) {
        this.currentBytes = Arrays.copyOf(newBytes, newBytes.length);
        this.modified = true;
    }

    public void write() {
        if (this.modified) {
            if (this.originalResource != null) {
                this.originalResource.delete();
            }
            try {
                FileObject newResource = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", this.location, this.originatingElements);
                try (OutputStream os = newResource.openOutputStream();){
                    os.write(this.currentBytes);
                }
            }
            catch (Exception e) {
                throw new CodegenException("Failed to create resource: " + this.location, (Throwable)e);
            }
        }
    }
}

