/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.Types;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;

record AnnotationDataConfigured(boolean configured, String rootPrefix) {
    static AnnotationDataConfigured create(TypeInfo typeInfo) {
        Boolean configured = null;
        Boolean isRoot = null;
        String prefix = null;
        if (typeInfo.hasAnnotation(Types.PROTOTYPE_CONFIGURED_TYPE)) {
            configured = true;
            prefix = typeInfo.annotation(Types.PROTOTYPE_CONFIGURED_TYPE).stringValue().orElse(null);
            if (prefix != null) {
                isRoot = true;
            }
        }
        if (configured == null && typeInfo.hasAnnotation(Types.CONFIGURED_TYPE)) {
            configured = true;
            Annotation annotation = typeInfo.annotation(Types.CONFIGURED_TYPE);
            prefix = annotation.stringValue("prefix").orElse(null);
            isRoot = annotation.booleanValue("root").orElse(false);
        }
        if (isRoot == null) {
            isRoot = false;
        }
        if (prefix == null && isRoot.booleanValue()) {
            prefix = "";
        }
        if (!isRoot.booleanValue()) {
            prefix = null;
        }
        if (configured == null) {
            configured = false;
        }
        return new AnnotationDataConfigured(configured, prefix);
    }

    boolean isRoot() {
        return this.rootPrefix != null;
    }
}

