/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.MethodSignature;
import io.helidon.common.processor.ElementInfoPredicates;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

final class BuilderInfoPredicates {
    private BuilderInfoPredicates() {
    }

    static Predicate<? super TypedElementInfo> ignoredMethod(Set<MethodSignature> ignoredMethods, Set<String> ignoredNames) {
        return it -> {
            if (ignoredNames.contains(it.elementName())) {
                return true;
            }
            return ignoredMethods.contains(MethodSignature.create(it));
        };
    }

    static Optional<TypedElementInfo> findMethod(MethodSignature signatureFilter, Set<Modifier> expectedModifiers, TypeInfo typeInfo) {
        return typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(it -> {
            Set modifiers = it.elementModifiers();
            if (expectedModifiers != null) {
                for (Modifier expectedModifier : expectedModifiers) {
                    if (modifiers.contains(expectedModifier)) continue;
                    return false;
                }
            }
            return true;
        }).filter(it -> {
            if (signatureFilter.returnType() != null && !it.typeName().equals((Object)signatureFilter.returnType())) {
                return false;
            }
            if (signatureFilter.name() != null && !it.elementName().equals(signatureFilter.name())) {
                return false;
            }
            List<TypeName> expectedArguments = signatureFilter.arguments();
            if (expectedArguments != null) {
                List actualArguments = it.parameterArguments();
                if (actualArguments.size() != expectedArguments.size()) {
                    return false;
                }
                for (int i = 0; i < expectedArguments.size(); ++i) {
                    TypeName actualArgument;
                    TypeName expected = expectedArguments.get(i);
                    if (expected.equals((Object)(actualArgument = ((TypedElementInfo)actualArguments.get(i)).typeName()))) continue;
                    return false;
                }
            }
            return true;
        }).findFirst();
    }
}

