/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.common.processor.TypeInfoFactory;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

interface ProcessingContext {
    public static ProcessingContext create(ProcessingEnvironment processingEnv) {
        return new ProcessingContextProcessor(processingEnv);
    }

    public Optional<TypeInfo> toTypeInfo(TypeName var1);

    public Optional<String> javadoc(Element var1);

    public static class ProcessingContextProcessor
    implements ProcessingContext {
        private final ProcessingEnvironment processingEnv;

        ProcessingContextProcessor(ProcessingEnvironment processingEnv) {
            this.processingEnv = processingEnv;
        }

        @Override
        public Optional<String> javadoc(Element element) {
            Elements elementUtils = this.processingEnv.getElementUtils();
            String javadoc = elementUtils.getDocComment(element);
            return Optional.ofNullable(javadoc).filter(Predicate.not(String::isBlank));
        }

        @Override
        public Optional<TypeInfo> toTypeInfo(TypeName returnType) {
            TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(returnType.boxed().fqName());
            if (typeElement == null) {
                return Optional.empty();
            }
            return TypeInfoFactory.create((ProcessingEnvironment)this.processingEnv, (TypeElement)typeElement);
        }
    }
}

