/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.AnnotationDataOption;
import io.helidon.builder.processor.FactoryMethods;
import io.helidon.builder.processor.TypeHandler;
import io.helidon.builder.processor.Types;
import io.helidon.common.processor.GeneratorTools;
import io.helidon.common.processor.classmodel.Field;
import io.helidon.common.processor.classmodel.InnerClass;
import io.helidon.common.processor.classmodel.Javadoc;
import io.helidon.common.processor.classmodel.Method;
import io.helidon.common.processor.classmodel.Parameter;
import io.helidon.common.processor.classmodel.TypeArgument;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

class TypeHandlerMap
extends TypeHandler {
    private static final TypeName SAME_GENERIC_TYPE = TypeName.createFromGenericDeclaration((String)"TYPE");
    private final TypeName actualType;
    private final TypeName implTypeName;
    private final boolean sameGeneric;

    TypeHandlerMap(String name, String getterName, String setterName, TypeName declaredType, boolean sameGeneric) {
        super(name, getterName, setterName, declaredType);
        this.sameGeneric = sameGeneric;
        this.implTypeName = TypeHandlerMap.collectionImplType(TypeNames.MAP);
        this.actualType = declaredType.typeArguments().size() < 2 ? Types.STRING_TYPE : (TypeName)declaredType.typeArguments().get(1);
    }

    @Override
    Field.Builder fieldDeclaration(AnnotationDataOption configured, boolean isBuilder, boolean alwaysFinal) {
        Field.Builder builder = super.fieldDeclaration(configured, isBuilder, true);
        if (isBuilder && !configured.hasDefault()) {
            builder.defaultValue("new @" + this.implTypeName.fqName() + "@<>()");
        }
        return builder;
    }

    @Override
    String toDefaultValue(List<String> defaultValues, List<Integer> defaultInts, List<Long> defaultLongs, List<Double> defaultDoubles, List<Boolean> defaultBooleans) {
        if (defaultValues != null) {
            if (defaultValues.size() % 2 != 0) {
                throw new IllegalArgumentException("Default value for a map does not have even number of entries:" + String.valueOf(defaultValues));
            }
            CharSequence[] defaults = new String[defaultValues.size()];
            for (int i = 1; i < defaultValues.size(); i += 2) {
                defaults[i - 1] = "\"" + defaultValues.get(i - 1) + "\"";
                defaults[i] = super.toDefaultValue(defaultValues.get(i));
            }
            return "java.util.Map.of(" + String.join((CharSequence)", ", defaults) + ")";
        }
        return null;
    }

    @Override
    TypeName actualType() {
        return this.actualType;
    }

    @Override
    void generateFromConfig(Method.Builder method, AnnotationDataOption configured, FactoryMethods factoryMethods) {
        method.addLine(this.configGet(configured) + ".asNodeList().ifPresent(nodes -> nodes.forEach(node -> " + this.name() + ".put(node.get(\"name\").asString().orElse(node.name()), node" + this.generateFromConfig(factoryMethods) + ".get())));");
    }

    @Override
    TypeName argumentTypeName() {
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)TypeNames.MAP).addTypeArgument(TypeHandlerMap.toWildcard((TypeName)this.declaredType().typeArguments().get(0)))).addTypeArgument(TypeHandlerMap.toWildcard((TypeName)this.declaredType().typeArguments().get(1)))).build();
    }

    @Override
    void setters(InnerClass.Builder classBuilder, AnnotationDataOption configured, FactoryMethods factoryMethod, TypeName returnType, Javadoc blueprintJavadoc) {
        String singularName;
        this.declaredSetter(classBuilder, configured, returnType, blueprintJavadoc);
        this.declaredSetterAdd(classBuilder, configured, returnType, blueprintJavadoc);
        if (factoryMethod.createTargetType().isPresent()) {
            FactoryMethods.FactoryMethod fm = factoryMethod.createTargetType().get();
            String name = this.name();
            String argumentName = name + "Config";
            classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(name + "Config")).description(blueprintJavadoc.content())).accessModifier(TypeHandlerMap.setterAccessModifier(configured))).addDescriptionLine("This method keeps existing values, then puts all new values into the map.")).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(fm.argumentType()).description(blueprintJavadoc.returnDescription()))).addJavadocTag("see", "#" + this.getterName() + "()")).returnType(returnType, "updated builder instance").typeName(Objects.class)).addLine(".requireNonNull(" + argumentName + ");")).addLine("this." + name + ".clear();")).add("this." + name + ".putAll(")).typeName(fm.typeWithFactoryMethod().genericTypeName())).addLine("." + fm.createMethodName() + "(" + argumentName + "));")).addLine("return self();"));
        }
        TypeName keyType = (TypeName)this.declaredType().typeArguments().get(0);
        if (configured.singular() && this.isCollection(this.actualType())) {
            singularName = configured.singularName();
            this.setterAddValueToCollection(classBuilder, configured, singularName, keyType, (TypeName)this.actualType().typeArguments().get(0), returnType, blueprintJavadoc);
            this.setterAddValuesToCollection(classBuilder, configured, "add" + GeneratorTools.capitalize((String)this.name()), keyType, returnType, blueprintJavadoc);
        }
        if (configured.singular()) {
            singularName = configured.singularName();
            String methodName = "put" + GeneratorTools.capitalize((String)singularName);
            Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(methodName)).accessModifier(TypeHandlerMap.setterAccessModifier(configured))).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addDescriptionLine("This method adds a new value to the map, or replaces it if the key already exists.")).addJavadocTag("see", "#" + this.getterName() + "()");
            if (this.sameGeneric) {
                this.sameGenericArgs(method, keyType, singularName, this.actualType());
            } else {
                ((Method.Builder)method.addParameter(param -> ((Parameter.Builder)param.name("key")).type(keyType).description("key to add or replace"))).addParameter(param -> ((Parameter.Builder)param.name(singularName)).type(this.actualType()).description("new value for the key"));
            }
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.typeName(Objects.class)).addLine(".requireNonNull(key);")).typeName(Objects.class)).addLine(".requireNonNull(" + singularName + ");")).add("this." + this.name() + ".put(key, ");
            this.secondArgToPut(method, this.actualType(), singularName);
            ((Method.Builder)method.addLine(");")).addLine("return self();");
            classBuilder.addMethod(method);
            if (factoryMethod.builder().isPresent()) {
                FactoryMethods.FactoryMethod fm = factoryMethod.builder().get();
                TypeName builderType = fm.factoryMethodReturnType().className().equals("Builder") ? fm.factoryMethodReturnType() : TypeName.create((String)(fm.factoryMethodReturnType().fqName() + ".Builder"));
                classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(methodName)).accessModifier(TypeHandlerMap.setterAccessModifier(configured))).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addDescriptionLine("This method adds a new value to the map, or replaces it if the key already exists.")).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name("key")).type(keyType).description("key to add or replace"))).addParameter(param -> ((Parameter.Builder)param.name("consumer")).type(((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(builderType)).build()).description("builder consumer to create new value for the key"))).typeName(Objects.class)).addLine(".requireNonNull(key);")).typeName(Objects.class)).addLine(".requireNonNull(consumer);")).add("var builder = ")).typeName(fm.typeWithFactoryMethod().genericTypeName())).addLine("." + fm.createMethodName() + "();")).addLine("consumer.accept(builder);")).addLine("this." + methodName + "(key, builder.build());")).addLine("return self();"));
            }
        }
    }

    @Override
    protected void declaredSetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(this.setterName())).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addDescriptionLine("This method replaces all values with the new ones.")).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(this.argumentTypeName()).description(blueprintJavadoc.returnDescription()))).accessModifier(TypeHandlerMap.setterAccessModifier(configured))).typeName(Objects.class)).addLine(".requireNonNull(" + this.name() + ");")).addLine("this." + this.name() + ".clear();")).addLine("this." + this.name() + ".putAll(" + this.name() + ");")).addLine("return self();"));
    }

    private void sameGenericArgs(Method.Builder method, TypeName keyType, String value, TypeName valueType) {
        TypeName resolvedValueType;
        TypeName resolvedKeyType;
        TypeName genericTypeBase;
        if (keyType.typeArguments().isEmpty()) {
            genericTypeBase = keyType;
            resolvedKeyType = SAME_GENERIC_TYPE;
        } else if (keyType.typeArguments().size() == 1) {
            TypeName typeArg = (TypeName)keyType.typeArguments().get(0);
            genericTypeBase = typeArg.wildcard() ? (typeArg.generic() ? TypeNames.OBJECT : ((TypeName.Builder)TypeName.builder((TypeName)typeArg).wildcard(false)).build()) : typeArg;
            resolvedKeyType = ((TypeName.Builder)TypeName.builder((TypeName)keyType).typeArguments(List.of(SAME_GENERIC_TYPE))).build();
        } else {
            throw new IllegalArgumentException("Property " + this.name() + " with type " + this.declaredType().fqName() + " is annotated with @SameGeneric, yet the key generic type cannot be determined. Either the key must be a simple type, or a type with one type argument.");
        }
        method.addGenericArgument(TypeArgument.builder().token("TYPE").bound(genericTypeBase).description("Type to correctly map key and value").build());
        if (valueType.typeArguments().isEmpty()) {
            if (!genericTypeBase.equals((Object)valueType)) {
                throw new IllegalArgumentException("Property " + this.name() + " with type " + this.declaredType().fqName() + " is annotated with @SameGeneric, yet the type of value is not the same as type found on key: " + genericTypeBase.fqName());
            }
            resolvedValueType = SAME_GENERIC_TYPE;
        } else if (valueType.typeArguments().size() == 1) {
            if (!genericTypeBase.equals(valueType.typeArguments().get(0))) {
                throw new IllegalArgumentException("Property " + this.name() + " with type " + this.declaredType().fqName() + " is annotated with @SameGeneric, yet type of value is not the same as type found on key: " + genericTypeBase.fqName());
            }
            resolvedValueType = ((TypeName.Builder)TypeName.builder((TypeName)valueType).typeArguments(List.of(SAME_GENERIC_TYPE))).build();
        } else {
            throw new IllegalArgumentException("Property " + this.name() + " with type " + this.declaredType().fqName() + " is annotated with @SameGeneric, yet the value generic type cannot be determined. Either the value must be a simple type, or a type with one type argument.");
        }
        ((Method.Builder)method.addParameter(param -> ((Parameter.Builder)param.name("key")).type(resolvedKeyType).description("key to add or replace"))).addParameter(param -> ((Parameter.Builder)param.name(value)).type(resolvedValueType).description("new value for the key"));
    }

    private void setterAddValueToCollection(InnerClass.Builder classBuilder, AnnotationDataOption configured, String singularName, TypeName keyType, TypeName valueType, TypeName returnType, Javadoc blueprintJavadoc) {
        String methodName = "add" + GeneratorTools.capitalize((String)singularName);
        TypeName implType = TypeHandlerMap.collectionImplType(this.actualType());
        classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(methodName)).accessModifier(TypeHandlerMap.setterAccessModifier(configured))).addParameter(param -> ((Parameter.Builder)param.name("key")).type(keyType).description("key to add to"))).addParameter(param -> ((Parameter.Builder)param.name(singularName)).type(valueType).description("additional value for the key"))).description(blueprintJavadoc.content())).addDescriptionLine("This method adds a new value to the map value, or creates a new value.")).addJavadocTag("see", "#" + this.getterName() + "()")).returnType(returnType, "updated builder instance").typeName(Objects.class)).addLine(".requireNonNull(key);")).typeName(Objects.class)).addLine(".requireNonNull(" + singularName + ");")).addLine("this." + this.name() + ".compute(key, (k, v) -> {")).add("v = v == null ? new ")).typeName(implType)).add("<>() : new ")).typeName(implType)).addLine("<>(v);")).addLine("v.add(" + singularName + ");")).addLine("return v;")).decreasePadding()).addLine("});")).addLine("return self();"));
    }

    private void setterAddValuesToCollection(InnerClass.Builder classBuilder, AnnotationDataOption configured, String methodName, TypeName keyType, TypeName returnType, Javadoc blueprintJavadoc) {
        TypeName implType = TypeHandlerMap.collectionImplType(this.actualType());
        String name = this.name();
        classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(methodName)).accessModifier(TypeHandlerMap.setterAccessModifier(configured))).addParameter(param -> ((Parameter.Builder)param.name("key")).type(keyType).description("key to add to"))).addParameter(param -> ((Parameter.Builder)param.name(name)).type(this.actualType()).description("additional values for the key"))).description(blueprintJavadoc.content())).addDescriptionLine("This method adds a new value to the map value, or creates a new value.")).addJavadocTag("see", "#" + this.getterName() + "()")).returnType(returnType, "updated builder instance").typeName(Objects.class)).addLine(".requireNonNull(key);")).typeName(Objects.class)).addLine(".requireNonNull(" + name + ");")).addLine("this." + name + ".compute(key, (k, v) -> {")).add("v = v == null ? new ")).typeName(implType)).add("<>() : new ")).typeName(implType)).addLine("<>(v);")).addLine("v.addAll(" + name + ");")).addLine("return v;")).decreasePadding()).addLine("});")).addLine("return self();"));
    }

    private void declaredSetterAdd(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name("add" + GeneratorTools.capitalize((String)this.name()))).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addDescriptionLine("This method keeps existing values, then puts all new values into the map.")).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(this.argumentTypeName()).description(blueprintJavadoc.returnDescription()))).accessModifier(TypeHandlerMap.setterAccessModifier(configured))).typeName(Objects.class)).addLine(".requireNonNull(" + this.name() + ");")).addLine("this." + this.name() + ".putAll(" + this.name() + ");")).addLine("return self();"));
    }

    private void secondArgToPut(Method.Builder method, TypeName typeName, String singularName) {
        TypeName genericTypeName = typeName.genericTypeName();
        if (genericTypeName.equals((Object)TypeNames.LIST)) {
            ((Method.Builder)method.typeName(List.class)).add(".copyOf(" + singularName + ")");
        } else if (genericTypeName.equals((Object)TypeNames.SET)) {
            ((Method.Builder)method.typeName(Set.class)).add(".copyOf(" + singularName + ")");
        } else if (genericTypeName.equals((Object)TypeNames.MAP)) {
            ((Method.Builder)method.typeName(Map.class)).add(".copyOf(" + singularName + ")");
        } else {
            method.add(singularName);
        }
    }

    private boolean isCollection(TypeName typeName) {
        if (typeName.typeArguments().size() != 1) {
            return false;
        }
        TypeName genericTypeName = typeName.genericTypeName();
        if (genericTypeName.equals((Object)TypeNames.LIST)) {
            return true;
        }
        return genericTypeName.equals((Object)TypeNames.SET);
    }
}

