/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.GeneratedMethod;
import io.helidon.builder.codegen.OptionConfigured;
import io.helidon.builder.codegen.OptionInfo;
import io.helidon.builder.codegen.OptionMethodType;
import io.helidon.builder.codegen.PrototypeInfo;
import io.helidon.builder.codegen.TypeHandlerBasic;
import io.helidon.builder.codegen.TypeHandlerList;
import io.helidon.builder.codegen.TypeHandlerMap;
import io.helidon.builder.codegen.TypeHandlerOptional;
import io.helidon.builder.codegen.TypeHandlerSet;
import io.helidon.builder.codegen.TypeHandlerSupplier;
import io.helidon.builder.codegen.spi.BuilderCodegenExtension;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.classmodel.ClassBase;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.InnerClass;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.List;
import java.util.Optional;

interface TypeHandler {
    public static TypeHandler create(List<BuilderCodegenExtension> extensions, PrototypeInfo prototypeInfo, OptionInfo option) {
        TypeHandlerBasic handler = TypeHandler.handler(extensions, prototypeInfo, option);
        handler.prepareMethods();
        return handler;
    }

    public Optional<GeneratedMethod> optionMethod(OptionMethodType var1);

    public void fields(ClassBase.Builder<?, ?> var1, boolean var2);

    public TypeName type();

    public void setters(InnerClass.Builder var1);

    public void generateFromConfig(Method.Builder var1, OptionConfigured var2);

    public boolean builderGetterOptional();

    public void fromBuilderAssignment(ContentBuilder<?> var1);

    public void fromPrototypeAssignment(ContentBuilder<?> var1);

    private static TypeHandlerBasic handler(List<BuilderCodegenExtension> extensions, PrototypeInfo prototypeInfo, OptionInfo option) {
        TypeName declaredType = option.declaredType();
        if (declaredType.isOptional()) {
            TypeHandler.checkTypeArgsSizeAndTypes(prototypeInfo, option, TypeNames.OPTIONAL, 1);
            return new TypeHandlerOptional(extensions, prototypeInfo, option);
        }
        if (declaredType.isSupplier()) {
            TypeHandler.checkTypeArgsSizeAndTypes(prototypeInfo, option, TypeNames.SUPPLIER, 1);
            return new TypeHandlerSupplier(extensions, prototypeInfo, option);
        }
        if (declaredType.isSet()) {
            TypeHandler.checkTypeArgsSizeAndTypes(prototypeInfo, option, TypeNames.SET, 1);
            return new TypeHandlerSet(extensions, prototypeInfo, option);
        }
        if (declaredType.isList()) {
            TypeHandler.checkTypeArgsSizeAndTypes(prototypeInfo, option, TypeNames.LIST, 1);
            return new TypeHandlerList(extensions, prototypeInfo, option);
        }
        if (declaredType.isMap()) {
            TypeHandler.checkTypeArgsSizeAndTypes(prototypeInfo, option, TypeNames.MAP, 2);
            return new TypeHandlerMap(extensions, prototypeInfo, option);
        }
        return new TypeHandlerBasic(extensions, prototypeInfo, option, option.declaredType());
    }

    private static void checkTypeArgsSizeAndTypes(PrototypeInfo prototypeInfo, OptionInfo option, TypeName declaredType, int expectedTypeArgs) {
        Object originatingElement = option.interfaceMethod().isPresent() ? option.interfaceMethod().get().originatingElementValue() : prototypeInfo.blueprint().originatingElementValue();
        List typeNames = option.declaredType().typeArguments();
        if (typeNames.size() != expectedTypeArgs) {
            throw new CodegenException("Option of type " + declaredType.fqName() + " must have " + expectedTypeArgs + " type arguments defined, but option \"" + option.name() + "\" does not", originatingElement);
        }
        for (TypeName typeName : typeNames) {
            if (!typeName.wildcard()) continue;
            throw new CodegenException("Property of type " + option.declaredType().resolvedName() + " is not supported for builder, as wildcards cannot be handled correctly in setters", originatingElement);
        }
    }
}

