/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.builder.codegen.FactoryMethod;
import io.helidon.builder.codegen.OptionBuilder;
import io.helidon.common.Errors;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface RuntimeTypeInfo
extends Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RuntimeTypeInfo instance) {
        return (Builder)RuntimeTypeInfo.builder().from(instance);
    }

    public Optional<FactoryMethod> factoryMethod();

    public OptionBuilder optionBuilder();

    public static class Builder
    extends BuilderBase<Builder, RuntimeTypeInfo>
    implements io.helidon.common.Builder<Builder, RuntimeTypeInfo> {
        private Builder() {
        }

        public RuntimeTypeInfo buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.RuntimeTypeInfoImpl(this);
        }

        public RuntimeTypeInfo build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends RuntimeTypeInfo>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private FactoryMethod factoryMethod;
        private OptionBuilder optionBuilder;

        protected BuilderBase() {
        }

        public BUILDER from(RuntimeTypeInfo prototype) {
            this.factoryMethod(prototype.factoryMethod());
            this.optionBuilder(prototype.optionBuilder());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.factoryMethod().ifPresent(this::factoryMethod);
            builder.optionBuilder().ifPresent(this::optionBuilder);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearFactoryMethod() {
            this.factoryMethod = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER factoryMethod(FactoryMethod factoryMethod) {
            Objects.requireNonNull(factoryMethod);
            this.factoryMethod = factoryMethod;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER factoryMethod(Consumer<FactoryMethod.Builder> consumer) {
            Objects.requireNonNull(consumer);
            FactoryMethod.Builder builder = FactoryMethod.builder();
            consumer.accept(builder);
            this.factoryMethod(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER factoryMethod(Supplier<? extends FactoryMethod> supplier) {
            Objects.requireNonNull(supplier);
            this.factoryMethod(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER optionBuilder(OptionBuilder optionBuilder) {
            Objects.requireNonNull(optionBuilder);
            this.optionBuilder = optionBuilder;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER optionBuilder(Consumer<OptionBuilder.Builder> consumer) {
            Objects.requireNonNull(consumer);
            OptionBuilder.Builder builder = OptionBuilder.builder();
            consumer.accept(builder);
            this.optionBuilder(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER optionBuilder(Supplier<? extends OptionBuilder> supplier) {
            Objects.requireNonNull(supplier);
            this.optionBuilder(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<FactoryMethod> factoryMethod() {
            return Optional.ofNullable(this.factoryMethod);
        }

        public Optional<OptionBuilder> optionBuilder() {
            return Optional.ofNullable(this.optionBuilder);
        }

        public String toString() {
            return "RuntimeTypeInfoBuilder{factoryMethod=" + String.valueOf(this.factoryMethod) + ",optionBuilder=" + String.valueOf(this.optionBuilder) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.optionBuilder == null) {
                collector.fatal(this.getClass(), "Property \"optionBuilder\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER factoryMethod(Optional<? extends FactoryMethod> factoryMethod) {
            Objects.requireNonNull(factoryMethod);
            this.factoryMethod = factoryMethod.map(FactoryMethod.class::cast).orElse(this.factoryMethod);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class RuntimeTypeInfoImpl
        implements RuntimeTypeInfo {
            private final Optional<FactoryMethod> factoryMethod;
            private final OptionBuilder optionBuilder;

            protected RuntimeTypeInfoImpl(BuilderBase<?, ?> builder) {
                this.factoryMethod = builder.factoryMethod().map(Function.identity());
                this.optionBuilder = builder.optionBuilder().get();
            }

            @Override
            public Optional<FactoryMethod> factoryMethod() {
                return this.factoryMethod;
            }

            @Override
            public OptionBuilder optionBuilder() {
                return this.optionBuilder;
            }

            public String toString() {
                return "RuntimeTypeInfo{factoryMethod=" + String.valueOf(this.factoryMethod) + ",optionBuilder=" + String.valueOf(this.optionBuilder) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RuntimeTypeInfo)) {
                    return false;
                }
                RuntimeTypeInfo other = (RuntimeTypeInfo)o;
                return Objects.equals(this.factoryMethod, other.factoryMethod()) && Objects.equals(this.optionBuilder, other.optionBuilder());
            }

            public int hashCode() {
                return Objects.hash(this.factoryMethod, this.optionBuilder);
            }
        }
    }
}

