/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.types.TypeName;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface OptionProvider
extends Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OptionProvider instance) {
        return (Builder)OptionProvider.builder().from(instance);
    }

    public TypeName providerType();

    public boolean discoverServices();

    public static class Builder
    extends BuilderBase<Builder, OptionProvider>
    implements io.helidon.common.Builder<Builder, OptionProvider> {
        private Builder() {
        }

        public OptionProvider buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OptionProviderImpl(this);
        }

        public OptionProvider build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OptionProvider>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean discoverServices;
        private TypeName providerType;

        protected BuilderBase() {
        }

        public BUILDER from(OptionProvider prototype) {
            this.providerType(prototype.providerType());
            this.discoverServices(prototype.discoverServices());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.providerType().ifPresent(this::providerType);
            this.discoverServices(builder.discoverServices());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER providerType(TypeName providerType) {
            Objects.requireNonNull(providerType);
            this.providerType = providerType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER providerType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.providerType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER providerType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.providerType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER discoverServices(boolean discoverServices) {
            this.discoverServices = discoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypeName> providerType() {
            return Optional.ofNullable(this.providerType);
        }

        public boolean discoverServices() {
            return this.discoverServices;
        }

        public String toString() {
            return "OptionProviderBuilder{providerType=" + String.valueOf(this.providerType) + ",discoverServices=" + this.discoverServices + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.providerType == null) {
                collector.fatal(this.getClass(), "Property \"providerType\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class OptionProviderImpl
        implements OptionProvider {
            private final boolean discoverServices;
            private final TypeName providerType;

            protected OptionProviderImpl(BuilderBase<?, ?> builder) {
                this.providerType = builder.providerType().get();
                this.discoverServices = builder.discoverServices();
            }

            @Override
            public TypeName providerType() {
                return this.providerType;
            }

            @Override
            public boolean discoverServices() {
                return this.discoverServices;
            }

            public String toString() {
                return "OptionProvider{providerType=" + String.valueOf(this.providerType) + ",discoverServices=" + this.discoverServices + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OptionProvider)) {
                    return false;
                }
                OptionProvider other = (OptionProvider)o;
                return Objects.equals(this.providerType, other.providerType()) && this.discoverServices == other.discoverServices();
            }

            public int hashCode() {
                return Objects.hash(this.providerType, this.discoverServices);
            }
        }
    }
}

