/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public interface OptionDeprecation
extends Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OptionDeprecation instance) {
        return (Builder)OptionDeprecation.builder().from(instance);
    }

    public String message();

    public boolean forRemoval();

    public Optional<String> alternative();

    public Optional<String> since();

    public static class Builder
    extends BuilderBase<Builder, OptionDeprecation>
    implements io.helidon.common.Builder<Builder, OptionDeprecation> {
        private Builder() {
        }

        public OptionDeprecation buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OptionDeprecationImpl(this);
        }

        public OptionDeprecation build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OptionDeprecation>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean forRemoval = true;
        private String alternative;
        private String message;
        private String since;

        protected BuilderBase() {
        }

        public BUILDER from(OptionDeprecation prototype) {
            this.message(prototype.message());
            this.forRemoval(prototype.forRemoval());
            this.alternative(prototype.alternative());
            this.since(prototype.since());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.message().ifPresent(this::message);
            this.forRemoval(builder.forRemoval());
            builder.alternative().ifPresent(this::alternative);
            builder.since().ifPresent(this::since);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER message(String message) {
            Objects.requireNonNull(message);
            this.message = message;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER forRemoval(boolean forRemoval) {
            this.forRemoval = forRemoval;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAlternative() {
            this.alternative = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER alternative(String alternative) {
            Objects.requireNonNull(alternative);
            this.alternative = alternative;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSince() {
            this.since = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER since(String since) {
            Objects.requireNonNull(since);
            this.since = since;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> message() {
            return Optional.ofNullable(this.message);
        }

        public boolean forRemoval() {
            return this.forRemoval;
        }

        public Optional<String> alternative() {
            return Optional.ofNullable(this.alternative);
        }

        public Optional<String> since() {
            return Optional.ofNullable(this.since);
        }

        public String toString() {
            return "OptionDeprecationBuilder{message=" + this.message + ",forRemoval=" + this.forRemoval + ",alternative=" + this.alternative + ",since=" + this.since + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.message == null) {
                collector.fatal(this.getClass(), "Property \"message\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER alternative(Optional<String> alternative) {
            Objects.requireNonNull(alternative);
            this.alternative = alternative.orElse(this.alternative);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER since(Optional<String> since) {
            Objects.requireNonNull(since);
            this.since = since.orElse(this.since);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class OptionDeprecationImpl
        implements OptionDeprecation {
            private final boolean forRemoval;
            private final Optional<String> alternative;
            private final Optional<String> since;
            private final String message;

            protected OptionDeprecationImpl(BuilderBase<?, ?> builder) {
                this.message = builder.message().get();
                this.forRemoval = builder.forRemoval();
                this.alternative = builder.alternative().map(Function.identity());
                this.since = builder.since().map(Function.identity());
            }

            @Override
            public String message() {
                return this.message;
            }

            @Override
            public boolean forRemoval() {
                return this.forRemoval;
            }

            @Override
            public Optional<String> alternative() {
                return this.alternative;
            }

            @Override
            public Optional<String> since() {
                return this.since;
            }

            public String toString() {
                return "OptionDeprecation{message=" + this.message + ",forRemoval=" + this.forRemoval + ",alternative=" + String.valueOf(this.alternative) + ",since=" + String.valueOf(this.since) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OptionDeprecation)) {
                    return false;
                }
                OptionDeprecation other = (OptionDeprecation)o;
                return Objects.equals(this.message, other.message()) && this.forRemoval == other.forRemoval() && Objects.equals(this.alternative, other.alternative()) && Objects.equals(this.since, other.since());
            }

            public int hashCode() {
                return Objects.hash(this.message, this.forRemoval, this.alternative, this.since);
            }
        }
    }
}

