/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.common.Errors;
import io.helidon.common.types.TypedElementInfo;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface GeneratedMethod
extends Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GeneratedMethod instance) {
        return (Builder)GeneratedMethod.builder().from(instance);
    }

    public TypedElementInfo method();

    public Consumer<ContentBuilder<?>> contentBuilder();

    public Optional<Javadoc> javadoc();

    public static class Builder
    extends BuilderBase<Builder, GeneratedMethod>
    implements io.helidon.common.Builder<Builder, GeneratedMethod> {
        private Builder() {
        }

        public GeneratedMethod buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.GeneratedMethodImpl(this);
        }

        public GeneratedMethod build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends GeneratedMethod>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private Consumer<ContentBuilder<?>> contentBuilder;
        private Javadoc javadoc;
        private TypedElementInfo method;

        protected BuilderBase() {
        }

        public BUILDER from(GeneratedMethod prototype) {
            this.method(prototype.method());
            this.contentBuilder(prototype.contentBuilder());
            this.javadoc(prototype.javadoc());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.method().ifPresent(this::method);
            builder.contentBuilder().ifPresent(this::contentBuilder);
            builder.javadoc().ifPresent(this::javadoc);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER method(TypedElementInfo method) {
            Objects.requireNonNull(method);
            this.method = method;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER method(Consumer<TypedElementInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypedElementInfo.Builder builder = TypedElementInfo.builder();
            consumer.accept(builder);
            this.method(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER method(Supplier<? extends TypedElementInfo> supplier) {
            Objects.requireNonNull(supplier);
            this.method(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contentBuilder(Consumer<ContentBuilder<?>> contentBuilder) {
            Objects.requireNonNull(contentBuilder);
            this.contentBuilder = contentBuilder;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearJavadoc() {
            this.javadoc = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER javadoc(Javadoc javadoc) {
            Objects.requireNonNull(javadoc);
            this.javadoc = javadoc;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER javadoc(Consumer<Javadoc.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Javadoc.Builder builder = Javadoc.builder();
            consumer.accept(builder);
            this.javadoc(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER javadoc(Supplier<? extends Javadoc> supplier) {
            Objects.requireNonNull(supplier);
            this.javadoc(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypedElementInfo> method() {
            return Optional.ofNullable(this.method);
        }

        public Optional<Consumer<ContentBuilder<?>>> contentBuilder() {
            return Optional.ofNullable(this.contentBuilder);
        }

        public Optional<Javadoc> javadoc() {
            return Optional.ofNullable(this.javadoc);
        }

        public String toString() {
            return "GeneratedMethodBuilder{method=" + String.valueOf(this.method) + ",contentBuilder=" + String.valueOf(this.contentBuilder) + ",javadoc=" + String.valueOf(this.javadoc) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.method == null) {
                collector.fatal(this.getClass(), "Property \"method\" must not be null, but not set");
            }
            if (this.contentBuilder == null) {
                collector.fatal(this.getClass(), "Property \"contentBuilder\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER javadoc(Optional<? extends Javadoc> javadoc) {
            Objects.requireNonNull(javadoc);
            this.javadoc = javadoc.map(Javadoc.class::cast).orElse(this.javadoc);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class GeneratedMethodImpl
        implements GeneratedMethod {
            private final Consumer<ContentBuilder<?>> contentBuilder;
            private final Optional<Javadoc> javadoc;
            private final TypedElementInfo method;

            protected GeneratedMethodImpl(BuilderBase<?, ?> builder) {
                this.method = builder.method().get();
                this.contentBuilder = builder.contentBuilder().get();
                this.javadoc = builder.javadoc().map(Function.identity());
            }

            @Override
            public TypedElementInfo method() {
                return this.method;
            }

            @Override
            public Consumer<ContentBuilder<?>> contentBuilder() {
                return this.contentBuilder;
            }

            @Override
            public Optional<Javadoc> javadoc() {
                return this.javadoc;
            }

            public String toString() {
                return "GeneratedMethod{method=" + String.valueOf(this.method) + ",contentBuilder=" + String.valueOf(this.contentBuilder) + ",javadoc=" + String.valueOf(this.javadoc) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GeneratedMethod)) {
                    return false;
                }
                GeneratedMethod other = (GeneratedMethod)o;
                return Objects.equals(this.method, other.method()) && Objects.equals(this.contentBuilder, other.contentBuilder()) && Objects.equals(this.javadoc, other.javadoc());
            }

            public int hashCode() {
                return Objects.hash(this.method, this.contentBuilder, this.javadoc);
            }
        }
    }
}

