/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.DeprecatedFactoryMethod;
import io.helidon.builder.codegen.FactoryMethod;
import io.helidon.builder.codegen.OptionAllowedValue;
import io.helidon.builder.codegen.OptionBuilder;
import io.helidon.builder.codegen.OptionConfigured;
import io.helidon.builder.codegen.OptionDeprecation;
import io.helidon.builder.codegen.OptionInfo;
import io.helidon.builder.codegen.OptionProvider;
import io.helidon.builder.codegen.OptionSingular;
import io.helidon.builder.codegen.PrototypeInfo;
import io.helidon.builder.codegen.RuntimeTypeInfo;
import io.helidon.builder.codegen.Types;
import io.helidon.builder.codegen.Utils;
import io.helidon.builder.codegen.ValidationTask;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenLogger;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.CodegenValidator;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.common.Errors;
import io.helidon.common.Severity;
import io.helidon.common.Size;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementSignature;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.net.URI;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

final class FactoryOption {
    private static final Set<String> IGNORED_NAMES = Set.of("build", "get", "buildPrototype");
    private static final Set<ElementSignature> IGNORED_METHODS = Set.of(ElementSignature.createMethod((TypeName)TypeName.create(Boolean.TYPE), (String)"equals", List.of(TypeNames.OBJECT)), ElementSignature.createMethod((TypeName)TypeName.create(Integer.TYPE), (String)"hashCode", List.of()), ElementSignature.createMethod((TypeName)TypeNames.STRING, (String)"toString", List.of()));
    private static final Set<String> RESERVED_WORDS = Set.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null");

    private FactoryOption() {
    }

    static void options(CodegenContext ctx, RoundContext roundContext, PrototypeInfo prototypeInfo, List<OptionInfo> newOptions, List<OptionInfo> existingOptions) {
        HashSet<TypeName> alreadyHandledInterfaces = new HashSet<TypeName>();
        alreadyHandledInterfaces.add(TypeNames.SUPPLIER);
        ArrayList<TypeInfo> typeScope = new ArrayList<TypeInfo>();
        prototypeInfo.superPrototype().ifPresent(superPrototype -> {
            TypeInfo superPrototypeInfo = (TypeInfo)roundContext.typeInfo(superPrototype).or(() -> roundContext.typeInfo(((TypeName.Builder)TypeName.builder((TypeName)superPrototype).className(superPrototype.className() + "Blueprint")).build())).get();
            FactoryOption.allRelevantInterfaces(superPrototypeInfo, typeScope, alreadyHandledInterfaces);
            FactoryOption.discoverOptions(ctx, roundContext, prototypeInfo, existingOptions, typeScope);
        });
        typeScope.clear();
        FactoryOption.allRelevantInterfaces(prototypeInfo.blueprint(), typeScope, alreadyHandledInterfaces);
        FactoryOption.discoverOptions(ctx, roundContext, prototypeInfo, newOptions, typeScope);
    }

    static void allRelevantInterfaces(TypeInfo baseType, List<TypeInfo> result, Set<TypeName> toIgnore) {
        if (FactoryOption.validInterface(baseType)) {
            result.add(baseType);
        }
        List typeInfos = baseType.interfaceTypeInfo();
        for (TypeInfo typeInfo : typeInfos) {
            if (!toIgnore.add(typeInfo.typeName())) continue;
            FactoryOption.allRelevantInterfaces(typeInfo, result, toIgnore);
        }
    }

    private static boolean validInterface(TypeInfo baseType) {
        if (ValidationTask.doesImplement(baseType, Types.PROTOTYPE_API)) {
            return false;
        }
        TypeName typeName = baseType.typeName().genericTypeName();
        if (typeName.isSupplier()) {
            return false;
        }
        return !typeName.equals((Object)Types.PROTOTYPE_FACTORY);
    }

    private static void discoverOptions(CodegenContext ctx, RoundContext roundContext, PrototypeInfo prototypeInfo, List<OptionInfo> options, List<TypeInfo> typeScope) {
        HashSet<ElementSignature> ignoredDefaultMethods = new HashSet<ElementSignature>();
        for (TypeInfo typeInfo : typeScope) {
            FactoryOption.discoverOptions(ctx, roundContext, prototypeInfo, options, typeInfo, ignoredDefaultMethods);
        }
    }

    private static void discoverOptions(CodegenContext ctx, RoundContext roundContext, PrototypeInfo prototypeInfo, List<OptionInfo> options, TypeInfo typeInfo, Set<ElementSignature> ignoredDefaultMethods) {
        List<TypedElementInfo> candidates = FactoryOption.optionCandidates(ctx, prototypeInfo, typeInfo, ignoredDefaultMethods);
        for (TypedElementInfo candidate : candidates) {
            options.add(FactoryOption.create(roundContext, prototypeInfo, typeInfo, candidate));
        }
    }

    private static List<TypedElementInfo> optionCandidates(CodegenContext ctx, PrototypeInfo prototypeInfo, TypeInfo typeInfo, Set<ElementSignature> ignoredDefaultMethods) {
        List<TypedElementInfo> candidates = typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(it -> FactoryOption.validOptionMethod(prototypeInfo.defaultMethodsPredicate(), ignoredDefaultMethods, it)).filter(FactoryOption::validOptionMethodName).toList();
        Errors.Collector collector = Errors.collector();
        for (TypedElementInfo candidate : candidates) {
            if (candidate.typeName().unboxed().equals((Object)TypeNames.PRIMITIVE_VOID)) {
                collector.warn("Builder definition methods cannot have void return type (must be getters): " + typeInfo.typeName().fqName() + "." + candidate.elementName());
            }
            if (candidate.parameterArguments().isEmpty()) continue;
            collector.warn("Builder definition methods cannot have parameters (must be getters): " + typeInfo.typeName().fqName() + "." + candidate.elementName());
        }
        CodegenLogger logger = ctx.logger();
        collector.collect().forEach(errorMessage -> {
            System.Logger.Level level = switch (errorMessage.getSeverity()) {
                default -> throw new MatchException(null, null);
                case Severity.FATAL -> System.Logger.Level.ERROR;
                case Severity.WARN -> System.Logger.Level.WARNING;
                case Severity.HINT -> System.Logger.Level.INFO;
            };
            logger.log(level, errorMessage.getMessage());
        });
        candidates = candidates.stream().filter(it -> !it.typeName().unboxed().equals((Object)TypeNames.PRIMITIVE_VOID)).filter(it -> it.parameterArguments().isEmpty()).toList();
        return candidates;
    }

    private static OptionInfo create(RoundContext roundContext, PrototypeInfo prototypeInfo, TypeInfo typeInfo, TypedElementInfo candidate) {
        boolean recordStyle = prototypeInfo.recordStyle();
        OptionInfo.Builder option = OptionInfo.builder();
        TypeName type = FactoryOption.propertyTypeName(candidate);
        String maybeReservedName = FactoryOption.propertyName(candidate.elementName(), type.boxed().equals((Object)TypeNames.BOXED_BOOLEAN), recordStyle);
        String getterName = candidate.elementName();
        String setterName = FactoryOption.setterName(maybeReservedName, recordStyle);
        String name = FactoryOption.optionName(maybeReservedName);
        boolean sameGeneric = candidate.hasAnnotation(Types.OPTION_SAME_GENERIC);
        boolean confidential = candidate.hasAnnotation(Types.OPTION_CONFIDENTIAL);
        Optional redundantAnnotation = candidate.findAnnotation(Types.OPTION_REDUNDANT);
        boolean toStringValue = redundantAnnotation.flatMap(it -> it.getValue("stringValue")).map(Boolean::parseBoolean).orElse(false) == false;
        boolean equality = redundantAnnotation.flatMap(it -> it.getValue("equality")).map(Boolean::parseBoolean).orElse(false) == false;
        boolean registryService = candidate.hasAnnotation(Types.OPTION_REGISTRY_SERVICE);
        List<Annotation> qualifiers = candidate.annotations().stream().filter(a -> a.hasMetaAnnotation(Types.SERVICE_QUALIFIER)).toList();
        ((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)option.interfaceMethod(candidate)).name(name)).declaringType(typeInfo)).declaredType(type)).includeInEqualsAndHashCode(equality)).includeInToString(toStringValue)).confidential(confidential)).registryService(registryService)).sameGeneric(sameGeneric)).qualifiers(qualifiers)).getterName(getterName)).setterName(setterName);
        FactoryOption.optionBuilder(roundContext, type).ifPresent(option::builderInfo);
        FactoryOption.runtimeTypeFactory(roundContext, prototypeInfo, option, type, name);
        candidate.findAnnotation(Types.OPTION_DECORATOR).flatMap(Annotation::typeValue).ifPresent(option::decorator);
        AccessModifier accessModifier = candidate.findAnnotation(Types.OPTION_ACCESS).flatMap(Annotation::stringValue).map(it -> it.isBlank() ? AccessModifier.PACKAGE_PRIVATE : AccessModifier.valueOf((String)it)).orElse(AccessModifier.PUBLIC);
        option.accessModifier(accessModifier);
        if (candidate.hasAnnotation(Types.OPTION_ALLOWED_VALUES)) {
            Annotation annotation = candidate.annotation(Types.OPTION_ALLOWED_VALUES);
            annotation.annotationValues().orElseGet(List::of).stream().forEach(it -> {
                String value = (String)it.stringValue().orElseThrow();
                String description = (String)it.stringValue("description").orElseThrow();
                option.addAllowedValue(av -> ((OptionAllowedValue.Builder)av.value(value)).description(description));
            });
        }
        Javadoc javadoc = FactoryOption.optionJavadoc(candidate, name);
        FactoryOption.addConfiguredOptionData(roundContext, prototypeInfo, option, candidate, type, name);
        FactoryOption.addDeprecatedOptionData(option, candidate, javadoc);
        FactoryOption.addProviderOptionData(option, candidate);
        FactoryOption.addDefaultValue(option, type, typeInfo.typeName(), candidate);
        FactoryOption.isOptionRequired(option, candidate, type);
        FactoryOption.addSingularOptionData(option, candidate, type, name);
        return option.build();
    }

    private static void runtimeTypeFactory(RoundContext roundContext, PrototypeInfo prototypeInfo, OptionInfo.Builder option, TypeName type, String optionName) {
        TypeName actualType = Utils.realType(type);
        if (actualType.equals((Object)TypeNames.OBJECT) || actualType.unboxed().primitive() || actualType.generic()) {
            return;
        }
        for (RuntimeTypeInfo runtimeTypeInfo : prototypeInfo.runtimeTypeFactories()) {
            FactoryMethod factory;
            if (runtimeTypeInfo.factoryMethod().isEmpty() || !Utils.typesEqual((factory = runtimeTypeInfo.factoryMethod().get()).returnType(), actualType) && !Utils.resolvedTypesEqual(factory.returnType(), type) || !factory.optionName().orElse(optionName).equals(optionName)) continue;
            option.runtimeType(runtimeTypeInfo);
            return;
        }
        TypeName prototype = prototypeInfo.prototypeType();
        for (DeprecatedFactoryMethod someFactory : prototypeInfo.deprecatedFactoryMethods()) {
            String supportedOption;
            TypeName param;
            TypedElementInfo referencedMethod = someFactory.method();
            String methodName = referencedMethod.elementName();
            TypeName returnType = referencedMethod.typeName();
            if (referencedMethod.parameterArguments().size() != 1 || Utils.typesEqual(returnType, prototype) || (param = ((TypedElementInfo)referencedMethod.parameterArguments().getFirst()).typeName()).equals((Object)Types.CONFIG) || param.equals((Object)Types.COMMON_CONFIG) || !Utils.typesEqual(actualType, returnType) && !Utils.resolvedTypesEqual(type, returnType) || !optionName.equals(supportedOption = FactoryOption.supportedOptionName(methodName, optionName))) continue;
            option.runtimeType(rtf -> ((RuntimeTypeInfo.Builder)rtf.factoryMethod(fm -> ((FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)fm.declaringType(someFactory.declaringType())).returnType(returnType)).methodName(methodName)).parameterType(((TypedElementInfo)referencedMethod.parameterArguments().getFirst()).typeName())).optionName(optionName))).optionBuilder(((OptionBuilder.Builder)((OptionBuilder.Builder)OptionBuilder.builder().builderMethodType(param)).builderType(Utils.prototypeBuilderType(param))).build()));
            return;
        }
        Optional optional = roundContext.typeInfo(actualType);
        if (optional.isEmpty()) {
            return;
        }
        Optional<TypeInfo> runtimeApi = ((TypeInfo)optional.get()).interfaceTypeInfo().stream().filter(it -> it.typeName().equals((Object)Types.RUNTIME_API)).findFirst();
        if (runtimeApi.isEmpty()) {
            return;
        }
        TypeName prototypeType = (TypeName)runtimeApi.get().typeName().typeArguments().getFirst();
        option.runtimeType(rt -> rt.optionBuilder(ob -> ((OptionBuilder.Builder)ob.builderMethodType(prototypeType)).builderType(Utils.prototypeBuilderType(prototypeType))));
    }

    private static Optional<OptionBuilder> optionBuilder(RoundContext roundContext, TypeName type) {
        TypeName actualType = Utils.realType(type);
        if (actualType.equals((Object)TypeNames.OBJECT) || actualType.unboxed().primitive() || actualType.generic()) {
            return Optional.empty();
        }
        Optional typeInfo = roundContext.typeInfo(actualType);
        if (typeInfo.isPresent()) {
            return FactoryOption.optionBuilder(roundContext, actualType, (TypeInfo)typeInfo.get());
        }
        return FactoryOption.optionBuilderGuessed(actualType);
    }

    private static String supportedOptionName(String methodName, String optionName) {
        if (methodName.equals("create") || !methodName.startsWith("create")) {
            return optionName;
        }
        return Utils.deCapitalize(methodName.substring("create".length()));
    }

    private static Optional<OptionBuilder> optionBuilder(RoundContext ctx, TypeName actualType, TypeInfo actualTypeInfo) {
        return actualTypeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(ElementInfoPredicates.elementName((String)"builder")).filter(it -> it.typeName().typeArguments().isEmpty()).filter(ElementInfoPredicates::hasNoArgs).filter(it -> ctx.typeInfo(it.typeName()).stream().flatMap(builderTypeInfo -> builderTypeInfo.elementInfo().stream()).filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isPublic).filter(ElementInfoPredicates::hasNoArgs).filter(m -> m.typeName().equals((Object)actualType) || actualType.packageName().isBlank() && m.typeName().className().equals(actualType.className())).anyMatch(ElementInfoPredicates.elementName((String)"build"))).findFirst().map(it -> ((OptionBuilder.Builder)((OptionBuilder.Builder)((OptionBuilder.Builder)((OptionBuilder.Builder)OptionBuilder.builder().buildMethodName("build")).builderMethodName(it.elementName())).builderType(it.typeName())).builderMethodType(actualType)).build());
    }

    private static Optional<OptionBuilder> optionBuilderGuessed(TypeName actualType) {
        TypeName builderType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)actualType).className("Builder")).addEnclosingName(actualType.className())).build();
        return Optional.of(((OptionBuilder.Builder)((OptionBuilder.Builder)((OptionBuilder.Builder)((OptionBuilder.Builder)OptionBuilder.builder().builderMethodName("builder")).builderType(builderType)).buildMethodName("build")).builderMethodType(actualType)).build());
    }

    private static void addSingularOptionData(OptionInfo.Builder option, TypedElementInfo element, TypeName returnType, String name) {
        if (element.hasAnnotation(Types.OPTION_SINGULAR)) {
            Object singularSetterName;
            Annotation singularAnnot = element.annotation(Types.OPTION_SINGULAR);
            String singularName = singularAnnot.value().filter(Predicate.not(String::isBlank)).orElseGet(() -> FactoryOption.singularName(name));
            boolean singularAddPrefix = singularAnnot.booleanValue("withPrefix").orElse(true);
            if (singularAddPrefix) {
                String prefix = returnType.isMap() ? "put" : "add";
                singularSetterName = prefix + CodegenUtil.capitalize((String)singularName);
            } else {
                singularSetterName = singularName;
            }
            option.singular(arg_0 -> FactoryOption.lambda$addSingularOptionData$23((String)singularSetterName, singularName, arg_0));
        }
    }

    private static String optionName(String maybeReservedName) {
        if (RESERVED_WORDS.contains(maybeReservedName)) {
            return "the" + CodegenUtil.capitalize((String)maybeReservedName);
        }
        return maybeReservedName;
    }

    private static boolean validOptionMethodName(TypedElementInfo element) {
        if (IGNORED_NAMES.contains(element.elementName())) {
            return false;
        }
        return !IGNORED_METHODS.contains(element.signature());
    }

    private static boolean validOptionMethod(Predicate<String> defaultMethods, Set<ElementSignature> ignoredDefaultMethods, TypedElementInfo element) {
        if (element.elementModifiers().contains(Modifier.DEFAULT)) {
            if (element.typeName().equals((Object)TypeNames.PRIMITIVE_BOOLEAN)) {
                return false;
            }
            if (element.parameterArguments().isEmpty()) {
                boolean test = defaultMethods.test(element.elementName());
                if (!test) {
                    ignoredDefaultMethods.add(element.signature());
                    return false;
                }
                return !ignoredDefaultMethods.contains(element.signature());
            }
            return false;
        }
        return !ignoredDefaultMethods.contains(element.signature());
    }

    private static void addDefaultValue(OptionInfo.Builder option, TypeName returnType, TypeName enclosingType, TypedElementInfo element) {
        OptionType optionType = OptionType.create(returnType);
        TypeName realType = FactoryOption.realType(returnType);
        if (element.hasAnnotation(Types.OPTION_DEFAULT)) {
            List defaults = element.annotation(Types.OPTION_DEFAULT).stringValues().orElseGet(List::of);
            option.defaultValue(optionType.toDefaultString(enclosingType, element, realType, defaults));
            return;
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_INT)) {
            List defaults = element.annotation(Types.OPTION_DEFAULT_INT).intValues().orElseGet(List::of);
            option.defaultValue(optionType.toDefault(enclosingType, element, realType, defaults));
            return;
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_LONG)) {
            List defaults = element.annotation(Types.OPTION_DEFAULT_LONG).longValues().orElseGet(List::of);
            option.defaultValue(optionType.toDefaultLongs(enclosingType, element, realType, defaults));
            return;
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_DOUBLE)) {
            List defaults = element.annotation(Types.OPTION_DEFAULT_DOUBLE).doubleValues().orElseGet(List::of);
            option.defaultValue(optionType.toDefaultDoubles(enclosingType, element, realType, defaults));
            return;
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_BOOLEAN)) {
            List defaults = element.annotation(Types.OPTION_DEFAULT_BOOLEAN).booleanValues().orElseGet(List::of);
            option.defaultValue(optionType.toDefault(enclosingType, element, realType, defaults));
            return;
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_METHOD)) {
            Annotation annotation = element.annotation(Types.OPTION_DEFAULT_METHOD);
            TypeName type = annotation.typeValue("type").filter(Predicate.not(arg_0 -> ((TypeName)Types.OPTION_DEFAULT_METHOD).equals(arg_0))).orElseGet(() -> ((TypedElementInfo)element).typeName());
            String name = (String)annotation.stringValue().orElseThrow();
            option.defaultValue(it -> it.addContent(type.genericTypeName()).addContent(".").addContent(name).addContent("()"));
            return;
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_CODE)) {
            String defaultCode = (String)element.annotation(Types.OPTION_DEFAULT_CODE).stringValue().orElseThrow();
            option.defaultValue(it -> it.addContent(defaultCode));
        }
    }

    private static TypeName realType(TypeName typeName) {
        if (typeName.isOptional() || typeName.isSet() || typeName.isList() || typeName.isSupplier()) {
            return FactoryOption.realType((TypeName)typeName.typeArguments().getFirst());
        }
        if (typeName.isMap()) {
            if (typeName.typeArguments().size() == 2) {
                return (TypeName)typeName.typeArguments().get(1);
            }
            return TypeNames.STRING;
        }
        return typeName;
    }

    private static void isOptionRequired(OptionInfo.Builder option, TypedElementInfo element, TypeName type) {
        boolean required = false;
        if (element.hasAnnotation(Types.OPTION_REQUIRED)) {
            required = true;
        } else if (type.array()) {
            required = true;
        } else if (!(type.isOptional() || type.isMap() || type.isSet() || type.isList())) {
            boolean bl = required = !type.primitive();
        }
        if (option.defaultValue().isPresent() && required) {
            required = false;
        }
        option.required(required);
    }

    private static String singularName(String optionName) {
        if (optionName.endsWith("s")) {
            return optionName.substring(0, optionName.length() - 1);
        }
        return optionName;
    }

    private static void addProviderOptionData(OptionInfo.Builder option, TypedElementInfo element) {
        if (element.hasAnnotation(Types.OPTION_PROVIDER)) {
            Annotation annotation = element.annotation(Types.OPTION_PROVIDER);
            option.provider(provider -> ((OptionProvider.Builder)provider.providerType((TypeName)annotation.typeValue().orElseThrow())).discoverServices(annotation.booleanValue("discoverServices").orElse(true)));
        }
    }

    private static void addConfiguredOptionData(RoundContext roundContext, PrototypeInfo prototypeInfo, OptionInfo.Builder option, TypedElementInfo element, TypeName returnType, String name) {
        if (element.hasAnnotation(Types.OPTION_CONFIGURED)) {
            Annotation annotation = element.annotation(Types.OPTION_CONFIGURED);
            String configKey = annotation.stringValue().filter(Predicate.not(String::isBlank)).orElseGet(() -> FactoryOption.toConfigKey(name));
            boolean merge = annotation.booleanValue("merge").orElse(false);
            boolean traverse = element.findAnnotation(Types.OPTION_TRAVERSE_CONFIG).flatMap(Annotation::booleanValue).orElseGet(() -> FactoryOption.traverseByDefault(returnType));
            OptionConfigured.Builder configured = (OptionConfigured.Builder)((OptionConfigured.Builder)((OptionConfigured.Builder)OptionConfigured.builder().configKey(configKey)).merge(merge)).traverse(traverse);
            FactoryOption.configFactoryMethod(roundContext, prototypeInfo, option, returnType, name, configured);
            option.configured((Supplier<OptionConfigured>)((Object)configured));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void configFactoryMethod(RoundContext roundContext, PrototypeInfo prototypeInfo, OptionInfo.Builder option, TypeName optionType, String optionName, OptionConfigured.Builder configured) {
        void var8_14;
        RuntimeTypeInfo runtimeTypeInfo;
        TypeName expectedPrototypeType;
        TypeName builderType;
        Optional builderInfo;
        TypeName actualType = Utils.realType(optionType);
        for (FactoryMethod factoryMethod : prototypeInfo.configFactories()) {
            if (Utils.typesEqual(factoryMethod.returnType(), actualType) && factoryMethod.optionName().orElse(optionName).equals(optionName)) {
                configured.factoryMethod(factoryMethod);
                return;
            }
            if (!Utils.resolvedTypesEqual(factoryMethod.returnType(), optionType) || !factoryMethod.optionName().orElse(optionName).equals(optionName)) continue;
            configured.factoryMethod(factoryMethod);
            return;
        }
        TypeName prototype = prototypeInfo.prototypeType();
        for (DeprecatedFactoryMethod someFactory : prototypeInfo.deprecatedFactoryMethods()) {
            String supportedOptionName;
            TypeName firstParam;
            TypedElementInfo referencedMethod = someFactory.method();
            String methodName = referencedMethod.elementName();
            TypeName returnType = referencedMethod.typeName();
            if (referencedMethod.parameterArguments().size() != 1 || Utils.typesEqual(returnType, prototype) || !(firstParam = ((TypedElementInfo)referencedMethod.parameterArguments().getFirst()).typeName()).equals((Object)Types.COMMON_CONFIG) && !firstParam.equals((Object)Types.CONFIG) || !(supportedOptionName = FactoryOption.supportedOptionName(methodName, optionName)).equals(optionName) || !Utils.typesEqual(returnType, actualType) && !Utils.resolvedTypesEqual(returnType, optionType)) continue;
            configured.factoryMethod(fm -> ((FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)fm.declaringType(someFactory.declaringType())).returnType(returnType)).methodName(methodName)).parameterType(firstParam)).optionName(optionName));
            return;
        }
        if (option.runtimeType().isPresent() && (builderInfo = roundContext.typeInfo(builderType = ((TypeName.Builder)TypeName.builder((TypeName)(expectedPrototypeType = (runtimeTypeInfo = option.runtimeType().get()).optionBuilder().builderMethodType())).className(expectedPrototypeType.className() + "Blueprint")).build())).isPresent() && ((TypeInfo)builderInfo.get()).hasAnnotation(Types.PROTOTYPE_CONFIGURED)) {
            configured.factoryMethod(fm -> ((FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)fm.declaringType(expectedPrototypeType)).returnType(expectedPrototypeType)).methodName("create")).parameterType(Types.CONFIG)).optionName(optionName));
            return;
        }
        if (actualType.packageName().isBlank()) {
            TypeName typeName = ((TypeName.Builder)TypeName.builder((TypeName)actualType).packageName(prototype.packageName())).build();
        } else {
            TypeName typeName = actualType;
        }
        TypeName blueprintType = ((TypeName.Builder)TypeName.builder((TypeName)var8_14).className(var8_14.className() + "Blueprint")).build();
        Optional blueprintInfo = roundContext.typeInfo(blueprintType);
        if (blueprintInfo.isPresent() && ((TypeInfo)blueprintInfo.get()).hasAnnotation(Types.PROTOTYPE_CONFIGURED)) {
            configured.factoryMethod(arg_0 -> FactoryOption.lambda$configFactoryMethod$31((TypeName)var8_14, optionName, arg_0));
            return;
        }
        Optional actualTypeInfo = roundContext.typeInfo(actualType);
        if (actualTypeInfo.isEmpty()) {
            return;
        }
        if (((TypeInfo)actualTypeInfo.get()).elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(it -> Utils.typesEqual(it.typeName(), actualType)).filter(it -> it.parameterArguments().size() == 1).map(it -> ((TypedElementInfo)it.parameterArguments().getFirst()).typeName()).anyMatch(it -> it.equals((Object)Types.COMMON_CONFIG) || it.equals((Object)Types.CONFIG))) {
            configured.factoryMethod(fm -> ((FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)fm.declaringType(actualType)).returnType(actualType)).methodName("create")).parameterType(Types.COMMON_CONFIG)).optionName(optionName));
        }
    }

    private static boolean traverseByDefault(TypeName typeName) {
        if (typeName.isMap()) {
            TypeName valueTypeName = (TypeName)typeName.typeArguments().get(1);
            return valueTypeName.equals((Object)TypeNames.STRING) || valueTypeName.unboxed().primitive();
        }
        return false;
    }

    private static String toConfigKey(String name) {
        char[] chars;
        StringBuilder result = new StringBuilder();
        for (char aChar : chars = name.toCharArray()) {
            if (Character.isUpperCase(aChar)) {
                if (result.isEmpty()) {
                    result.append(Character.toLowerCase(aChar));
                    continue;
                }
                result.append('-').append(Character.toLowerCase(aChar));
                continue;
            }
            result.append(aChar);
        }
        return result.toString();
    }

    private static void addDeprecatedOptionData(OptionInfo.Builder option, TypedElementInfo element, Javadoc javadoc) {
        boolean deprecated = false;
        boolean forRemoval = false;
        String since = null;
        String alternative = null;
        List description = javadoc.deprecation();
        if (element.hasAnnotation(Types.DEPRECATED)) {
            deprecated = true;
            Annotation annotation = element.annotation(Types.DEPRECATED);
            forRemoval = annotation.booleanValue("forRemoval").orElse(false);
            since = annotation.stringValue("since").filter(Predicate.not(String::isBlank)).orElse(null);
        }
        if (element.hasAnnotation(Types.OPTION_DEPRECATED)) {
            deprecated = true;
            alternative = element.annotation(Types.OPTION_DEPRECATED).value().orElse(null);
            description = null;
        }
        if (!deprecated) {
            return;
        }
        OptionDeprecation.Builder deprecation = (OptionDeprecation.Builder)OptionDeprecation.builder().forRemoval(forRemoval);
        if (since != null) {
            deprecation.since(since);
        }
        if (description == null) {
            deprecation.message("This option is deprecated");
        } else {
            deprecation.message(String.join((CharSequence)"\n", description));
        }
        if (alternative != null) {
            deprecation.alternative(alternative);
        }
        option.deprecation(deprecation.build());
    }

    private static Javadoc optionJavadoc(TypedElementInfo element, String optionName) {
        if (element.hasAnnotation(Types.BUILDER_DESCRIPTION)) {
            return Javadoc.parse((String)((String)element.annotation(Types.BUILDER_DESCRIPTION).stringValue().orElseThrow()));
        }
        if (element.description().isPresent()) {
            return Javadoc.parse((String)((String)element.description().get()));
        }
        return Javadoc.builder().addLine("Option " + optionName).returnDescription(optionName).build();
    }

    private static TypeName propertyTypeName(TypedElementInfo element) {
        return element.findAnnotation(Types.OPTION_TYPE).flatMap(Annotation::value).map(TypeName::create).orElseGet(() -> ((TypedElementInfo)element).typeName());
    }

    private static String setterName(String name, boolean recordStyle) {
        if (recordStyle && !RESERVED_WORDS.contains(name)) {
            return name;
        }
        return "set" + CodegenUtil.capitalize((String)name);
    }

    private static String propertyName(String getterName, boolean isBoolean, boolean recordStyle) {
        if (recordStyle) {
            return getterName;
        }
        if (isBoolean && getterName.startsWith("is")) {
            return Utils.deCapitalize(getterName.substring(2));
        }
        if (getterName.startsWith("get")) {
            return Utils.deCapitalize(getterName.substring(3));
        }
        return getterName;
    }

    private static /* synthetic */ void lambda$addSingularOptionData$23(String singularSetterName, String singularName, OptionSingular.Builder singular) {
        ((OptionSingular.Builder)singular.methodName(singularSetterName)).name(singularName);
    }

    private static enum OptionType {
        SINGLE,
        LIST,
        SET,
        MAP;


        static OptionType create(TypeName typeName) {
            if (typeName.isOptional()) {
                return OptionType.create((TypeName)typeName.typeArguments().getFirst());
            }
            if (typeName.isSet()) {
                return SET;
            }
            if (typeName.isList()) {
                return LIST;
            }
            if (typeName.isMap()) {
                return MAP;
            }
            return SINGLE;
        }

        Consumer<ContentBuilder<?>> toDefaultString(TypeName enclosingType, TypedElementInfo element, TypeName realType, List<String> defaults) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> OptionType.consumer(enclosingType, element, realType, this.singleDefault(element, defaults));
                case 1 -> OptionType.consumer(enclosingType, element, realType, defaults, TypeNames.LIST, Types.ARRAY_LIST);
                case 2 -> OptionType.consumer(enclosingType, element, realType, defaults, TypeNames.SET, Types.LINKED_HASH_SET);
                case 3 -> OptionType.map(enclosingType, element, realType, defaults);
            };
        }

        Consumer<ContentBuilder<?>> toDefaultLongs(TypeName enclosingType, TypedElementInfo element, TypeName realType, List<Long> defaults) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> OptionType.consumer(enclosingType, element, realType, String.valueOf(this.singleDefault(element, defaults)) + "L");
                case 1 -> OptionType.consumer(enclosingType, element, realType, this.longs(defaults), TypeNames.LIST, Types.ARRAY_LIST);
                case 2 -> OptionType.consumer(enclosingType, element, realType, this.longs(defaults), TypeNames.SET, Types.LINKED_HASH_SET);
                case 3 -> OptionType.map(enclosingType, element, realType, this.longs(defaults));
            };
        }

        Consumer<ContentBuilder<?>> toDefault(TypeName enclosingType, TypedElementInfo element, TypeName realType, List<?> defaults) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> OptionType.consumer(enclosingType, element, realType, String.valueOf(this.singleDefault(element, defaults)));
                case 1 -> OptionType.consumer(enclosingType, element, realType, this.toStrings(defaults), TypeNames.LIST, Types.ARRAY_LIST);
                case 2 -> OptionType.consumer(enclosingType, element, realType, this.toStrings(defaults), TypeNames.SET, Types.LINKED_HASH_SET);
                case 3 -> OptionType.map(enclosingType, element, realType, this.toStrings(defaults));
            };
        }

        Consumer<ContentBuilder<?>> toDefaultDoubles(TypeName enclosingType, TypedElementInfo element, TypeName realType, List<Double> defaults) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> OptionType.consumer(enclosingType, element, realType, String.valueOf(this.singleDefault(element, defaults)) + "D");
                case 1 -> OptionType.consumer(enclosingType, element, realType, this.doubles(defaults), TypeNames.LIST, Types.ARRAY_LIST);
                case 2 -> OptionType.consumer(enclosingType, element, realType, this.doubles(defaults), TypeNames.SET, Types.LINKED_HASH_SET);
                case 3 -> OptionType.map(enclosingType, element, realType, this.doubles(defaults));
            };
        }

        private static Consumer<ContentBuilder<?>> map(TypeName enclosingType, TypedElementInfo element, TypeName typeName, List<String> defaultValues) {
            if (defaultValues.size() % 2 != 0) {
                throw new CodegenException("Default value for a map does not have even number of entries:" + String.valueOf(defaultValues), (Object)element);
            }
            return content -> {
                content.addContent("new ").addContent(Types.LINKED_HASH_MAP).addContent("<>(").addContent(TypeNames.MAP).addContent(".of(");
                for (int i = 1; i < defaultValues.size(); i += 2) {
                    content.addContentLiteral((String)defaultValues.get(i - 1)).addContent(", ");
                    OptionType.consumer(enclosingType, element, typeName, (String)defaultValues.get(i)).accept((ContentBuilder<?>)content);
                    if (i - 1 != defaultValues.size() - 2) {
                        content.addContentLine(", ");
                    }
                    if (i != 1) continue;
                    content.increaseContentPadding().increaseContentPadding();
                }
                content.addContent("))").decreaseContentPadding().decreaseContentPadding();
            };
        }

        private static Consumer<ContentBuilder<?>> consumer(TypeName enclosingType, TypedElementInfo element, TypeName typeName, List<String> defaultValues, TypeName collectionType, TypeName collectionImplType) {
            return content -> {
                content.addContent("new ").addContent(collectionImplType).addContent("<>(").addContent(collectionType).addContent(".of(");
                for (int i = 0; i < defaultValues.size(); ++i) {
                    OptionType.consumer(enclosingType, element, typeName, (String)defaultValues.get(i)).accept((ContentBuilder<?>)content);
                    if (i == defaultValues.size() - 1) continue;
                    content.addContent(", ");
                }
                content.addContent("))");
            };
        }

        private static Consumer<ContentBuilder<?>> consumer(TypeName enclosingType, TypedElementInfo element, TypeName typeName, String defaultValue) {
            if (TypeNames.STRING.equals((Object)typeName)) {
                return content -> content.addContent("\"").addContent(defaultValue).addContent("\"");
            }
            if (TypeNames.SIZE.equals((Object)typeName)) {
                CodegenValidator.validateSize((TypeName)enclosingType, (TypedElementInfo)element, (TypeName)Types.OPTION_DEFAULT, (String)"value", (String)defaultValue);
                return content -> content.addContent(Size.class).addContent(".parse(\"").addContent(defaultValue).addContent("\")");
            }
            if (TypeNames.DURATION.equals((Object)typeName)) {
                CodegenValidator.validateDuration((TypeName)enclosingType, (TypedElementInfo)element, (TypeName)Types.OPTION_DEFAULT, (String)"value", (String)defaultValue);
                return content -> content.addContent(Duration.class).addContent(".parse(\"").addContent(defaultValue).addContent("\")");
            }
            if (Types.CHAR_ARRAY.equals((Object)typeName)) {
                return content -> content.addContent("\"").addContent(defaultValue).addContent("\".toCharArray()");
            }
            if (Types.PATH.equals((Object)typeName)) {
                return content -> content.addContent(Paths.class).addContent(".get(\"").addContent(defaultValue).addContent("\")");
            }
            if (Types.URI.equals((Object)typeName)) {
                CodegenValidator.validateUri((TypeName)enclosingType, (TypedElementInfo)element, (TypeName)Types.OPTION_DEFAULT, (String)"value", (String)defaultValue);
                return content -> content.addContent(URI.class).addContent(".create(\"").addContent(defaultValue).addContent("\")");
            }
            if (typeName.primitive()) {
                if (typeName.fqName().equals("char")) {
                    return content -> content.addContent("'").addContent(defaultValue).addContent("'");
                }
                return content -> content.addContent(defaultValue);
            }
            if (typeName.name().startsWith("java.")) {
                return content -> content.addContent(defaultValue);
            }
            return content -> content.addContent(typeName.genericTypeName()).addContent(".").addContent(defaultValue);
        }

        private List<String> longs(List<Long> defaults) {
            return defaults.stream().map(it -> it + "L").toList();
        }

        private List<String> doubles(List<Double> defaults) {
            return defaults.stream().map(it -> it + "D").toList();
        }

        private List<String> toStrings(List<?> defaults) {
            return defaults.stream().map(String::valueOf).toList();
        }

        private <T> T singleDefault(TypedElementInfo element, List<T> defaultValues) {
            if (defaultValues.isEmpty()) {
                throw new CodegenException("Default values configured for " + this.name() + " are empty, one value is expected.", (Object)element);
            }
            if (defaultValues.size() > 1) {
                throw new CodegenException("Default values configured for " + this.name() + " contain more than one value, exactly one value is expected.", (Object)element);
            }
            return defaultValues.getFirst();
        }
    }
}

